/*
 * Decompiled with CFR 0.152.
 */
package com.metropolize.mtz_companions.navigation;

import com.metropolize.mtz_companions.core.MetropolizeBlockPos;
import com.metropolize.mtz_companions.entity.ServerCompanionEntity;
import com.metropolize.mtz_companions.navigation.UUIDEntityTracker;
import com.metropolize.mtzcharacterengine.MtzBrainOwner;
import com.metropolize.mtzcharacterengine.util.BrainUtils;
import java.util.List;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.behavior.BlockPosTracker;
import net.minecraft.world.entity.ai.behavior.EntityTracker;
import net.minecraft.world.entity.ai.behavior.PositionTracker;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.WalkTarget;
import net.minecraftforge.common.util.TriPredicate;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MtzWalkTarget
extends WalkTarget {
    private static final Logger log = LoggerFactory.getLogger(MtzWalkTarget.class);
    private final double closeEnoughDist;
    private boolean needsLineOfSight = true;
    private boolean needsToInteract = false;
    private double maxCost = Double.POSITIVE_INFINITY;
    private TriPredicate<Entity, MtzWalkTarget, BlockPos> predicate = (entity, target, blockPos) -> true;

    public MtzWalkTarget(BlockPos blockPos, float speedMod, double closeEnoughDist) {
        this((PositionTracker)new BlockPosTracker(blockPos), speedMod, closeEnoughDist);
    }

    public MtzWalkTarget(Entity entity, float speedMod, double closeEnoughDist) {
        this((PositionTracker)new EntityTracker(entity, false), speedMod, closeEnoughDist);
    }

    public MtzWalkTarget(ServerLevel level, UUID uuid, double closeEnoughDist) {
        this(new UUIDEntityTracker(level, uuid, false), 1.0f, closeEnoughDist);
    }

    public MtzWalkTarget(PositionTracker tracker, float speedMod, double closeEnoughDist) {
        super(tracker, speedMod, 0);
        this.closeEnoughDist = closeEnoughDist;
    }

    @Deprecated
    public int m_26422_() {
        throw new UnsupportedOperationException("Deprecated; call getCloseEnoughDistance() instead.");
    }

    public double getCloseEnoughDistance() {
        return this.closeEnoughDist;
    }

    public static List<MtzWalkTarget> fromMemories(ServerCompanionEntity entity) {
        List<MtzWalkTarget> mtzWalkTargets;
        WalkTarget walkTarget = (WalkTarget)BrainUtils.getMemory((MtzBrainOwner)entity, (MemoryModuleType)MemoryModuleType.f_26370_);
        if (walkTarget == null) {
            return null;
        }
        if (walkTarget instanceof MtzWalkTarget) {
            MtzWalkTarget mtzWalkTarget = (MtzWalkTarget)walkTarget;
            mtzWalkTargets = List.of(mtzWalkTarget);
        } else {
            mtzWalkTargets = List.of(new MtzWalkTarget(walkTarget.m_26420_(), walkTarget.m_26421_(), (double)walkTarget.m_26422_()));
        }
        return mtzWalkTargets;
    }

    public MtzWalkTarget withPredicate(TriPredicate<Entity, MtzWalkTarget, BlockPos> predicate) {
        this.predicate = predicate;
        return this;
    }

    public MtzWalkTarget withMaxCost(double cost) {
        this.maxCost = cost;
        return this;
    }

    public MtzWalkTarget withoutLineOfSight() {
        this.needsLineOfSight = false;
        return this;
    }

    public MtzWalkTarget canInteract() {
        this.needsLineOfSight = true;
        this.needsToInteract = true;
        return this;
    }

    public MetropolizeBlockPos getTargetBlockPos() {
        return new MetropolizeBlockPos(this.m_26420_().m_6675_());
    }

    public boolean isReached(ServerCompanionEntity entity, MetropolizeBlockPos blockPos) {
        UUIDEntityTracker uuidEntityTracker;
        PositionTracker positionTracker = this.m_26420_();
        if (positionTracker instanceof UUIDEntityTracker && (uuidEntityTracker = (UUIDEntityTracker)positionTracker).getEntity() == null) {
            return true;
        }
        return this.getTargetBlockPos().distanceTo(blockPos) <= this.closeEnoughDist && this.predicate.test((Object)entity, (Object)this, (Object)blockPos) && (!this.needsLineOfSight || entity.hasLineOfSight(entity.m_9236_(), (BlockPos)blockPos, this.getTargetBlockPos(), !this.needsToInteract));
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof WalkTarget) {
            WalkTarget target = (WalkTarget)obj;
            if (this.m_26420_().getClass() != target.m_26420_().getClass()) {
                return false;
            }
            PositionTracker positionTracker = this.m_26420_();
            if (positionTracker instanceof EntityTracker) {
                EntityTracker e1 = (EntityTracker)positionTracker;
                positionTracker = target.m_26420_();
                if (positionTracker instanceof EntityTracker) {
                    EntityTracker e2 = (EntityTracker)positionTracker;
                    return e1.m_147481_().equals((Object)e2.m_147481_());
                }
            }
            if ((positionTracker = this.m_26420_()) instanceof UUIDEntityTracker) {
                UUIDEntityTracker e1 = (UUIDEntityTracker)positionTracker;
                positionTracker = target.m_26420_();
                if (positionTracker instanceof UUIDEntityTracker) {
                    UUIDEntityTracker e2 = (UUIDEntityTracker)positionTracker;
                    return e1.getUUID().equals(e2.getUUID());
                }
            }
            return this.getTargetBlockPos().equals(target.m_26420_().m_6675_());
        }
        return false;
    }

    public int hashCode() {
        PositionTracker positionTracker = this.m_26420_();
        if (positionTracker instanceof UUIDEntityTracker) {
            UUIDEntityTracker uuidEntityTracker = (UUIDEntityTracker)positionTracker;
            return uuidEntityTracker.getUUID().hashCode();
        }
        return this.getTargetBlockPos().hashCode();
    }

    public String toString() {
        PositionTracker positionTracker = this.m_26420_();
        if (positionTracker instanceof UUIDEntityTracker) {
            UUIDEntityTracker uuidEntityTracker = (UUIDEntityTracker)positionTracker;
            return uuidEntityTracker.getUUID().toString();
        }
        return this.getTargetBlockPos().toString();
    }

    public CompoundTag getTag() {
        CompoundTag tag = new CompoundTag();
        PositionTracker positionTracker = this.m_26420_();
        if (positionTracker instanceof EntityTracker) {
            EntityTracker entityTracker = (EntityTracker)positionTracker;
            tag.m_128359_("type", "entity");
            tag.m_128362_("target", entityTracker.m_147481_().m_20148_());
        } else {
            positionTracker = this.m_26420_();
            if (positionTracker instanceof UUIDEntityTracker) {
                UUIDEntityTracker uuidEntityTracker = (UUIDEntityTracker)positionTracker;
                tag.m_128359_("type", "uuidEntity");
                tag.m_128362_("target", uuidEntityTracker.getUUID());
            } else {
                tag.m_128359_("type", "blockPos");
                tag.m_128365_("target", (Tag)NbtUtils.m_129224_((BlockPos)this.getTargetBlockPos()));
            }
        }
        tag.m_128347_("closeEnoughDist", this.closeEnoughDist);
        return tag;
    }

    @Nullable
    public static MtzWalkTarget fromTag(ServerLevel level, CompoundTag tag) {
        String type = tag.m_128461_("type");
        double closeEnoughDist = tag.m_128459_("closeEnoughDist");
        switch (type) {
            case "entity": {
                UUID uuid = tag.m_128342_("target");
                Entity entity = level.m_8791_(uuid);
                if (entity == null) {
                    log.error("Entity with UUID {} not found", (Object)uuid);
                    return null;
                }
                return new MtzWalkTarget(entity, 1.0f, closeEnoughDist);
            }
            case "uuidEntity": {
                UUID uuid2 = tag.m_128342_("target");
                return new MtzWalkTarget(level, uuid2, closeEnoughDist);
            }
            case "blockPos": {
                BlockPos blockPos = NbtUtils.m_129239_((CompoundTag)tag.m_128469_("target"));
                return new MtzWalkTarget(blockPos, 1.0f, closeEnoughDist);
            }
        }
        log.error("Unknown type tether {}", (Object)type);
        return null;
    }

    public boolean isNeedsLineOfSight() {
        return this.needsLineOfSight;
    }

    public boolean isNeedsToInteract() {
        return this.needsToInteract;
    }

    public double getMaxCost() {
        return this.maxCost;
    }

    public TriPredicate<Entity, MtzWalkTarget, BlockPos> getPredicate() {
        return this.predicate;
    }
}

