/*
 * Decompiled with CFR 0.152.
 */
package com.metropolize.mtz_companions.navigation;

import java.util.Optional;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.behavior.PositionTracker;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.NearestVisibleLivingEntities;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class UUIDEntityTracker
implements PositionTracker {
    private final ServerLevel level;
    private final UUID uuid;
    private final boolean trackEyeHeight;
    private Entity entity;

    public UUIDEntityTracker(ServerLevel serverLevel, UUID uuid, boolean trackEyeHeight) {
        this.level = serverLevel;
        this.uuid = uuid;
        this.trackEyeHeight = trackEyeHeight;
        this.entity = serverLevel.m_8791_(uuid);
    }

    public UUID getUUID() {
        return this.uuid;
    }

    @Nullable
    public Vec3 m_7024_() {
        Entity target = this.getEntity();
        if (target != null) {
            return this.trackEyeHeight ? this.entity.m_20182_().m_82520_(0.0, (double)this.entity.m_20192_(), 0.0) : this.entity.m_20182_();
        }
        return null;
    }

    @Nullable
    public BlockPos m_6675_() {
        Entity target = this.getEntity();
        if (target != null) {
            return target.m_20183_();
        }
        return null;
    }

    public boolean m_6826_(LivingEntity entity) {
        Entity target = this.getEntity();
        if (!(target instanceof LivingEntity)) {
            return true;
        }
        if (!target.m_6084_()) {
            return false;
        }
        Optional optional = entity.m_6274_().m_21952_(MemoryModuleType.f_148205_);
        return optional.isPresent() && ((NearestVisibleLivingEntities)optional.get()).m_186107_((LivingEntity)target);
    }

    public Entity getEntity() {
        if (this.entity == null) {
            this.entity = this.level.m_8791_(this.uuid);
        }
        return this.entity;
    }

    public String toString() {
        return "UUIDEntityTracker for " + this.uuid.toString();
    }
}

