/*
 * Decompiled with CFR 0.152.
 */
package com.metropolize.mtz_companions.navigation.client;

import com.metropolize.mtz_companions.navigation.path.Path;
import com.metropolize.mtz_companions.navigation.path.PathNode;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.core.BlockPos;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderLevelStageEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.joml.Matrix3f;
import org.joml.Matrix4f;

public class PathRenderer {
    static final EntityRenderDispatcher renderDispatcher = Minecraft.m_91087_().m_91290_();

    public static void renderPath(PoseStack poseStack, Path path) {
        for (int i = 0; i < path.length() - 1; ++i) {
            PathNode node = path.getNode(i);
            PathRenderer.renderLine(poseStack, node.pos, path.getNode((int)(i + 1)).pos);
            if (node.getBlockPosToPlace() == null) continue;
            PathRenderer.renderBlock(poseStack, node.getBlockPosToPlace());
        }
    }

    public static void renderLine(PoseStack poseStack, Vec3 start, Vec3 end) {
        VertexConsumer vertexConsumer = Minecraft.m_91087_().m_91269_().m_110104_().m_6299_((RenderType)RenderType.f_110371_);
        RenderSystem.lineWidth((float)0.3f);
        RenderSystem.setShader(GameRenderer::m_172757_);
        Matrix4f pose = poseStack.m_85850_().m_252922_();
        Matrix3f normal = poseStack.m_85850_().m_252943_();
        Vec3 cameraPosition = PathRenderer.renderDispatcher.f_114358_.m_90583_();
        Vec3 relativeStart = start.m_82546_(cameraPosition);
        Vec3 relativeEnd = end.m_82546_(cameraPosition);
        Vec3 unitDiff = end.m_82546_(start).m_82541_();
        vertexConsumer.m_252986_(pose, (float)relativeStart.f_82479_, (float)relativeStart.f_82480_, (float)relativeStart.f_82481_).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_252939_(normal, (float)unitDiff.f_82479_, (float)unitDiff.f_82480_, (float)unitDiff.f_82481_).m_5752_();
        vertexConsumer.m_252986_(pose, (float)relativeEnd.f_82479_, (float)relativeEnd.f_82480_, (float)relativeEnd.f_82481_).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_252939_(normal, (float)unitDiff.f_82479_, (float)unitDiff.f_82480_, (float)unitDiff.f_82481_).m_5752_();
    }

    public static void renderBlock(PoseStack poseStack, BlockPos blockPos) {
        VertexConsumer vertexConsumer = Minecraft.m_91087_().m_91269_().m_110104_().m_6299_((RenderType)RenderType.f_110371_);
        RenderSystem.lineWidth((float)0.3f);
        RenderSystem.setShader(GameRenderer::m_172757_);
        Vec3 cameraPosition = PathRenderer.renderDispatcher.f_114358_.m_90583_();
        Vec3 relativeStart = new Vec3((double)blockPos.m_123341_(), (double)blockPos.m_123342_(), (double)blockPos.m_123343_()).m_82546_(cameraPosition);
        LevelRenderer.m_109646_((PoseStack)poseStack, (VertexConsumer)vertexConsumer, (AABB)AABB.m_82333_((Vec3)relativeStart), (float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    @Mod.EventBusSubscriber(value={Dist.CLIENT})
    public static class PathRendererEvents {
        @SubscribeEvent
        public static void onWorldRenderLast(RenderLevelStageEvent event) {
        }

        static {
            MinecraftForge.EVENT_BUS.register(PathRendererEvents.class);
        }
    }
}

