/*
 * Decompiled with CFR 0.152.
 */
package com.metropolize.mtz_companions.navigation.exploration;

import com.metropolize.mtz_companions.entity.ServerCompanionEntity;
import com.metropolize.mtz_companions.navigation.exploration.ExplorationTreeNode;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Optional;
import java.util.Stack;
import lombok.NonNull;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;

public class ExplorationTree {
    public static final int MIN_NODE_SPACING = 6;
    private final ExplorationTreeNode head;
    private final HashSet<ExplorationTreeNode> nodes;

    public ExplorationTree(@NonNull BlockPos blockPos) {
        if (blockPos == null) {
            throw new NullPointerException("blockPos is marked non-null but is null");
        }
        this.head = new ExplorationTreeNode(blockPos);
        this.nodes = new HashSet();
        this.nodes.add(this.head);
    }

    public ExplorationTree(CompoundTag tag) {
        this.head = ExplorationTreeNode.fromTag(tag);
        this.nodes = new HashSet();
        Stack<ExplorationTreeNode> nodeStack = new Stack<ExplorationTreeNode>();
        nodeStack.push(this.head);
        while (!nodeStack.empty()) {
            ExplorationTreeNode toAdd = (ExplorationTreeNode)nodeStack.pop();
            this.nodes.add(toAdd);
            nodeStack.addAll(toAdd.getChildren());
        }
    }

    public boolean tryAddNode(@NonNull ExplorationTreeNode newNode) {
        if (newNode == null) {
            throw new NullPointerException("newNode is marked non-null but is null");
        }
        ExplorationTreeNode parent = this.nodes.stream().filter(node -> !node.isFullyExplored()).min(Comparator.comparingDouble(node -> node.distanceTo(newNode))).orElseThrow();
        return this.tryAddNode(newNode, parent);
    }

    public boolean tryAddNode(@NonNull ExplorationTreeNode newNode, @NonNull ExplorationTreeNode parent) {
        if (newNode == null) {
            throw new NullPointerException("newNode is marked non-null but is null");
        }
        if (parent == null) {
            throw new NullPointerException("parent is marked non-null but is null");
        }
        boolean added = this.nodes.add(newNode);
        if (!added) {
            return false;
        }
        parent.addChild(newNode);
        return true;
    }

    public CompoundTag createTag() {
        return this.head.createTag();
    }

    public Optional<ExplorationTreeNode> getNearest(BlockPos blockPos) {
        return this.nodes.stream().min(Comparator.comparingDouble(node -> node.getBlockPos().m_203198_(blockPos.m_123341_(), blockPos.m_123342_(), blockPos.m_123343_())));
    }

    public Optional<ExplorationTreeNode> explores(ServerCompanionEntity entity, BlockPos blockPos) {
        return this.nodes.stream().filter(node -> node.explores(entity, blockPos)).findAny();
    }

    public boolean equals(Object obj) {
        if (obj instanceof ExplorationTree) {
            ExplorationTree explorationTree = (ExplorationTree)obj;
            return explorationTree.getHead().equals(this.getHead());
        }
        return false;
    }

    public ExplorationTreeNode getHead() {
        return this.head;
    }

    public HashSet<ExplorationTreeNode> getNodes() {
        return this.nodes;
    }
}

