/*
 * Decompiled with CFR 0.152.
 */
package com.metropolize.mtz_companions.navigation.exploration;

import com.metropolize.mtz_companions.core.MetropolizeBlockPos;
import com.metropolize.mtz_companions.entity.ServerCompanionEntity;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;

public class ExplorationTreeNode {
    private ExplorationTreeNode parent = null;
    private final List<ExplorationTreeNode> children = new ArrayList<ExplorationTreeNode>();
    private final MetropolizeBlockPos blockPos;
    private int depth = 0;
    private boolean fullyExplored = false;

    public ExplorationTreeNode(BlockPos blockPos) {
        MetropolizeBlockPos mtzBlockPos;
        this.blockPos = blockPos instanceof MetropolizeBlockPos ? (mtzBlockPos = (MetropolizeBlockPos)blockPos) : new MetropolizeBlockPos(blockPos);
    }

    protected void addChild(ExplorationTreeNode node) {
        node.parent = this;
        node.depth = this.depth + 1;
        this.children.add(node);
    }

    public double distanceTo(ExplorationTreeNode node) {
        return this.getBlockPos().distanceTo(node.getBlockPos());
    }

    public double distanceTo(BlockPos pos) {
        return this.getBlockPos().distanceTo(pos);
    }

    public boolean equals(Object obj) {
        if (obj instanceof ExplorationTreeNode) {
            ExplorationTreeNode node = (ExplorationTreeNode)obj;
            return node.blockPos.equals((Object)this.blockPos);
        }
        return false;
    }

    public boolean explores(ServerCompanionEntity entity, BlockPos blockPos) {
        return this.blockPos.distanceTo(blockPos) < 6.0 || entity.hasLineOfSight(entity.m_9236_(), (BlockPos)this.blockPos, blockPos, true);
    }

    public CompoundTag createTag() {
        CompoundTag tag = new CompoundTag();
        tag.m_128365_("BlockPos", (Tag)NbtUtils.m_129224_((BlockPos)this.blockPos));
        tag.m_128379_("FullyExplored", this.fullyExplored);
        tag.m_128405_("Depth", this.depth);
        ListTag children = new ListTag();
        children.addAll(this.children.stream().map(ExplorationTreeNode::createTag).toList());
        tag.m_128365_("Children", (Tag)children);
        return tag;
    }

    public static ExplorationTreeNode fromTag(CompoundTag tag) {
        BlockPos pos = NbtUtils.m_129239_((CompoundTag)tag.m_128469_("BlockPos"));
        ExplorationTreeNode node = new ExplorationTreeNode(pos);
        node.fullyExplored = tag.m_128471_("FullyExplored");
        node.depth = tag.m_128451_("Depth");
        ListTag childrenTag = tag.m_128437_("Children", 10);
        childrenTag.forEach(t -> node.addChild(ExplorationTreeNode.fromTag((CompoundTag)t)));
        return node;
    }

    public ExplorationTreeNode getParent() {
        return this.parent;
    }

    public List<ExplorationTreeNode> getChildren() {
        return this.children;
    }

    public MetropolizeBlockPos getBlockPos() {
        return this.blockPos;
    }

    public int getDepth() {
        return this.depth;
    }

    public boolean isFullyExplored() {
        return this.fullyExplored;
    }

    public void setFullyExplored(boolean fullyExplored) {
        this.fullyExplored = fullyExplored;
    }
}

