/*
 * Decompiled with CFR 0.152.
 */
package com.metropolize.mtz_companions.navigation.move;

import com.metropolize.mtz_companions.core.MetropolizeBlockPos;
import com.metropolize.mtz_companions.entity.ServerCompanionEntity;
import com.metropolize.mtz_companions.navigation.move.Move;
import com.metropolize.mtz_companions.navigation.move.Moves;
import com.metropolize.mtz_companions.navigation.path.PathNode;
import com.metropolize.mtz_companions.navigation.path.PathNodeContext;
import com.metropolize.mtz_companions.navigation.utils.MovementUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LadderBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;

public class AscendMove
extends Move {
    protected AscendMove(int x, int y, int z) {
        super(x, y, z);
        assert (y == 1);
    }

    @Override
    public Move.Result from(ServerCompanionEntity entity, PathNode previousNode) {
        MetropolizeBlockPos blockPos = previousNode.blockPos;
        MetropolizeBlockPos result = new MetropolizeBlockPos(blockPos.m_123341_() + this.x, blockPos.m_123342_() + this.y, blockPos.m_123343_() + this.z);
        Vec3 resultPos = result.m_252807_().m_82520_(0.0, -0.5, 0.0);
        if (this == Moves.ASCEND_IN_PLACE) {
            Level level = entity.m_9236_();
            if (previousNode.blockState.isLadder((LevelReader)level, (BlockPos)blockPos, (LivingEntity)entity) && previousNode.blockState.m_60713_(Blocks.f_50155_)) {
                Direction direction = ((Direction)previousNode.blockState.m_61143_((Property)LadderBlock.f_54337_)).m_122424_();
                resultPos = resultPos.m_82549_(new Vec3(direction.m_253071_()).m_82490_(0.5));
            } else {
                return Move.Result.INVALID;
            }
        }
        PathNodeContext ctx = previousNode.pathNodeContext.clone();
        double cost = this.getCost(entity, blockPos, result, ctx);
        return new Move.Result(resultPos, cost, ctx);
    }

    @Override
    protected double getCost(ServerCompanionEntity entity, MetropolizeBlockPos from, MetropolizeBlockPos to, PathNodeContext ctx) {
        boolean isBackwardsJump;
        Level level = entity.m_9236_();
        MetropolizeBlockPos aboveBlock = from.above(2);
        double cost = 0.0;
        if ((cost += this.getCostToPassThrough(entity, ctx, aboveBlock, ctx.getBlockState(aboveBlock), true)) == Double.POSITIVE_INFINITY) {
            return Double.POSITIVE_INFINITY;
        }
        BlockState fromState = ctx.getBlockState(from);
        if (this == Moves.ASCEND_IN_PLACE) {
            if (!fromState.isLadder((LevelReader)level, (BlockPos)from, (LivingEntity)entity) && fromState.m_60713_(Blocks.f_50155_)) {
                return Double.POSITIVE_INFINITY;
            }
            return cost + from.distanceTo(to);
        }
        BlockState belowState = ctx.getBlockState(from.below());
        if (!(belowState.m_60713_(Blocks.f_50155_) || MovementUtils.canStandOn((Entity)entity, from.below(), belowState) || fromState.m_60819_().m_205070_(FluidTags.f_13131_))) {
            return Double.POSITIVE_INFINITY;
        }
        boolean bl = isBackwardsJump = belowState.m_60713_(Blocks.f_50155_) && ((Direction)belowState.m_61143_((Property)LadderBlock.f_54337_)).m_122436_().equals((Object)new Vec3i(this.x, 0, this.z));
        if (isBackwardsJump) {
            return Double.POSITIVE_INFINITY;
        }
        if (ctx.getBlockState(to.above()).m_60819_().m_205070_(FluidTags.f_13131_)) {
            return Double.POSITIVE_INFINITY;
        }
        return cost + super.getCost(entity, from, to, ctx);
    }
}

