/*
 * Decompiled with CFR 0.152.
 */
package com.metropolize.mtz_companions.navigation.move;

import com.metropolize.mtz_companions.core.MetropolizeBlockPos;
import com.metropolize.mtz_companions.entity.ServerCompanionEntity;
import com.metropolize.mtz_companions.navigation.move.Move;
import com.metropolize.mtz_companions.navigation.path.PathNode;
import com.metropolize.mtz_companions.navigation.path.PathNodeContext;
import com.metropolize.mtz_companions.utils.BlockPlacementUtils;
import net.minecraft.core.SectionPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;

public class BuildMove
extends Move {
    protected BuildMove(int x, int y, int z) {
        super(x, y, z);
    }

    @Override
    public Move.Result from(ServerCompanionEntity entity, PathNode previousNode) {
        MetropolizeBlockPos blockPos = previousNode.blockPos;
        MetropolizeBlockPos result = new MetropolizeBlockPos(blockPos.m_123341_() + this.x, blockPos.m_123342_() + this.y, blockPos.m_123343_() + this.z);
        PathNodeContext ctx = previousNode.pathNodeContext.clone();
        double cost = this.getCost(entity, blockPos, result, ctx);
        ctx.addBlockToPlace(result.below());
        return new Move.Result(result.m_252807_().m_82492_(0.0, 0.5, 0.0), cost, ctx);
    }

    @Override
    protected double getCost(ServerCompanionEntity entity, MetropolizeBlockPos from, MetropolizeBlockPos to, PathNodeContext ctx) {
        if (!entity.hasSpareBlocks()) {
            return Double.POSITIVE_INFINITY;
        }
        ChunkPos chunkPos = new ChunkPos(SectionPos.m_123171_((int)to.m_123341_()), SectionPos.m_123171_((int)to.m_123343_()));
        if (entity.m_146902_().m_45594_(chunkPos) > 10) {
            return Double.POSITIVE_INFINITY;
        }
        Level level = entity.m_9236_();
        double cost = 0.0;
        if ((cost += this.getCostToWalkThrough(entity, ctx, to)) == Double.POSITIVE_INFINITY) {
            return Double.POSITIVE_INFINITY;
        }
        MetropolizeBlockPos buildPos = to.below();
        if (!BlockPlacementUtils.canPlace(entity, (BlockItem)Items.f_42329_, buildPos)) {
            return Double.POSITIVE_INFINITY;
        }
        if (ctx.blocksPlaced.stream().noneMatch(blockPos -> blockPos.m_123333_((Vec3i)buildPos) == 1) && BlockPlacementUtils.getSupportingDirection(entity, level, buildPos) == null) {
            return Double.POSITIVE_INFINITY;
        }
        return cost + from.distanceTo(to) + 20.0;
    }
}

