/*
 * Decompiled with CFR 0.152.
 */
package com.metropolize.mtz_companions.navigation.move;

import com.metropolize.mtz_companions.core.MetropolizeBlockPos;
import com.metropolize.mtz_companions.entity.ServerCompanionEntity;
import com.metropolize.mtz_companions.navigation.move.Move;
import com.metropolize.mtz_companions.navigation.path.PathNode;
import com.metropolize.mtz_companions.navigation.path.PathNodeContext;
import com.metropolize.mtz_companions.navigation.utils.MovementUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public class DescendMove
extends Move {
    protected DescendMove(int x, int y, int z) {
        super(x, y, z);
        assert (y == -1);
    }

    @Override
    public Move.Result from(ServerCompanionEntity entity, PathNode previousNode) {
        MetropolizeBlockPos start = previousNode.blockPos;
        MetropolizeBlockPos result = new MetropolizeBlockPos(start.m_123341_() + this.x, start.m_123342_() - this.y, start.m_123343_() + this.z);
        Level level = entity.m_9236_();
        PathNodeContext ctx = previousNode.pathNodeContext.clone();
        BlockState blockState = ctx.getBlockState(result);
        double fallingCost = 0.0;
        while (MovementUtils.canPassThrough(ctx, result, blockState, true) && level.m_46739_((BlockPos)result)) {
            int fallDamage = Math.max(0, entity.m_5639_(start.m_123342_() - result.m_123342_(), 1.0f));
            fallingCost = fallDamage != 0 && (float)fallDamage > entity.m_21223_() - 1.0f ? Double.POSITIVE_INFINITY : (double)(fallDamage * 5);
            if (level.m_6425_((BlockPos)result).m_205070_(FluidTags.f_13131_)) {
                fallingCost = 0.0;
            }
            if (MovementUtils.canStandOn((Entity)entity, result.below(), ctx.getBlockState(result.below()))) break;
            result = result.below();
            blockState = ctx.getBlockState(result);
        }
        if (!level.m_46739_((BlockPos)result) || result.m_123342_() >= start.m_123342_()) {
            fallingCost = Double.POSITIVE_INFINITY;
        }
        double cost = this.getCost(entity, start, result, ctx) + fallingCost;
        Vec3 pos = result.m_252807_().m_82492_((double)this.x * -0.2, 0.5, (double)this.z * -0.2);
        return new Move.Result(pos, cost, ctx);
    }
}

