/*
 * Decompiled with CFR 0.152.
 */
package com.metropolize.mtz_companions.navigation.move;

import com.metropolize.mtz_companions.core.MetropolizeBlockPos;
import com.metropolize.mtz_companions.entity.ServerCompanionEntity;
import com.metropolize.mtz_companions.navigation.move.Move;
import com.metropolize.mtz_companions.navigation.path.PathNodeContext;
import com.metropolize.mtz_companions.navigation.utils.MovementUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;

public class DiagonalMove
extends Move {
    protected DiagonalMove(int x, int y, int z) {
        super(x, y, z);
    }

    @Override
    public double getCost(ServerCompanionEntity entity, MetropolizeBlockPos from, MetropolizeBlockPos to, PathNodeContext ctx) {
        boolean rightBlocked;
        double baseCost = super.getCost(entity, from, to, ctx);
        Level level = entity.m_9236_();
        MetropolizeBlockPos left = new MetropolizeBlockPos(from.m_123341_() + this.x, from.m_123342_(), from.m_123343_());
        MetropolizeBlockPos right = new MetropolizeBlockPos(from.m_123341_(), from.m_123342_(), from.m_123343_() + this.z);
        boolean leftBlocked = !MovementUtils.canWalkThrough(ctx, left);
        boolean bl = rightBlocked = !MovementUtils.canWalkThrough(ctx, right);
        if (leftBlocked && rightBlocked) {
            return Double.POSITIVE_INFINITY;
        }
        if (level.m_6425_((BlockPos)left).m_205070_(FluidTags.f_13132_) || level.m_6425_((BlockPos)right).m_205070_(FluidTags.f_13132_)) {
            return Double.POSITIVE_INFINITY;
        }
        if (!MovementUtils.canStandOn((Entity)entity, from.below(), ctx.getBlockState(from.below())) || !MovementUtils.canStandOn((Entity)entity, to.below(), ctx.getBlockState(to.below()))) {
            return Double.POSITIVE_INFINITY;
        }
        if (leftBlocked || rightBlocked) {
            return baseCost * 1.5;
        }
        return baseCost;
    }
}

