/*
 * Decompiled with CFR 0.152.
 */
package com.metropolize.mtz_companions.navigation.move;

import com.metropolize.mtz_companions.capabilities.IProtectedBlocksCapability;
import com.metropolize.mtz_companions.core.MetropolizeBlockPos;
import com.metropolize.mtz_companions.entity.ServerCompanionEntity;
import com.metropolize.mtz_companions.navigation.path.PathNode;
import com.metropolize.mtz_companions.navigation.path.PathNodeContext;
import com.metropolize.mtz_companions.navigation.utils.MovementUtils;
import com.metropolize.mtz_companions.utils.BlockBreakUtils;
import java.util.HashSet;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public class Move {
    protected static final int VIEW_DISTANCE = 10;
    protected static HashSet<Move> MOVES = new HashSet();
    public final int x;
    public final int y;
    public final int z;

    protected Move(int x, int y, int z) {
        if (Math.abs(x) > 1 || Math.abs(y) > 1 || Math.abs(z) > 1) {
            throw new IllegalArgumentException("x, y, and z must have magnitude 1 or 0.");
        }
        this.x = x;
        this.y = y;
        this.z = z;
        MOVES.add(this);
    }

    public Result from(ServerCompanionEntity entity, PathNode previousNode) {
        MetropolizeBlockPos blockPos = previousNode.blockPos;
        MetropolizeBlockPos result = new MetropolizeBlockPos(blockPos.m_123341_() + this.x, blockPos.m_123342_() + this.y, blockPos.m_123343_() + this.z);
        PathNodeContext ctx = previousNode.pathNodeContext.clone();
        double cost = this.getCost(entity, blockPos, result, ctx);
        return new Result(result.m_252807_().m_82492_(0.0, 0.5, 0.0), cost, ctx);
    }

    protected double getCost(ServerCompanionEntity entity, MetropolizeBlockPos from, MetropolizeBlockPos to, PathNodeContext ctx) {
        ChunkPos chunkPos = new ChunkPos(SectionPos.m_123171_((int)to.m_123341_()), SectionPos.m_123171_((int)to.m_123343_()));
        if (entity.m_146902_().m_45594_(chunkPos) > 10) {
            return Double.POSITIVE_INFINITY;
        }
        Level level = entity.m_9236_();
        double cost = 0.0;
        if ((cost += this.getCostToWalkThrough(entity, ctx, to)) == Double.POSITIVE_INFINITY) {
            return Double.POSITIVE_INFINITY;
        }
        BlockState lowerState = ctx.getBlockState(to.below());
        BlockState toState = ctx.getBlockState(to);
        if (!MovementUtils.canStandOn((Entity)entity, to.below(), lowerState) && !toState.isLadder((LevelReader)level, (BlockPos)to, (LivingEntity)entity)) {
            return Double.POSITIVE_INFINITY;
        }
        return cost + from.distanceTo(to);
    }

    protected double getCostToPassThrough(ServerCompanionEntity entity, PathNodeContext ctx, BlockPos blockPos, BlockState blockState, boolean isUpperBlock) {
        if (MovementUtils.canPassThrough(ctx, blockPos, blockState, isUpperBlock)) {
            return 0.0;
        }
        double costToBreak = this.getCostToBreak(ctx.level, entity, blockPos, blockState);
        if (costToBreak != Double.POSITIVE_INFINITY) {
            ctx.addBlockToBreak(new MetropolizeBlockPos(blockPos));
        }
        return costToBreak;
    }

    protected double getCostToWalkThrough(ServerCompanionEntity entity, PathNodeContext ctx, MetropolizeBlockPos blockPos) {
        return this.getCostToPassThrough(entity, ctx, blockPos, ctx.getBlockState(blockPos), false) + this.getCostToPassThrough(entity, ctx, blockPos.above(), ctx.getBlockState(blockPos.above()), true);
    }

    private double getCostToBreak(Level level, ServerCompanionEntity entity, BlockPos pos, BlockState state) {
        if (Objects.requireNonNull(IProtectedBlocksCapability.get(level, pos)).isProtectedBlock(pos, state)) {
            return Double.POSITIVE_INFINITY;
        }
        ItemStack tool = BlockBreakUtils.getFastestTool(entity.getInventory(), state, false);
        double timeToBreak = 1.0 / (double)BlockBreakUtils.getDestroySpeed(tool, state);
        if (timeToBreak < 0.0) {
            return Double.POSITIVE_INFINITY;
        }
        return timeToBreak;
    }

    public static final class Result {
        public final Vec3 pos;
        public final double cost;
        public final PathNodeContext context;
        public static final Result INVALID = new Result(Vec3.f_82478_, Double.POSITIVE_INFINITY, null);

        Result(Vec3 pos, double cost, PathNodeContext context) {
            this.pos = pos;
            this.cost = cost;
            this.context = context;
        }
    }
}

