/*
 * Decompiled with CFR 0.152.
 */
package com.metropolize.mtz_companions.navigation.move;

import com.metropolize.mtz_companions.core.MetropolizeBlockPos;
import com.metropolize.mtz_companions.entity.ServerCompanionEntity;
import com.metropolize.mtz_companions.navigation.move.Move;
import com.metropolize.mtz_companions.navigation.path.PathNode;
import com.mojang.logging.LogUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.FluidState;
import org.slf4j.Logger;

public class SwimMove
extends Move {
    private static final Logger log = LogUtils.getLogger();

    protected SwimMove(int x, int y, int z) {
        super(x, y, z);
    }

    @Override
    public Move.Result from(ServerCompanionEntity entity, PathNode previousNode) {
        MetropolizeBlockPos blockPos = previousNode.blockPos;
        MetropolizeBlockPos result = new MetropolizeBlockPos(blockPos.m_123341_() + this.x, blockPos.m_123342_() + this.y, blockPos.m_123343_() + this.z);
        double cost = this.getCost(entity, blockPos, result, previousNode);
        return new Move.Result(result.m_252807_().m_82492_(0.0, 0.3, 0.0), cost, previousNode.pathNodeContext.clone());
    }

    protected double getCost(ServerCompanionEntity entity, MetropolizeBlockPos from, MetropolizeBlockPos to, PathNode previousNode) {
        FluidState headState;
        Level level = entity.m_9236_();
        FluidState fromState = level.m_6425_((BlockPos)from);
        FluidState toState = level.m_6425_((BlockPos)to);
        if (!(previousNode.getMove() instanceof SwimMove) && !(headState = level.m_6425_((BlockPos)from.above())).m_205070_(FluidTags.f_13131_)) {
            return Double.POSITIVE_INFINITY;
        }
        if (!entity.canSwimInFluidType(fromState.getFluidType()) || !entity.canSwimInFluidType(toState.getFluidType())) {
            return Double.POSITIVE_INFINITY;
        }
        return from.distanceTo(to) / 2.0;
    }
}

