/*
 * Decompiled with CFR 0.152.
 */
package com.metropolize.mtz_companions.navigation.path;

import com.metropolize.mtz_companions.entity.ServerCompanionEntity;
import com.metropolize.mtz_companions.navigation.move.SwimMove;
import com.metropolize.mtz_companions.navigation.path.PathNode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import lombok.NonNull;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class Path {
    private final Level level;
    private final List<PathNode> pathNodes;
    protected static final float MIN_DISPLACEMENT_SQR = 0.1f;

    public Path(Level level, PathNode start, PathNode end) {
        this.level = level;
        PathNode currentNode = end;
        PathNode nextNode = null;
        LinkedList<PathNode> tempNodes = new LinkedList<PathNode>();
        while (currentNode != null) {
            PathNode prevNode = currentNode.previous;
            if (!this.canPrune(currentNode, prevNode, nextNode)) {
                tempNodes.addFirst(currentNode);
                nextNode = currentNode;
            }
            currentNode = prevNode;
        }
        assert (tempNodes.get(0) == start);
        this.pathNodes = Collections.synchronizedList(tempNodes);
    }

    public Path(Level level, List<PathNode> nodes) {
        this.level = level;
        this.pathNodes = nodes;
    }

    public List<PathNode> nodes() {
        return Collections.unmodifiableList(this.pathNodes);
    }

    public PathNode getNode(int index) {
        return this.pathNodes.get(index);
    }

    public PathNode getLastNode() {
        return this.pathNodes.get(this.length() - 1);
    }

    public int length() {
        return this.pathNodes.size();
    }

    public Path extend(PathNode start, PathNode end) {
        Path appended = new Path(this.level, start, end);
        ArrayList<PathNode> newNodes = new ArrayList<PathNode>(this.length() + appended.length());
        newNodes.addAll(this.pathNodes);
        newNodes.addAll(appended.pathNodes.subList(1, this.pathNodes.size()));
        return new Path(this.level, newNodes);
    }

    @NonNull
    public PathNode getClosestPathNode(@NonNull Vec3 pos) {
        if (pos == null) {
            throw new NullPointerException("pos is marked non-null but is null");
        }
        return this.pathNodes.stream().min(Comparator.comparingDouble(node -> pos.m_82554_(node.pos))).orElseGet(() -> this.pathNodes.get(0));
    }

    public boolean isAtEnd(ServerCompanionEntity entity) {
        Vec3 entityPos = entity.mtzPosition();
        return this.getLastNode().isReached(entity.m_9236_(), entityPos);
    }

    private boolean canPrune(PathNode currNode, PathNode prevNode, PathNode nextNode) {
        if (prevNode == null || nextNode == null) {
            return false;
        }
        if (currNode.getMove() instanceof SwimMove && nextNode.getMove() instanceof SwimMove) {
            return this.level.m_45547_(new ClipContext(prevNode.pos.m_82520_((double)0.3f, 0.0, (double)0.3f), nextNode.pos.m_82520_((double)0.3f, 0.0, (double)0.3f), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, null)).m_6662_() == HitResult.Type.MISS && this.level.m_45547_(new ClipContext(prevNode.pos.m_82492_((double)0.3f, 0.0, (double)0.3f), nextNode.pos.m_82492_((double)0.3f, 0.0, (double)0.3f), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, null)).m_6662_() == HitResult.Type.MISS;
        }
        return false;
    }
}

