/*
 * Decompiled with CFR 0.152.
 */
package com.metropolize.mtz_companions.navigation.path;

import com.metropolize.mtz_companions.core.MetropolizeBlockPos;
import com.metropolize.mtz_companions.navigation.move.DescendMove;
import com.metropolize.mtz_companions.navigation.move.DiagonalMove;
import com.metropolize.mtz_companions.navigation.move.Move;
import com.metropolize.mtz_companions.navigation.move.SwimMove;
import com.metropolize.mtz_companions.navigation.path.PathNodeContext;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class PathNode {
    public final Vec3 pos;
    public final MetropolizeBlockPos blockPos;
    public final BlockState blockState;
    public final BlockState headState;
    public final Level level;
    public final double costToTarget;
    public int openSetPosition = -1;
    public PathNode previous = null;
    public PathNodeContext pathNodeContext;
    @Nullable
    private Move move = null;
    private double cost = Double.POSITIVE_INFINITY;
    private double totalCost = Double.POSITIVE_INFINITY;

    public PathNode(Level level, Vec3 pos, double costToTarget) {
        this.level = level;
        this.pos = pos;
        this.blockPos = new MetropolizeBlockPos(BlockPos.m_274446_((Position)pos));
        this.blockState = level != null ? level.m_8055_((BlockPos)this.blockPos) : null;
        this.headState = level != null ? level.m_8055_((BlockPos)this.blockPos.above()) : null;
        this.costToTarget = costToTarget;
    }

    public PathNode(Level level, double x, double y, double z, double costToTarget) {
        this(level, new Vec3(x, y, z), costToTarget);
    }

    public void setCost(double cost) {
        this.cost = cost;
        this.totalCost = cost + this.costToTarget;
    }

    public boolean isReached(Level level, Vec3 pos) {
        if (this.getBlockPosToPlace() != null && level.m_8055_((BlockPos)this.getBlockPosToPlace()).m_60795_()) {
            return false;
        }
        if (this.move != null && this.move.y != 0 && Math.abs(this.pos.f_82479_ - pos.f_82479_) > 0.15 || Math.abs(this.pos.f_82481_ - pos.f_82481_) > 0.15) {
            return false;
        }
        return pos.m_82557_(this.pos) < (double)0.1f;
    }

    public boolean isReachedHorizontal(Level level, Vec3 pos) {
        if (this.move != null && this.move.y != 0 && Math.abs(this.pos.f_82479_ - pos.f_82479_) > 0.15 || Math.abs(this.pos.f_82481_ - pos.f_82481_) > 0.15) {
            return false;
        }
        return pos.m_82546_(this.pos).m_165925_() < (double)0.1f;
    }

    public static boolean isAlongNode(BlockPos pos, PathNode node) {
        if (node.blockPos.equals(pos)) {
            return true;
        }
        PathNode prevNode = node.previous;
        if (node.move != null && Math.abs(node.move.x) + Math.abs(node.move.y) + Math.abs(node.move.z) > 1) {
            if (node.move instanceof DescendMove) {
                boolean isInFall = pos.m_123342_() <= prevNode.blockPos.m_123342_() && pos.m_123342_() >= node.blockPos.m_123342_();
                return pos.m_123341_() == node.blockPos.m_123341_() && isInFall && pos.m_123343_() == node.blockPos.m_123343_();
            }
            if (node.move.y >= 1) {
                boolean isInJump = pos.m_123342_() >= prevNode.blockPos.m_123342_() && pos.m_123342_() <= node.blockPos.m_123342_();
                return pos.m_123341_() == prevNode.blockPos.m_123341_() && isInJump && pos.m_123343_() == node.previous.blockPos.m_123343_();
            }
            if (node.move instanceof DiagonalMove) {
                boolean alongX = pos.m_123341_() == node.blockPos.m_123341_() || pos.m_123341_() == prevNode.blockPos.m_123341_();
                boolean alongZ = pos.m_123343_() == node.blockPos.m_123343_() || pos.m_123343_() == prevNode.blockPos.m_123343_();
                return alongX && pos.m_123342_() == node.blockPos.m_123342_() && alongZ;
            }
        } else if (node.move instanceof SwimMove) {
            return node.getMovementError(pos.m_252807_()).m_82553_() < 1.0;
        }
        return false;
    }

    public Vec3 getMovementError(Vec3 p) {
        if (this.previous == null) {
            return this.pos.m_82546_(p);
        }
        Vec3 a = this.previous.pos;
        Vec3 n = this.pos.m_82546_(this.previous.pos).m_82541_();
        Vec3 ap = p.m_82546_(a);
        double projection = ap.m_82526_(n);
        return ap.m_82546_(n.m_82490_(projection));
    }

    @Nullable
    public MetropolizeBlockPos getBlockPosToPlace() {
        return this.pathNodeContext.getBlockToPlace();
    }

    @Nullable
    public List<MetropolizeBlockPos> getBlocksToBreak() {
        return this.pathNodeContext.getBlocksToBreak();
    }

    public String toString() {
        return String.format("PathNode{%d, %d, %d}", this.blockPos.m_123341_(), this.blockPos.m_123342_(), this.blockPos.m_123343_());
    }

    @Nullable
    public Move getMove() {
        return this.move;
    }

    public void setMove(@Nullable Move move) {
        this.move = move;
    }

    public double getCost() {
        return this.cost;
    }

    public double getTotalCost() {
        return this.totalCost;
    }
}

