/*
 * Decompiled with CFR 0.152.
 */
package com.metropolize.mtz_companions.navigation.path;

import com.metropolize.mtz_companions.core.MetropolizeBlockPos;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;

public class PathNodeContext
implements Cloneable {
    public final Level level;
    public final int minHeight;
    public final int maxHeight;
    public ArrayList<MetropolizeBlockPos> blocksPlaced = new ArrayList();
    public ArrayList<MetropolizeBlockPos> blocksBroken = new ArrayList();
    private MetropolizeBlockPos blockToPlace;
    private List<MetropolizeBlockPos> blocksToBreak;

    public PathNodeContext(Level level) {
        this.level = level;
        this.minHeight = level.m_141937_();
        this.maxHeight = level.m_151558_();
        this.init();
    }

    public void addBlockToBreak(MetropolizeBlockPos blockPos) {
        this.blocksToBreak.add(blockPos);
        this.blocksBroken.add(blockPos);
    }

    public void addBlockToPlace(MetropolizeBlockPos blockPos) {
        this.blockToPlace = blockPos;
        this.blocksPlaced.add(blockPos);
    }

    public BlockState getBlockState(MetropolizeBlockPos pos) {
        if (this.blocksPlaced.contains((Object)pos)) {
            return Blocks.f_50752_.m_49966_();
        }
        if (this.blocksBroken.contains((Object)pos)) {
            return Blocks.f_50016_.m_49966_();
        }
        return this.level.m_8055_((BlockPos)pos);
    }

    public PathNodeContext clone() {
        try {
            PathNodeContext clone = (PathNodeContext)super.clone();
            clone.init();
            clone.blocksPlaced = new ArrayList<MetropolizeBlockPos>(this.blocksPlaced);
            clone.blocksBroken = new ArrayList<MetropolizeBlockPos>(this.blocksBroken);
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError();
        }
    }

    private void init() {
        this.blockToPlace = null;
        this.blocksToBreak = new ArrayList<MetropolizeBlockPos>();
    }

    public ArrayList<MetropolizeBlockPos> getBlocksBroken() {
        return this.blocksBroken;
    }

    public MetropolizeBlockPos getBlockToPlace() {
        return this.blockToPlace;
    }

    public List<MetropolizeBlockPos> getBlocksToBreak() {
        return this.blocksToBreak;
    }
}

