/*
 * Decompiled with CFR 0.152.
 */
package com.metropolize.mtz_companions.navigation.utils;

import com.metropolize.mtz_companions.core.MetropolizeBlockPos;
import com.metropolize.mtz_companions.navigation.path.PathNodeContext;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.AmethystBlock;
import net.minecraft.world.level.block.AzaleaBlock;
import net.minecraft.world.level.block.BaseFireBlock;
import net.minecraft.world.level.block.BigDripleafBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CakeBlock;
import net.minecraft.world.level.block.CarpetBlock;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.HoneyBlock;
import net.minecraft.world.level.block.MagmaBlock;
import net.minecraft.world.level.block.PowderSnowBlock;
import net.minecraft.world.level.block.SnowLayerBlock;
import net.minecraft.world.level.block.SweetBerryBushBlock;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.TripWireBlock;
import net.minecraft.world.level.block.WaterlilyBlock;
import net.minecraft.world.level.block.WebBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.AABB;
import org.apache.commons.lang3.NotImplementedException;

public class MovementUtils {
    public static final int STUCK_TIMEOUT_TICKS = 100;
    public static final float BLOCKED_DIAGONAL_COST_FACTOR = 1.5f;
    public static final int PLACE_BLOCK_COST = 20;
    public static final int FALL_DAMAGE_COST = 5;

    public static boolean canWalkThrough(PathNodeContext ctx, MetropolizeBlockPos blockPos) {
        MetropolizeBlockPos upperBlock = blockPos.above();
        return MovementUtils.canPassThrough(ctx, blockPos, ctx.getBlockState(blockPos), false) && MovementUtils.canPassThrough(ctx, upperBlock, ctx.getBlockState(upperBlock), true);
    }

    public static boolean canPassThrough(PathNodeContext ctx, BlockPos blockPos, BlockState blockState, boolean isUpperBlock) {
        Block block = blockState.m_60734_();
        if (block == Blocks.f_50016_) {
            if (!isUpperBlock) {
                BlockState belowBlock = ctx.getBlockState((MetropolizeBlockPos)blockPos.m_7495_());
                return !belowBlock.m_204336_(BlockTags.f_13039_) && !belowBlock.m_204336_(BlockTags.f_13032_);
            }
            return true;
        }
        if (blockState.m_60647_((BlockGetter)ctx.level, blockPos, PathComputationType.LAND)) {
            if (block instanceof HoneyBlock || block instanceof AzaleaBlock || block instanceof BigDripleafBlock) {
                return false;
            }
            if (block instanceof WebBlock || block instanceof PowderSnowBlock) {
                return false;
            }
            if (block instanceof BaseFireBlock || block instanceof SweetBerryBushBlock) {
                return false;
            }
            if (block instanceof AmethystBlock) {
                return block == Blocks.f_152495_;
            }
            if (block instanceof TripWireBlock) {
                return (Boolean)blockState.m_61143_((Property)TripWireBlock.f_57591_) == false;
            }
            if (block instanceof CarpetBlock) {
                return !isUpperBlock;
            }
            if (block instanceof SnowLayerBlock) {
                return (Integer)blockState.m_61143_((Property)SnowLayerBlock.f_56581_) < 3;
            }
            return true;
        }
        if (DoorBlock.m_52817_((BlockState)blockState) || block instanceof FenceGateBlock) {
            return true;
        }
        return block instanceof TrapDoorBlock;
    }

    public static boolean canFallThrough(PathNodeContext ctx, BlockPos blockPos, BlockState blockState) {
        if (!MovementUtils.canPassThrough(ctx, blockPos, blockState, true)) {
            return false;
        }
        throw new NotImplementedException();
    }

    public static boolean canStandOn(Entity entity, BlockPos blockPos, BlockState blockState) {
        Block block = blockState.m_60734_();
        if (blockState.m_60634_((BlockGetter)entity.m_9236_(), blockPos, entity)) {
            return !(block instanceof MagmaBlock);
        }
        try {
            AABB blockBounds = blockState.m_60812_((BlockGetter)entity.m_9236_(), blockPos).m_83215_();
            if (blockBounds.m_82362_() >= 1.0 && blockBounds.m_82385_() >= 1.0 && blockBounds.m_82376_() >= 0.25) {
                return true;
            }
        }
        catch (UnsupportedOperationException blockBounds) {
            // empty catch block
        }
        if (block instanceof CakeBlock) {
            return true;
        }
        if (block instanceof AmethystBlock) {
            return block != Blocks.f_152495_;
        }
        BlockState belowBlock = entity.m_9236_().m_8055_(blockPos.m_7495_());
        if (belowBlock.m_204336_(BlockTags.f_13039_) || belowBlock.m_204336_(BlockTags.f_13032_)) {
            return true;
        }
        if (belowBlock.m_204336_(BlockTags.f_13055_)) {
            return (Boolean)belowBlock.m_61143_((Property)FenceGateBlock.f_53341_) == false;
        }
        Block upBlock = entity.m_9236_().m_8055_(blockPos.m_7494_()).m_60734_();
        return upBlock instanceof CarpetBlock || upBlock instanceof WaterlilyBlock;
    }

    public static boolean canStep(Entity entity, BlockPos from, BlockPos to) {
        assert (to.m_123342_() != from.m_123342_() + 1);
        Level level = entity.m_9236_();
        BlockState fromState = level.m_8055_(from);
        BlockState toState = level.m_8055_(to);
        double fromY = fromState.m_60812_((BlockGetter)level, from).m_83215_().m_82374_(Direction.Axis.Y);
        double toY = toState.m_60812_((BlockGetter)level, from).m_83215_().m_82374_(Direction.Axis.Y);
        return toY - fromY <= (double)entity.getStepHeight();
    }
}

