/*
 * Decompiled with CFR 0.152.
 */
package com.metropolize.mtz_companions.navigation.utils;

import com.metropolize.mtz_companions.navigation.path.PathNode;
import java.util.Arrays;

public class PathNodeBinaryHeap {
    private PathNode[] heap = new PathNode[512];
    private int size = 0;

    public void insert(PathNode node) {
        assert (node.openSetPosition == -1);
        if (this.size == this.heap.length) {
            this.heap = Arrays.copyOf(this.heap, this.size << 1);
        }
        this.heap[this.size] = node;
        node.openSetPosition = this.size++;
        this.upHeap(node);
    }

    public PathNode pop() {
        PathNode lastNode;
        PathNode result = this.heap[0];
        result.openSetPosition = -1;
        this.heap[0] = lastNode = this.heap[--this.size];
        lastNode.openSetPosition = 0;
        this.heap[this.size] = null;
        if (!this.isEmpty()) {
            this.downHeap(lastNode);
        }
        return result;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public void upHeap(PathNode node) {
        if (node.openSetPosition == 0) {
            return;
        }
        int parentPos = (node.openSetPosition - 1) / 2;
        PathNode parent = this.heap[parentPos];
        while (node.getTotalCost() < parent.getTotalCost()) {
            this.swap(node, parent);
            if (node.openSetPosition == 0) {
                return;
            }
            parent = this.heap[(node.openSetPosition - 1) / 2];
        }
    }

    protected void downHeap(PathNode node) {
        int leftChildPos;
        assert (this.size != 0);
        int currentPosition = node.openSetPosition;
        while ((leftChildPos = currentPosition * 2 + 1) < this.size) {
            double rightChildCost;
            PathNode rightChild;
            PathNode leftChild = this.heap[leftChildPos];
            double leftChildCost = leftChild.getTotalCost();
            int rightChildPos = currentPosition * 2 + 2;
            if (rightChildPos >= this.size) {
                rightChild = null;
                rightChildCost = Double.POSITIVE_INFINITY;
            } else {
                rightChild = this.heap[rightChildPos];
                rightChildCost = rightChild.getTotalCost();
            }
            if (leftChildCost < rightChildCost) {
                if (node.getTotalCost() < leftChildCost) break;
                this.heap[currentPosition] = leftChild;
                leftChild.openSetPosition = currentPosition;
                currentPosition = leftChildPos;
                continue;
            }
            if (node.getTotalCost() < rightChildCost) break;
            this.heap[currentPosition] = rightChild;
            rightChild.openSetPosition = currentPosition;
            currentPosition = rightChildPos;
        }
        this.heap[currentPosition] = node;
        node.openSetPosition = currentPosition;
    }

    protected void swap(PathNode a, PathNode b) {
        int aIndex = a.openSetPosition;
        int bIndex = b.openSetPosition;
        this.heap[aIndex] = b;
        this.heap[bIndex] = a;
        a.openSetPosition = bIndex;
        b.openSetPosition = aIndex;
    }
}

