/*
 * Decompiled with CFR 0.152.
 */
package com.metropolize.mtz_companions.network.client;

import com.metropolize.mtz_companions.ClientCompanionManager;
import com.metropolize.mtz_companions.entity.ClientCompanionEntity;
import com.metropolize.mtz_companions.network.server.ClientboundAddCompanionPacket;
import com.metropolize.mtz_companions.network.server.ClientboundCompanionRotPacket;
import com.metropolize.mtz_companions.network.server.ClientboundRemoveCompanionPacket;
import com.mojang.logging.LogUtils;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.PlayerInfo;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraftforge.network.NetworkEvent;
import org.slf4j.Logger;

public class ClientPacketHandler {
    private static final Logger log = LogUtils.getLogger();

    public static void handleAddCompanionPacket(ClientboundAddCompanionPacket packet, Supplier<NetworkEvent.Context> ctx) {
        PlayerInfo playerInfo = Minecraft.m_91087_().m_91403_().m_104949_(packet.m_131606_());
        if (playerInfo == null) {
            log.warn("Server attempted to add player prior to sending player info (Player id {})", (Object)packet.m_131606_());
        } else {
            double d0 = packet.m_131607_();
            double d1 = packet.m_131608_();
            double d2 = packet.m_131609_();
            float f = (float)(packet.m_131610_() * 360) / 256.0f;
            float f1 = (float)(packet.m_131611_() * 360) / 256.0f;
            int i = packet.m_131603_();
            ClientCompanionEntity clientCompanion = new ClientCompanionEntity(Minecraft.m_91087_().f_91073_, playerInfo.m_105312_());
            clientCompanion.m_20234_(i);
            clientCompanion.setCompanionId(packet.getCompanionId());
            clientCompanion.m_217006_(d0, d1, d2);
            clientCompanion.m_19890_(d0, d1, d2, f, f1);
            clientCompanion.m_146867_();
            Minecraft.m_91087_().f_91073_.m_104630_(i, (AbstractClientPlayer)clientCompanion);
            ClientCompanionManager.addCompanion(clientCompanion.m_20148_(), clientCompanion);
        }
    }

    public static void handleRemoveCompanionPacket(ClientboundRemoveCompanionPacket packet, Supplier<NetworkEvent.Context> ctx) {
        UUID id = packet.getCompanionUUID();
        ClientCompanionManager.removeCompanion(id);
    }

    public static void handleCompanionRotPacket(ClientboundCompanionRotPacket packet, Supplier<NetworkEvent.Context> ctx) {
        ClientCompanionEntity companion = ClientCompanionManager.getCompanion(packet.getCompanionUUID());
        if (companion == null) {
            return;
        }
        companion.m_146922_(packet.getYRot());
    }
}

