/*
 * Decompiled with CFR 0.152.
 */
package com.metropolize.mtz_companions.utils;

import com.google.common.collect.ImmutableSet;
import com.metropolize.mtz_companions.entity.CompanionContainer;
import com.metropolize.mtz_companions.utils.LootTableUtils;
import net.minecraft.world.effect.MobEffectUtil;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TieredItem;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.common.TierSortingRegistry;
import net.minecraftforge.fluids.FluidType;

public final class BlockBreakUtils {
    private BlockBreakUtils() {
    }

    public static ItemStack getFastestTool(CompanionContainer inventory, BlockState blockState, boolean requireDrop) {
        float bestSpeed = 0.0f;
        ItemStack toEquip = inventory.findFirstItemSlot(itemStack -> !itemStack.m_41763_());
        ImmutableSet<ItemStack> tools = inventory.getToolsForDrops();
        for (ItemStack tool : tools) {
            float speed;
            if (requireDrop && !tool.m_41735_(blockState) || !((speed = BlockBreakUtils.getDestroySpeed(tool, blockState)) > bestSpeed)) continue;
            bestSpeed = speed;
            toEquip = tool;
        }
        return toEquip;
    }

    public static float getDestroySpeed(ItemStack itemStack, BlockState blockState) {
        int i;
        float hardness = blockState.m_60800_(null, null);
        if (hardness < 0.0f) {
            return -1.0f;
        }
        float speed = itemStack.m_41691_(blockState);
        if (speed > 1.0f && !itemStack.m_41619_() && (i = EnchantmentHelper.getTagEnchantmentLevel((Enchantment)Enchantments.f_44984_, (ItemStack)itemStack)) > 0 && !itemStack.m_41619_()) {
            speed += (float)(i * i + 1);
        }
        float correctToolModifier = LootTableUtils.isCorrectToolForDrops(blockState, itemStack) ? 30.0f : 100.0f;
        return speed / hardness / correctToolModifier;
    }

    public static float getDestroyProgressPerTick(LivingEntity entity, ItemStack itemStack, BlockState blockState) {
        float speed = BlockBreakUtils.getDestroySpeed(itemStack, blockState);
        if (MobEffectUtil.m_19584_((LivingEntity)entity)) {
            speed *= 1.0f + (float)(MobEffectUtil.m_19586_((LivingEntity)entity) + 1) * 0.2f;
        }
        if (entity.m_21023_(MobEffects.f_19599_)) {
            float slowDownModifier = switch (entity.m_21124_(MobEffects.f_19599_).m_19564_()) {
                case 0 -> 0.3f;
                case 1 -> 0.09f;
                case 2 -> 0.0027f;
                default -> 8.1E-4f;
            };
            speed *= slowDownModifier;
        }
        if (entity.isEyeInFluidType((FluidType)ForgeMod.WATER_TYPE.get()) && !EnchantmentHelper.m_44934_((LivingEntity)entity)) {
            speed /= 5.0f;
        }
        if (!entity.m_20096_()) {
            speed /= 5.0f;
        }
        return speed;
    }

    public static boolean isHigherTier(TieredItem a, TieredItem b) {
        return TierSortingRegistry.getTiersLowerThan((Tier)a.m_43314_()).contains(b.m_43314_());
    }
}

