/*
 * Decompiled with CFR 0.152.
 */
package com.metropolize.mtz_companions.utils;

import com.google.common.collect.Lists;
import com.metropolize.mtz_companions.capabilities.IProtectedBlocksCapability;
import com.metropolize.mtz_companions.core.MetropolizeBlockPos;
import com.metropolize.mtz_companions.entity.ServerCompanionEntity;
import com.mojang.logging.LogUtils;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraftforge.common.util.BlockSnapshot;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.util.ObfuscationReflectionHelper;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public final class BlockPlacementUtils {
    private static final Logger log = LogUtils.getLogger();
    private static final Method blockItem_mustSurvive;

    private BlockPlacementUtils() {
    }

    public static boolean canPlace(ServerCompanionEntity entity, BlockItem blockToPlace, BlockPos targetPos) {
        BlockState targetPosState = entity.m_9236_().m_8055_(targetPos);
        BlockState placementState = blockToPlace.m_40614_().m_49966_();
        try {
            boolean canReplace = targetPosState.m_247087_() && targetPosState.m_60734_().m_5456_() != blockToPlace;
            boolean blockCanSurvive = placementState.m_60710_((LevelReader)entity.m_9236_(), targetPos) || (Boolean)blockItem_mustSurvive.invoke((Object)blockToPlace, (Object[])null) == false;
            boolean unobstructed = entity.m_9236_().m_45752_(placementState, targetPos, CollisionContext.m_82750_((Entity)entity));
            return blockCanSurvive && unobstructed && canReplace;
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            log.error("Failed to call PlaceBlock::canPlace with exception: {}", (Object)e.getMessage());
            return false;
        }
    }

    @Nullable
    public static Direction getSupportingDirection(ServerCompanionEntity entity, Level level, MetropolizeBlockPos targetPos) {
        for (Direction d : Direction.m_122382_((Entity)entity)) {
            BlockState adjacentBlockState = level.m_8055_((BlockPos)targetPos.relative(d));
            if (!adjacentBlockState.m_60783_((BlockGetter)level, (BlockPos)targetPos, d.m_122424_())) continue;
            return d;
        }
        return null;
    }

    public static void placeBlock(ServerCompanionEntity entity, ServerLevel level, ItemStack itemStack, BlockState placementBlockState, BlockPos targetPos, Direction direction, boolean remember) {
        boolean success;
        entity.m_6674_(InteractionHand.MAIN_HAND);
        if (!(itemStack.m_41720_() instanceof BucketItem)) {
            level.captureBlockSnapshots = true;
        }
        if (success = level.m_46597_(targetPos, placementBlockState)) {
            List blockSnapshots = (List)level.capturedBlockSnapshots.clone();
            level.capturedBlockSnapshots.clear();
            boolean cancelled = false;
            if (blockSnapshots.size() == 1) {
                cancelled = ForgeEventFactory.onBlockPlace((Entity)entity, (BlockSnapshot)((BlockSnapshot)blockSnapshots.get(0)), (Direction)direction);
            } else if (blockSnapshots.size() > 1) {
                cancelled = ForgeEventFactory.onMultiBlockPlace((Entity)entity, (List)blockSnapshots, (Direction)direction);
            }
            if (cancelled) {
                for (BlockSnapshot snapshot : Lists.reverse((List)blockSnapshots)) {
                    level.restoringBlockSnapshots = true;
                    snapshot.restore(true, false);
                    level.restoringBlockSnapshots = false;
                }
            } else {
                IProtectedBlocksCapability protectedBlocksCapability;
                for (BlockSnapshot snapshot : blockSnapshots) {
                    int updateFlag = snapshot.getFlag();
                    BlockState oldBlock = snapshot.getReplacedBlock();
                    BlockState newBlock = level.m_8055_(snapshot.getPos());
                    newBlock.m_60696_((Level)level, snapshot.getPos(), oldBlock, false);
                    level.markAndNotifyBlock(snapshot.getPos(), level.m_46745_(snapshot.getPos()), oldBlock, newBlock, updateFlag, 512);
                    level.m_220407_(GameEvent.f_157797_, targetPos, GameEvent.Context.m_223719_((Entity)entity, (BlockState)placementBlockState));
                }
                itemStack.m_41774_(1);
                SoundType soundtype = placementBlockState.getSoundType((LevelReader)level, targetPos, (Entity)entity);
                level.m_5594_((Player)entity, targetPos, soundtype.m_56777_(), SoundSource.BLOCKS, (soundtype.m_56773_() + 1.0f) / 2.0f, soundtype.m_56774_() * 0.8f);
                if (remember && (protectedBlocksCapability = IProtectedBlocksCapability.get((Level)level, targetPos)) != null) {
                    protectedBlocksCapability.setBlockPlaced(level, null, new MetropolizeBlockPos(targetPos));
                }
            }
        }
        level.captureBlockSnapshots = false;
    }

    static {
        try {
            blockItem_mustSurvive = ObfuscationReflectionHelper.findMethod(BlockItem.class, (String)"m_6652_", (Class[])new Class[0]);
        }
        catch (ObfuscationReflectionHelper.UnableToFindMethodException e) {
            throw new RuntimeException(e);
        }
    }
}

