/*
 * Decompiled with CFR 0.152.
 */
package com.metropolize.mtz_companions.utils;

import com.google.common.collect.ImmutableSet;
import com.metropolize.mtz_companions.entity.ServerCompanionEntity;
import com.metropolize.mtz_companions.mixins.MixinLootTable;
import com.mojang.logging.LogUtils;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.entries.CompositeEntryBase;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntries;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.LootPoolSingletonContainer;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.BonusLevelTableCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionType;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditions;
import net.minecraft.world.level.storage.loot.predicates.LootItemRandomChanceCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemRandomChanceWithLootingCondition;
import net.minecraft.world.phys.Vec3;
import org.slf4j.Logger;

public final class LootTableUtils {
    private static final Logger log = LogUtils.getLogger();
    private static final Set<LootItemConditionType> randomConditions = new HashSet<LootItemConditionType>(Arrays.asList(LootItemConditions.f_81813_, LootItemConditions.f_81814_, LootItemConditions.f_81820_));
    private static final float DROP_CHANCE_THRESHOLD = 0.125f;

    private LootTableUtils() {
    }

    public static boolean isCorrectToolForDrops(BlockState blockState, ItemStack item) {
        return !blockState.m_60834_() || item.m_41735_(blockState);
    }

    public static boolean blockDropsWantedItem(ServerCompanionEntity entity, BlockPos blockPos, BlockState blockState) {
        Set<Item> wantedItems = entity.getWantedItems();
        if (wantedItems == null || wantedItems.isEmpty()) {
            return false;
        }
        Map<Item, Float> drops = entity.getPossibleDrops(blockPos, blockState);
        return drops.entrySet().stream().anyMatch(entry -> wantedItems.contains(entry.getKey()) && ((Float)entry.getValue()).floatValue() > 0.125f);
    }

    public static Map<Item, Float> getAllBlockDrops(BlockPos blockPos, BlockState blockState, ServerLevel level, MinecraftServer server, ImmutableSet<ItemStack> tools) {
        HashMap<Item, Float> possibleDrops = new HashMap<Item, Float>();
        for (ItemStack tool : tools) {
            if (!LootTableUtils.isCorrectToolForDrops(blockState, tool)) continue;
            LootParams.Builder lootParams = new LootParams.Builder(level).m_287286_(LootContextParams.f_81460_, (Object)Vec3.m_82512_((Vec3i)blockPos)).m_287286_(LootContextParams.f_81463_, (Object)tool).m_287286_(LootContextParams.f_81461_, (Object)blockState);
            LootContext.Builder lootContext = new LootContext.Builder(lootParams.m_287235_(LootContextParamSets.f_81421_));
            lootContext.f_78958_ = RandomSource.m_216343_();
            MixinLootTable lootTable = (MixinLootTable)server.m_278653_().m_278676_(blockState.m_60734_().m_60589_());
            Map<Item, Float> dropsForTool = LootTableUtils.getAllDrops(lootTable, lootContext.m_287259_(null));
            dropsForTool.forEach((item, p) -> possibleDrops.put((Item)item, Float.valueOf(Math.max(p.floatValue(), possibleDrops.getOrDefault(item, Float.valueOf(0.0f)).floatValue()))));
        }
        return possibleDrops;
    }

    public static Map<Item, Float> getAllMobDrops(LivingEntity entity, DamageSource damageSource) {
        ServerLevel level = (ServerLevel)entity.m_9236_();
        LootParams.Builder lootParams = new LootParams.Builder(level).m_287286_(LootContextParams.f_81455_, (Object)entity).m_287286_(LootContextParams.f_81460_, (Object)entity.m_20182_()).m_287286_(LootContextParams.f_81457_, (Object)damageSource).m_287289_(LootContextParams.f_81458_, (Object)damageSource.m_7639_()).m_287289_(LootContextParams.f_81459_, (Object)damageSource.m_7640_()).m_287289_(LootContextParams.f_81456_, (Object)entity.f_20888_);
        LootContext.Builder lootContextBuilder = new LootContext.Builder(lootParams.m_287235_(LootContextParamSets.f_81415_));
        LootContext lootContext = lootContextBuilder.m_287259_(null);
        ResourceLocation resourceLocation = entity.m_5743_();
        MixinLootTable lootTable = (MixinLootTable)entity.m_20194_().m_278653_().m_278676_(resourceLocation);
        return LootTableUtils.getAllDrops(lootTable, lootContext);
    }

    public static Map<Item, Float> getAllDrops(MixinLootTable lootTable, LootContext lootContext) {
        List<LootPool> lootPools = lootTable.getPools();
        HashMap<Item, Float> itemChances = new HashMap<Item, Float>();
        for (LootPool pool : lootPools) {
            if (!pool.f_79025_.test(lootContext)) continue;
            LinkedList<LootPoolEntryContainer> containerQueue = new LinkedList<LootPoolEntryContainer>(Arrays.stream(pool.f_79023_).toList());
            while (!containerQueue.isEmpty()) {
                LootPoolEntryContainer container = (LootPoolEntryContainer)containerQueue.remove();
                if (container instanceof CompositeEntryBase) {
                    containerQueue.addAll(Arrays.stream(((CompositeEntryBase)container).f_79428_).toList());
                    continue;
                }
                float dropChance = LootTableUtils.getEntryDropChance(lootContext, container);
                LootPoolSingletonContainer singletonContainer = (LootPoolSingletonContainer)container;
                LootItemCondition[] nonRandomConditions = (LootItemCondition[])Arrays.stream(container.f_79636_).filter(cond -> !randomConditions.contains(cond.m_7940_())).toArray(LootItemCondition[]::new);
                Predicate compositeCondition = LootItemConditions.m_81834_((Predicate[])nonRandomConditions);
                if (!compositeCondition.test(lootContext)) continue;
                singletonContainer.f_79679_.m_6941_(itemStack -> itemChances.put(itemStack.m_41720_(), Float.valueOf(Math.max(itemChances.getOrDefault(itemStack.m_41720_(), Float.valueOf(0.0f)).floatValue(), dropChance))), lootContext);
            }
        }
        return itemChances;
    }

    public static float getEntryDropChance(LootContext lootContext, LootPoolEntryContainer container) {
        for (LootItemCondition condition : container.f_79636_) {
            if (condition instanceof LootItemRandomChanceCondition) {
                LootItemRandomChanceCondition randomChanceCondition = (LootItemRandomChanceCondition)condition;
                return randomChanceCondition.f_81921_;
            }
            if (condition instanceof LootItemRandomChanceWithLootingCondition) {
                LootItemRandomChanceWithLootingCondition randomLootingCondition = (LootItemRandomChanceWithLootingCondition)condition;
                int lootingLevel = lootContext.getLootingModifier();
                return randomLootingCondition.f_81953_ + (float)lootingLevel * randomLootingCondition.f_81954_;
            }
            if (!(condition instanceof BonusLevelTableCondition)) continue;
            BonusLevelTableCondition bonusLevelTableCondition = (BonusLevelTableCondition)condition;
            ItemStack tool = (ItemStack)lootContext.m_78953_(LootContextParams.f_81463_);
            int fortuneLevel = tool.getEnchantmentLevel(bonusLevelTableCondition.f_81507_);
            return bonusLevelTableCondition.f_81508_[Math.min(fortuneLevel, bonusLevelTableCondition.f_81508_.length - 1)];
        }
        return 1.0f;
    }

    private void logLootPoolEntryType(LootPoolEntryContainer container) {
        if (container.m_6751_() == LootPoolEntries.f_79620_) {
            log.debug("item");
        } else if (container.m_6751_() == LootPoolEntries.f_79622_) {
            log.debug("dynamic");
        } else if (container.m_6751_() == LootPoolEntries.f_79621_) {
            log.debug("reference");
        } else if (container.m_6751_() == LootPoolEntries.f_79626_) {
            log.debug("group");
        } else if (container.m_6751_() == LootPoolEntries.f_79619_) {
            log.debug("empty");
        } else if (container.m_6751_() == LootPoolEntries.f_79625_) {
            log.debug("sequence");
        } else if (container.m_6751_() == LootPoolEntries.f_79624_) {
            log.debug("alternatives");
        } else if (container.m_6751_() == LootPoolEntries.f_79623_) {
            log.debug("wtf tag how");
        } else {
            log.debug("idk");
        }
    }

    private void logLootItemConditionType(LootItemCondition condition) {
        if (condition.m_7940_() == LootItemConditions.f_81813_) {
            log.debug("Random Chance");
        } else if (condition.m_7940_() == LootItemConditions.f_81814_) {
            log.debug("Random chance with looting");
        } else if (condition.m_7940_() == LootItemConditions.f_81820_) {
            log.debug("Enchantment table bonus");
        }
    }
}

