/*
 * Decompiled with CFR 0.152.
 */
package com.metropolize.mtz_companions.utils;

import com.google.common.collect.ImmutableSet;
import com.metropolize.mtz_companions.entity.CompanionContainer;
import com.metropolize.mtz_companions.entity.ServerCompanionEntity;
import com.metropolize.mtz_companions.entity.metropolize.MtzItemConstants;
import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.NonNull;
import net.minecraft.core.RegistryAccess;
import net.minecraft.world.entity.player.StackedContents;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public final class RecipeUtils {
    private static final Map<Item, List<Recipe<?>>> recipeCache = new HashMap();

    private RecipeUtils() {
    }

    @NonNull
    public static List<Recipe<?>> getRecipesFor(Item item) {
        if (recipeCache.containsKey(item)) {
            return recipeCache.get(item);
        }
        return List.of();
    }

    @NonNull
    public static List<Recipe<?>> getRecipesFor(RecipeType<?> recipeType, Item item) {
        if (recipeCache.containsKey(item)) {
            return recipeCache.get(item).stream().filter(recipe -> recipe.m_6671_() == recipeType).toList();
        }
        return List.of();
    }

    public static void updateRecipeMap(Level level) {
        RegistryAccess registryAccess = level.m_9598_();
        Collection allRecipes = level.m_7465_().m_44051_();
        for (Recipe recipe : allRecipes) {
            Item item = recipe.m_8043_(registryAccess).m_41720_();
            if (recipeCache.containsKey(item)) {
                recipeCache.get(item).add(recipe);
                continue;
            }
            recipeCache.put(item, new ArrayList<Recipe>(List.of(recipe)));
        }
    }

    @Nullable
    public static Pair<Recipe<?>, IntList> getUsableRecipe(RecipeType<?> recipeType, Item item, ServerCompanionEntity entity) {
        StackedContents stackedContents = new StackedContents();
        CompanionContainer inventory = entity.getInventory();
        for (int i = 0; i < inventory.m_6643_(); ++i) {
            stackedContents.m_36466_(inventory.m_8020_(i));
        }
        List<Recipe<?>> recipes = RecipeUtils.getRecipesFor(recipeType, item);
        for (Recipe<?> recipe : recipes) {
            IntArrayList intList;
            if (!stackedContents.m_36475_(recipe, (IntList)(intList = new IntArrayList()))) continue;
            return Pair.of(recipe, (Object)intList);
        }
        return null;
    }

    public static Set<Item> appendCraftingIngredients(ServerCompanionEntity entity, @NonNull Set<Item> items) {
        if (items == null) {
            throw new NullPointerException("items is marked non-null but is null");
        }
        HashSet<Object> result = new HashSet<Item>(items);
        if (items.isEmpty()) {
            return ImmutableSet.copyOf(result);
        }
        HashSet<Item> itemsChecked = new HashSet<Item>(MtzItemConstants.CRAFTING_EXCLUSIONS);
        items = items.stream().filter(item -> !itemsChecked.contains(item)).collect(Collectors.toSet());
        while (true) {
            HashSet<Item> ingredientItems = new HashSet<Item>();
            for (Item item2 : items) {
                Pair<Recipe<?>, IntList> recipeInfo = RecipeUtils.getUsableRecipe(RecipeType.f_44107_, item2, entity);
                if (recipeInfo != null) continue;
                List<Recipe<?>> recipes = RecipeUtils.getRecipesFor(RecipeType.f_44107_, item2);
                for (Recipe<?> recipe : recipes) {
                    if (recipe.m_7527_().stream().map(Ingredient::m_43908_).flatMap(itemStacks -> Arrays.stream(itemStacks).map(ItemStack::m_41720_)).anyMatch(item1 -> {
                        List<Recipe<?>> recipes1 = RecipeUtils.getRecipesFor(RecipeType.f_44107_, item1);
                        for (Recipe<?> recipe1 : recipes1) {
                            if (!recipe1.m_7527_().stream().map(Ingredient::m_43908_).flatMap(itemStacks -> Arrays.stream(itemStacks).map(ItemStack::m_41720_)).anyMatch(item2 -> item2.equals(item2))) continue;
                            return true;
                        }
                        return false;
                    })) continue;
                    Map<Item, Integer> itemCounts = entity.getInventory().getItemCounts();
                    for (Ingredient ingredient : recipe.m_7527_()) {
                        Item firstMatch = itemCounts.keySet().stream().filter(i -> ingredient.test(new ItemStack((ItemLike)i))).findFirst().orElse(null);
                        if (firstMatch != null) {
                            int newCount = itemCounts.get(firstMatch) - 1;
                            if (newCount > 0) {
                                itemCounts.put(firstMatch, newCount);
                                continue;
                            }
                            itemCounts.remove(firstMatch);
                            continue;
                        }
                        ingredientItems.addAll(Arrays.stream(ingredient.m_43908_()).map(ItemStack::m_41720_).toList());
                    }
                }
            }
            if (ingredientItems.isEmpty()) {
                return result;
            }
            result.addAll(ingredientItems);
            result = new HashSet(result.stream().distinct().toList());
            itemsChecked.addAll(items);
            items = ingredientItems.stream().filter(item -> !itemsChecked.contains(item)).collect(Collectors.toSet());
        }
    }
}

