/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.mortality.item;

import java.util.List;
import net.mcreator.mortality.procedures.DeliveranceProcProcedure;
import net.mcreator.mortality.procedures.DeliveranceSummonsMeteorsProcedure;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;

public class LongswordOfTheNewWorldItem
extends SwordItem {
    private long lastUpdateTime = 0L;
    private float animationTime = 0.0f;

    public LongswordOfTheNewWorldItem() {
        super(new Tier(){

            public int m_6609_() {
                return 0;
            }

            public float m_6624_() {
                return 16.0f;
            }

            public float m_6631_() {
                return 26.0f;
            }

            public int m_6604_() {
                return 5;
            }

            public int m_6601_() {
                return 45;
            }

            public Ingredient m_6282_() {
                return Ingredient.m_151265_();
            }
        }, 3, -2.8f, new Item.Properties().m_41486_());
    }

    public Component m_7626_(ItemStack stack) {
        this.updateAnimationTime();
        String text = "Deliverance onto a New World";
        MutableComponent animatedText = Component.m_237119_();
        int dawnStartColor = 0xFF7700;
        int dawnEndColor = 0xFFFF00;
        int devStartColor = 6490981;
        int devMidColor = 15275092;
        int devEndColor = 4202939;
        boolean showDevastation = this.animationTime % 6.0f > 5.5f;
        for (int i = 0; i < text.length(); ++i) {
            float ratio = (float)i / (float)(text.length() - 1);
            int color = showDevastation ? (ratio < 0.5f ? this.interpolateColor(devStartColor, devMidColor, ratio * 2.0f) : this.interpolateColor(devMidColor, devEndColor, (ratio - 0.5f) * 2.0f)) : this.interpolateColor(dawnStartColor, dawnEndColor, ratio);
            float pulse = (Mth.m_14031_((float)(this.animationTime * 2.0f + (float)i * 0.3f)) + 1.0f) * 0.1f + 0.9f;
            color = this.applyBrightness(color, pulse);
            animatedText.m_7220_((Component)Component.m_237113_((String)String.valueOf(text.charAt(i))).m_6270_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)color))));
        }
        return animatedText;
    }

    public void m_7373_(ItemStack itemstack, Level level, List<Component> list, TooltipFlag flag) {
        String[] tooltipLines;
        super.m_7373_(itemstack, level, list, flag);
        this.updateAnimationTime();
        for (String line : tooltipLines = new String[]{"Attacking grants a stack of \"Deliverance\" up to 10 stacks", "Right Click to Consume stacks of \"Deliverance\" to summon an equivalent meteor sum", "Meteors deal 40 Explosion damage in a large radius", "Meteors destroy terrain if gamerules permit"}) {
            list.add((Component)this.createAnimatedTooltipLine(line));
        }
    }

    private MutableComponent createAnimatedTooltipLine(String text) {
        MutableComponent animatedLine = Component.m_237119_();
        int dawnTopColor = 0xFF7700;
        int dawnBottomColor = 0xFFFF00;
        int devTopColor = 6490981;
        int devBottomColor = 4202939;
        for (int i = 0; i < text.length(); ++i) {
            int color;
            float charRatio = (float)i / (float)(text.length() - 1);
            float wavePosition = (float)i / (float)text.length();
            float wave = Mth.m_14031_((float)(this.animationTime * 3.0f + wavePosition * (float)Math.PI * 2.0f)) * 0.3f + 0.5f;
            if (wave < 0.3f) {
                float topRatio = wave / 0.3f;
                color = this.interpolateColor(dawnTopColor, dawnBottomColor, topRatio);
            } else if (wave > 0.7f) {
                float bottomRatio = (wave - 0.7f) / 0.3f;
                color = this.interpolateColor(devTopColor, devBottomColor, bottomRatio);
            } else {
                float middleRatio = (wave - 0.3f) / 0.4f;
                int dawnColor = this.interpolateColor(dawnTopColor, dawnBottomColor, 1.0f);
                int devColor = this.interpolateColor(devTopColor, devBottomColor, 0.0f);
                color = this.interpolateColor(dawnColor, devColor, middleRatio);
            }
            animatedLine.m_7220_((Component)Component.m_237113_((String)String.valueOf(text.charAt(i))).m_6270_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)color))));
        }
        return animatedLine;
    }

    private void updateAnimationTime() {
        long currentTime = System.currentTimeMillis();
        if (this.lastUpdateTime == 0L) {
            this.lastUpdateTime = currentTime;
        }
        float deltaTime = (float)(currentTime - this.lastUpdateTime) / 1000.0f;
        this.animationTime += deltaTime;
        this.lastUpdateTime = currentTime;
        if (this.animationTime > 1000.0f) {
            this.animationTime = 0.0f;
        }
    }

    private int interpolateColor(int startColor, int endColor, float ratio) {
        ratio = Mth.m_14036_((float)ratio, (float)0.0f, (float)1.0f);
        int startR = startColor >> 16 & 0xFF;
        int startG = startColor >> 8 & 0xFF;
        int startB = startColor & 0xFF;
        int endR = endColor >> 16 & 0xFF;
        int endG = endColor >> 8 & 0xFF;
        int endB = endColor & 0xFF;
        int currentR = (int)((float)startR + ratio * (float)(endR - startR));
        int currentG = (int)((float)startG + ratio * (float)(endG - startG));
        int currentB = (int)((float)startB + ratio * (float)(endB - startB));
        return currentR << 16 | currentG << 8 | currentB;
    }

    private int applyBrightness(int color, float brightness) {
        brightness = Mth.m_14036_((float)brightness, (float)0.0f, (float)1.0f);
        int r = color >> 16 & 0xFF;
        int g = color >> 8 & 0xFF;
        int b = color & 0xFF;
        r = (int)((float)r * brightness);
        g = (int)((float)g * brightness);
        b = (int)((float)b * brightness);
        return r << 16 | g << 8 | b;
    }

    public boolean m_7579_(ItemStack itemstack, LivingEntity entity, LivingEntity sourceentity) {
        boolean retval = super.m_7579_(itemstack, entity, sourceentity);
        DeliveranceProcProcedure.execute((Entity)sourceentity);
        return retval;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player entity, InteractionHand hand) {
        InteractionResultHolder ar = super.m_7203_(world, entity, hand);
        DeliveranceSummonsMeteorsProcedure.execute((LevelAccessor)world, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), (Entity)entity);
        return ar;
    }
}

