/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.mortality.item;

import java.util.List;
import net.mcreator.mortality.init.MortalityModItems;
import net.mcreator.mortality.procedures.MalachiteRightclickProcedure;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;

public class MalachiteThrowingDaggerItem
extends SwordItem {
    private static final int[] GRADIENT_COLORS = new int[]{0x2C7C72, 2003473, 12443429, 0x2C7C72};
    private static final long ANIMATION_SPEED = 3000L;

    public MalachiteThrowingDaggerItem() {
        super(new Tier(){

            public int m_6609_() {
                return 3000;
            }

            public float m_6624_() {
                return 20.0f;
            }

            public float m_6631_() {
                return 2.0f;
            }

            public int m_6604_() {
                return 5;
            }

            public int m_6601_() {
                return 21;
            }

            public Ingredient m_6282_() {
                return Ingredient.m_43927_((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)MortalityModItems.PLAGUE_SHELL.get())});
            }
        }, 3, -3.0f, new Item.Properties());
    }

    public Component m_7626_(ItemStack stack) {
        return this.createAnimatedGradientText("Malachite");
    }

    public void m_7373_(ItemStack itemstack, Level level, List<Component> list, TooltipFlag flag) {
        super.m_7373_(itemstack, level, list, flag);
        list.add((Component)this.createAnimatedGradientText("Right Click to Throw a Spread of 3 Knives"));
        list.add((Component)this.createAnimatedGradientText("Inflicts \"Plague\""));
    }

    private MutableComponent createAnimatedGradientText(String text) {
        MutableComponent gradientText = Component.m_237119_();
        int length = text.length();
        long time = System.currentTimeMillis();
        float phase = (float)(time % 3000L) / 3000.0f;
        for (int i = 0; i < length; ++i) {
            float charPosition = (float)i / (float)Math.max(1, length - 1);
            float animatedPosition = (charPosition + phase) % 1.0f;
            int color = this.getSmoothAnimatedColor(animatedPosition);
            gradientText.m_7220_((Component)Component.m_237113_((String)String.valueOf(text.charAt(i))).m_6270_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)color))));
        }
        return gradientText;
    }

    private int getSmoothAnimatedColor(float position) {
        int colorCount = GRADIENT_COLORS.length;
        float segmentLength = 1.0f / (float)(colorCount - 1);
        int segment = (int)(position / segmentLength);
        segment = Math.min(segment, colorCount - 2);
        float segmentRatio = (position - (float)segment * segmentLength) / segmentLength;
        float easedRatio = this.smoothStep(segmentRatio);
        return this.interpolateColor(GRADIENT_COLORS[segment], GRADIENT_COLORS[segment + 1], easedRatio);
    }

    private float smoothStep(float x) {
        return x * x * (3.0f - 2.0f * x);
    }

    private int interpolateColor(int startColor, int endColor, float ratio) {
        int startR = startColor >> 16 & 0xFF;
        int startG = startColor >> 8 & 0xFF;
        int startB = startColor & 0xFF;
        int endR = endColor >> 16 & 0xFF;
        int endG = endColor >> 8 & 0xFF;
        int endB = endColor & 0xFF;
        float currentR = (float)startR + ratio * (float)(endR - startR);
        float currentG = (float)startG + ratio * (float)(endG - startG);
        float currentB = (float)startB + ratio * (float)(endB - startB);
        int r = Mth.m_14045_((int)((int)currentR), (int)0, (int)255);
        int g = Mth.m_14045_((int)((int)currentG), (int)0, (int)255);
        int b = Mth.m_14045_((int)((int)currentB), (int)0, (int)255);
        return r << 16 | g << 8 | b;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player entity, InteractionHand hand) {
        InteractionResultHolder ar = super.m_7203_(world, entity, hand);
        MalachiteRightclickProcedure.execute((LevelAccessor)world, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), (Entity)entity, (ItemStack)ar.m_19095_(), hand);
        return ar;
    }
}

