/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.mortality.item;

import java.util.List;
import net.mcreator.mortality.procedures.ShamanCrestEqProcedure;
import net.mcreator.mortality.procedures.ShamanCrestUneqProcedure;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.type.capability.ICurioItem;

public class ShamanCrestItem
extends Item
implements ICurioItem {
    private static final int COLOR_WHITE = 0xFFFFFF;
    private static final int COLOR_PURPLE = 11540937;
    private static final int COLOR_PINK = 16737753;
    private static final int COLOR_GREEN = 3066993;
    private static final int COLOR_LIME = 65280;
    private static final int COLOR_YELLOW_GREEN = 10145074;
    private static final int COLOR_MAGENTA = 0xFF00FF;
    private static final long ANIMATION_SPEED = 8000L;

    public ShamanCrestItem() {
        super(new Item.Properties().m_41487_(1).m_41486_().m_41497_(Rarity.COMMON));
    }

    public Component m_7626_(ItemStack stack) {
        return this.createAnimatedText("Shaman Crest");
    }

    private MutableComponent createAnimatedText(String text) {
        MutableComponent animatedText = Component.m_237119_();
        int length = text.length();
        long time = System.currentTimeMillis();
        float phase = (float)(time % 8000L) / 8000.0f;
        for (int i = 0; i < length; ++i) {
            float charOffset = (float)i / (float)length * 0.3f;
            float charPhase = (phase + charOffset) % 1.0f;
            int color = this.getEnchantingColor(charPhase);
            animatedText.m_7220_((Component)Component.m_237113_((String)String.valueOf(text.charAt(i))).m_6270_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)color))));
        }
        return animatedText;
    }

    private int getEnchantingColor(float phase) {
        if (phase < 0.2f) {
            return this.interpolateColor(0xFFFFFF, 11540937, phase * 5.0f);
        }
        if (phase < 0.3f) {
            return this.interpolateColor(11540937, 16737753, (phase - 0.2f) * 10.0f);
        }
        if (phase < 0.4f) {
            return this.interpolateColor(16737753, 3066993, (phase - 0.3f) * 10.0f);
        }
        if (phase < 0.5f) {
            return this.interpolateColor(3066993, 65280, (phase - 0.4f) * 10.0f);
        }
        if (phase < 0.6f) {
            return this.interpolateColor(65280, 10145074, (phase - 0.5f) * 10.0f);
        }
        if (phase < 0.7f) {
            return this.interpolateColor(10145074, 0xFF00FF, (phase - 0.6f) * 10.0f);
        }
        if (phase < 0.8f) {
            return this.interpolateColor(0xFF00FF, 11540937, (phase - 0.7f) * 10.0f);
        }
        return this.interpolateColor(11540937, 0xFFFFFF, (phase - 0.8f) * 5.0f);
    }

    private int interpolateColor(int startColor, int endColor, float ratio) {
        ratio = Mth.m_14036_((float)ratio, (float)0.0f, (float)1.0f);
        int startR = startColor >> 16 & 0xFF;
        int startG = startColor >> 8 & 0xFF;
        int startB = startColor & 0xFF;
        int endR = endColor >> 16 & 0xFF;
        int endG = endColor >> 8 & 0xFF;
        int endB = endColor & 0xFF;
        float currentR = (float)startR + ratio * (float)(endR - startR);
        float currentG = (float)startG + ratio * (float)(endG - startG);
        float currentB = (float)startB + ratio * (float)(endB - startB);
        int r = Mth.m_14045_((int)((int)currentR), (int)0, (int)255);
        int g = Mth.m_14045_((int)((int)currentG), (int)0, (int)255);
        int b = Mth.m_14045_((int)((int)currentB), (int)0, (int)255);
        return r << 16 | g << 8 | b;
    }

    public void m_7373_(ItemStack itemstack, Level level, List<Component> list, TooltipFlag flag) {
        super.m_7373_(itemstack, level, list, flag);
        list.add((Component)Component.m_237113_((String)"Passive Effect:"));
        list.add((Component)Component.m_237113_((String)"-Grants Two Additional Curios Slots"));
    }

    public void onEquip(SlotContext slotContext, ItemStack prevStack, ItemStack stack) {
        if ("crest_slot".equals(slotContext.identifier())) {
            ShamanCrestEqProcedure.execute((Entity)slotContext.entity());
        }
    }

    public void onUnequip(SlotContext slotContext, ItemStack newStack, ItemStack stack) {
        if ("crest_slot".equals(slotContext.identifier())) {
            ShamanCrestUneqProcedure.execute((Entity)slotContext.entity());
        }
    }

    public boolean canEquip(SlotContext slotContext, ItemStack stack) {
        return "crest_slot".equals(slotContext.identifier());
    }
}

