/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.mortality.procedures;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.mcreator.mortality.MortalityMod;
import net.mcreator.mortality.entity.VenoshopodEntity;
import net.mcreator.mortality.init.MortalityModMobEffects;
import net.mcreator.mortality.init.MortalityModParticleTypes;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.core.registries.Registries;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class VenoshopodSuperattackProcedure {
    private static final int ATTACK_COUNT = 3;
    private static final int[] ATTACK_DELAYS = new int[]{8, 11, 15};
    private static final float DAMAGE = 10.0f;
    private static final double ATTACK_RADIUS_XZ = 5.5;
    private static final double ATTACK_RADIUS_Y = 2.0;
    private static final double ATTACK_HEIGHT_OFFSET = 1.2;
    private static final double PARTICLE_HEIGHT_OFFSET = 2.5;
    private static final int PLAGUE_DURATION = 100;
    private static final int ARMOR_CRUNCH_DURATION = 140;
    private static final int COOLDOWN_DURATION = 200;
    private static final int MAX_HARVEST_LEVEL = 2;
    private static final float BLOCK_DROP_CHANCE = 0.1f;
    private static final Random RANDOM = new Random();
    private static final Predicate<Entity> VALID_TARGET_PREDICATE = entity -> !(entity instanceof VenoshopodEntity) && entity instanceof LivingEntity;

    @SubscribeEvent
    public static void onEntityAttacked(LivingHurtEvent event) {
        if (event != null && event.getEntity() != null) {
            VenoshopodSuperattackProcedure.execute((Event)event, (LevelAccessor)event.getEntity().m_9236_(), (Entity)event.getEntity(), event.getSource().m_7639_());
        }
    }

    public static void execute(LevelAccessor world, Entity entity, Entity sourceentity) {
        VenoshopodSuperattackProcedure.execute(null, world, entity, sourceentity);
    }

    private static void execute(@Nullable Event event, LevelAccessor world, Entity entity, Entity sourceentity) {
        LivingEntity livingAttacker;
        if (entity == null || sourceentity == null) {
            return;
        }
        if (sourceentity instanceof VenoshopodEntity && sourceentity instanceof LivingEntity && !(livingAttacker = (LivingEntity)sourceentity).m_21023_((MobEffect)MortalityModMobEffects.MORTALITY_ATTACKING.get())) {
            VenoshopodSuperattackProcedure.initiateSpecialAttack(event, world, livingAttacker);
        }
    }

    private static void initiateSpecialAttack(@Nullable Event event, LevelAccessor world, LivingEntity attacker) {
        if (!attacker.m_9236_().m_5776_()) {
            attacker.m_7292_(new MobEffectInstance((MobEffect)MortalityModMobEffects.MORTALITY_ATTACKING.get(), 200, 0));
        }
        if (attacker instanceof VenoshopodEntity) {
            VenoshopodEntity venoshopod = (VenoshopodEntity)attacker;
            venoshopod.setAnimation("animation.venoshopod.ravage");
        }
        if (event != null && event.isCancelable()) {
            event.setCanceled(true);
        }
        for (int i = 0; i < 3; ++i) {
            int attackIndex = i;
            MortalityMod.queueServerWork(ATTACK_DELAYS[i], () -> VenoshopodSuperattackProcedure.performAreaAttack(world, attacker, attackIndex));
        }
    }

    private static void performAreaAttack(LevelAccessor world, LivingEntity attacker, int attackIndex) {
        Vec3 center = new Vec3(attacker.m_20185_(), attacker.m_20186_() + 1.2, attacker.m_20189_());
        AABB attackArea = new AABB(center.f_82479_ - 5.5, center.f_82480_ - 2.0, center.f_82481_ - 5.5, center.f_82479_ + 5.5, center.f_82480_ + 2.0, center.f_82481_ + 5.5);
        List entitiesInRange = world.m_6443_(Entity.class, attackArea, VALID_TARGET_PREDICATE);
        for (Entity target : entitiesInRange) {
            VenoshopodSuperattackProcedure.applyAttackEffects(world, (Entity)attacker, target);
        }
        VenoshopodSuperattackProcedure.destroyBlocksInArea(world, attacker);
        VenoshopodSuperattackProcedure.spawnAttackParticles(world, (Entity)attacker);
    }

    private static void destroyBlocksInArea(LevelAccessor world, LivingEntity attacker) {
        if (!(world instanceof Level)) {
            return;
        }
        Level level = (Level)world;
        Vec3 center = new Vec3(attacker.m_20185_(), attacker.m_20186_(), attacker.m_20189_());
        int radiusXZ = (int)Math.ceil(5.5);
        int minY = (int)Math.floor(center.f_82480_) - 1;
        int maxY = (int)Math.floor(center.f_82480_) + 2;
        ArrayList<BlockPos> candidateBlocks = new ArrayList<BlockPos>();
        for (int x = -radiusXZ; x <= radiusXZ; ++x) {
            for (int y = minY; y <= maxY; ++y) {
                for (int z = -radiusXZ; z <= radiusXZ; ++z) {
                    double verticalDistance;
                    BlockPos pos = new BlockPos((int)center.f_82479_ + x, y, (int)center.f_82481_ + z);
                    double horizontalDistance = Math.sqrt(x * x + z * z);
                    if (!(horizontalDistance * horizontalDistance / 30.25 + (verticalDistance = Math.abs((double)y - center.f_82480_)) * verticalDistance / 4.0 <= 1.0)) continue;
                    candidateBlocks.add(pos);
                }
            }
        }
        for (BlockPos pos : candidateBlocks) {
            if (!VenoshopodSuperattackProcedure.isBlockConnectedToAir(level, pos)) continue;
            VenoshopodSuperattackProcedure.attemptBreakBlock(level, pos, attacker);
        }
    }

    private static boolean isBlockConnectedToAir(Level level, BlockPos pos) {
        BlockState blockState = level.m_8055_(pos);
        if (blockState.m_60795_() || blockState.m_60800_((BlockGetter)level, pos) < 0.0f) {
            return false;
        }
        for (Direction direction : Direction.values()) {
            BlockPos adjacentPos = pos.m_121945_(direction);
            BlockState adjacentState = level.m_8055_(adjacentPos);
            if (!adjacentState.m_60795_()) continue;
            return true;
        }
        return false;
    }

    private static void attemptBreakBlock(Level level, BlockPos pos, LivingEntity attacker) {
        BlockState blockState = level.m_8055_(pos);
        if (blockState.m_60795_() || blockState.m_60800_((BlockGetter)level, pos) < 0.0f) {
            return;
        }
        if (VenoshopodSuperattackProcedure.getBlockHarvestLevel(blockState) <= 2) {
            boolean shouldDropBlock;
            boolean bl = shouldDropBlock = RANDOM.nextFloat() <= 0.1f;
            if (shouldDropBlock) {
                Block.m_49950_((BlockState)blockState, (Level)level, (BlockPos)pos);
            }
            level.m_46961_(pos, false);
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                serverLevel.m_8767_((ParticleOptions)((SimpleParticleType)MortalityModParticleTypes.CLAW_STRIKE_PARTICLE.get()), (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, 3, 0.3, 0.3, 0.3, 0.1);
            }
        }
    }

    private static int getBlockHarvestLevel(BlockState blockState) {
        Block block = blockState.m_60734_();
        if (blockState.m_60834_()) {
            float hardness = blockState.m_60800_(null, null);
            if (hardness >= 50.0f) {
                return 4;
            }
            if (hardness >= 30.0f) {
                return 3;
            }
            if (hardness >= 15.0f) {
                return 2;
            }
            if (hardness >= 5.0f) {
                return 1;
            }
            return 0;
        }
        return 0;
    }

    private static void applyAttackEffects(LevelAccessor world, Entity attacker, Entity target) {
        if (!(target instanceof LivingEntity)) {
            return;
        }
        LivingEntity livingTarget = (LivingEntity)target;
        DamageSource damageSource = new DamageSource((Holder)world.m_9598_().m_175515_(Registries.f_268580_).m_246971_(DamageTypes.f_268433_), attacker);
        livingTarget.m_6469_(damageSource, 10.0f);
        if (!livingTarget.m_9236_().m_5776_()) {
            livingTarget.m_7292_(new MobEffectInstance((MobEffect)MortalityModMobEffects.PLAGUE.get(), 100, 1));
            livingTarget.m_7292_(new MobEffectInstance((MobEffect)MortalityModMobEffects.ARMOR_CRUNCH.get(), 140, 0));
        }
    }

    private static void spawnAttackParticles(LevelAccessor world, Entity attacker) {
        if (world instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)world;
            serverLevel.m_8767_((ParticleOptions)((SimpleParticleType)MortalityModParticleTypes.CLAW_STRIKE_PARTICLE.get()), attacker.m_20185_(), attacker.m_20186_() + 2.5, attacker.m_20189_(), 5, 5.0, 3.0, 5.0, 0.0);
        }
    }
}

