/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.mortality.item;

import java.util.List;
import net.mcreator.mortality.procedures.ArchitectCrestEqProcedure;
import net.mcreator.mortality.procedures.ArchitectCrestUneqProcedure;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.type.capability.ICurioItem;

public class ArchitectCrestItem
extends Item
implements ICurioItem {
    private static final int COLOR_WHITE = 0xFFFFFF;
    private static final long ANIMATION_SPEED = 5000L;
    private static final long WHITE_DURATION = 2500L;
    private static final long RGB_DURATION = 2500L;

    public ArchitectCrestItem() {
        super(new Item.Properties().m_41487_(1).m_41486_().m_41497_(Rarity.COMMON));
    }

    public Component m_7626_(ItemStack stack) {
        return this.createAnimatedText("Architect Crest");
    }

    private MutableComponent createAnimatedText(String text) {
        MutableComponent animatedText = Component.m_237119_();
        int length = text.length();
        long time = System.currentTimeMillis();
        long cycleTime = time % 5000L;
        for (int i = 0; i < length; ++i) {
            float charOffset = (float)i / (float)length * 0.3f;
            long charTime = (cycleTime + (long)(charOffset * 5000.0f)) % 5000L;
            int color = this.getColorForTime(charTime);
            animatedText.m_7220_((Component)Component.m_237113_((String)String.valueOf(text.charAt(i))).m_6270_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)color))));
        }
        return animatedText;
    }

    private int getColorForTime(long timeInCycle) {
        if (timeInCycle < 2500L) {
            return 0xFFFFFF;
        }
        float rgbPhase = (float)(timeInCycle - 2500L) / 2500.0f;
        return this.getRGBSpectrumColor(rgbPhase);
    }

    private int getRGBSpectrumColor(float phase) {
        float r = 0.0f;
        float g = 0.0f;
        float b = 0.0f;
        if (phase < 0.16666667f) {
            r = 1.0f;
            g = phase * 6.0f;
            b = 0.0f;
        } else if (phase < 0.33333334f) {
            r = 1.0f - (phase - 0.16666667f) * 6.0f;
            g = 1.0f;
            b = 0.0f;
        } else if (phase < 0.5f) {
            r = 0.0f;
            g = 1.0f;
            b = (phase - 0.33333334f) * 6.0f;
        } else if (phase < 0.6666667f) {
            r = 0.0f;
            g = 1.0f - (phase - 0.5f) * 6.0f;
            b = 1.0f;
        } else if (phase < 0.8333333f) {
            r = (phase - 0.6666667f) * 6.0f;
            g = 0.0f;
            b = 1.0f;
        } else {
            r = 1.0f;
            g = 0.0f;
            b = 1.0f - (phase - 0.8333333f) * 6.0f;
        }
        int red = (int)(r * 255.0f);
        int green = (int)(g * 255.0f);
        int blue = (int)(b * 255.0f);
        return red << 16 | green << 8 | blue;
    }

    public void m_7373_(ItemStack itemstack, Level level, List<Component> list, TooltipFlag flag) {
        super.m_7373_(itemstack, level, list, flag);
        list.add((Component)Component.m_237113_((String)"Passive Effect:"));
        list.add((Component)Component.m_237113_((String)"-Grants an Additional Curio Slot"));
        list.add((Component)Component.m_237113_((String)"-Grants an Additional Belt Slot"));
        list.add((Component)Component.m_237113_((String)"-Grants Two Additional Charm Slots"));
        list.add((Component)Component.m_237113_((String)"-Grants an Additional Ring Slot"));
    }

    public void onEquip(SlotContext slotContext, ItemStack prevStack, ItemStack stack) {
        if ("crest_slot".equals(slotContext.identifier())) {
            ArchitectCrestEqProcedure.execute((Entity)slotContext.entity());
        }
    }

    public void onUnequip(SlotContext slotContext, ItemStack newStack, ItemStack stack) {
        if ("crest_slot".equals(slotContext.identifier())) {
            ArchitectCrestUneqProcedure.execute((Entity)slotContext.entity());
        }
    }

    public boolean canEquip(SlotContext slotContext, ItemStack stack) {
        return "crest_slot".equals(slotContext.identifier());
    }
}

