/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.mortality.item;

import java.util.List;
import net.mcreator.mortality.procedures.HunterCrestEqProcedure;
import net.mcreator.mortality.procedures.HunterCrestUneqProcedure;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.type.capability.ICurioItem;

public class HuntersCrestItem
extends Item
implements ICurioItem {
    private static final int COLOR_WHITE = 0xFFFFFF;
    private static final int COLOR_LIME = 65280;
    private static final long ANIMATION_SPEED = 5000L;

    public HuntersCrestItem() {
        super(new Item.Properties().m_41487_(1).m_41486_().m_41497_(Rarity.COMMON));
    }

    public Component m_7626_(ItemStack stack) {
        return this.createAnimatedText("Hunter's Crest");
    }

    private MutableComponent createAnimatedText(String text) {
        MutableComponent animatedText = Component.m_237119_();
        int length = text.length();
        long time = System.currentTimeMillis();
        float phase = (float)(time % 5000L) / 5000.0f;
        float oscillation = (Mth.m_14031_((float)(phase * ((float)Math.PI * 2))) + 1.0f) / 2.0f;
        for (int i = 0; i < length; ++i) {
            float charOffset = (float)i / (float)length * 0.3f;
            float charPhase = (phase + charOffset) % 1.0f;
            float charOscillation = (Mth.m_14031_((float)(charPhase * ((float)Math.PI * 2))) + 1.0f) / 2.0f;
            int color = this.interpolateColor(0xFFFFFF, 65280, charOscillation);
            animatedText.m_7220_((Component)Component.m_237113_((String)String.valueOf(text.charAt(i))).m_6270_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)color))));
        }
        return animatedText;
    }

    private int interpolateColor(int startColor, int endColor, float ratio) {
        int startR = startColor >> 16 & 0xFF;
        int startG = startColor >> 8 & 0xFF;
        int startB = startColor & 0xFF;
        int endR = endColor >> 16 & 0xFF;
        int endG = endColor >> 8 & 0xFF;
        int endB = endColor & 0xFF;
        float currentR = (float)startR + ratio * (float)(endR - startR);
        float currentG = (float)startG + ratio * (float)(endG - startG);
        float currentB = (float)startB + ratio * (float)(endB - startB);
        int r = Mth.m_14045_((int)((int)currentR), (int)0, (int)255);
        int g = Mth.m_14045_((int)((int)currentG), (int)0, (int)255);
        int b = Mth.m_14045_((int)((int)currentB), (int)0, (int)255);
        return r << 16 | g << 8 | b;
    }

    public void m_7373_(ItemStack itemstack, Level level, List<Component> list, TooltipFlag flag) {
        super.m_7373_(itemstack, level, list, flag);
        list.add((Component)Component.m_237113_((String)"Passive Effect:"));
        list.add((Component)Component.m_237113_((String)"-Grants an Additional Ring Slot"));
        list.add((Component)Component.m_237113_((String)"-Grants an Additional Necklace Slot"));
        list.add((Component)Component.m_237113_((String)"-Grants an Additional Charm Slot"));
    }

    public void onEquip(SlotContext slotContext, ItemStack prevStack, ItemStack stack) {
        if ("crest_slot".equals(slotContext.identifier())) {
            HunterCrestEqProcedure.execute((Entity)slotContext.entity());
        }
    }

    public void onUnequip(SlotContext slotContext, ItemStack newStack, ItemStack stack) {
        if ("crest_slot".equals(slotContext.identifier())) {
            HunterCrestUneqProcedure.execute((Entity)slotContext.entity());
        }
    }

    public boolean canEquip(SlotContext slotContext, ItemStack stack) {
        return "crest_slot".equals(slotContext.identifier());
    }
}

