/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.mortality.item;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.util.List;
import net.mcreator.mortality.procedures.DreamtwisterRightclickProcedure;
import net.mcreator.mortality.procedures.DreamtwisterWithinTheHandProcedure;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;

public class IridiumDreamtwisterItem
extends Item {
    private static final int[] NAME_COLORS = new int[]{5782877, 8145525, 11360904, 14383253, 8145525};
    private static final int[] TOOLTIP_COLORS = new int[]{12160039, 13803308, 14530142, 16247504, 0xFFFFFF};

    public IridiumDreamtwisterItem() {
        super(new Item.Properties().m_41503_(100));
    }

    public Component m_7626_(ItemStack stack) {
        long time = System.currentTimeMillis();
        String itemName = "Iridium Dreamtwister";
        MutableComponent animatedName = Component.m_237113_((String)"");
        for (int i = 0; i < itemName.length(); ++i) {
            char c = itemName.charAt(i);
            if (c == ' ') {
                animatedName.m_130946_(" ");
                continue;
            }
            float wavePosition = (float)i / (float)itemName.length();
            float timeOffset = (float)(time % 4000L) / 4000.0f;
            float charOffset = (wavePosition + timeOffset) % 1.0f;
            float colorPos = charOffset * (float)(NAME_COLORS.length - 1);
            int colorIndex1 = (int)Math.floor(colorPos);
            int colorIndex2 = (colorIndex1 + 1) % NAME_COLORS.length;
            float blend = colorPos - (float)colorIndex1;
            int color1 = NAME_COLORS[colorIndex1];
            int color2 = NAME_COLORS[colorIndex2];
            int finalColor = this.interpolateColor(color1, color2, blend);
            MutableComponent charComponent = Component.m_237113_((String)String.valueOf(c));
            charComponent.m_6270_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)finalColor)));
            animatedName.m_7220_((Component)charComponent);
        }
        return animatedName;
    }

    public void m_7373_(ItemStack itemstack, Level level, List<Component> list, TooltipFlag flag) {
        super.m_7373_(itemstack, level, list, flag);
        long time = System.currentTimeMillis();
        float progress = (float)(time % 5000L) / 5000.0f;
        float smoothProgress = (float)((Math.sin((double)(progress * 2.0f) * Math.PI - 1.5707963267948966) + 1.0) / 2.0);
        float colorPos = smoothProgress * (float)(TOOLTIP_COLORS.length - 1);
        int colorIndex1 = (int)Math.floor(colorPos);
        int colorIndex2 = Math.min(colorIndex1 + 1, TOOLTIP_COLORS.length - 1);
        float blend = colorPos - (float)colorIndex1;
        int color1 = TOOLTIP_COLORS[colorIndex1];
        int color2 = TOOLTIP_COLORS[colorIndex2];
        int currentColor = this.interpolateColor(color1, color2, blend);
        MutableComponent tooltip = Component.m_237113_((String)"Capture and Twist Dreams into Solid Form");
        list.add((Component)tooltip.m_130948_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)currentColor))));
    }

    private int interpolateColor(int color1, int color2, float blend) {
        int r1 = color1 >> 16 & 0xFF;
        int g1 = color1 >> 8 & 0xFF;
        int b1 = color1 & 0xFF;
        int r2 = color2 >> 16 & 0xFF;
        int g2 = color2 >> 8 & 0xFF;
        int b2 = color2 & 0xFF;
        int r = (int)((float)r1 + (float)(r2 - r1) * blend);
        int g = (int)((float)g1 + (float)(g2 - g1) * blend);
        int b = (int)((float)b1 + (float)(b2 - b1) * blend);
        return r << 16 | g << 8 | b;
    }

    public float m_8102_(ItemStack itemstack, BlockState blockstate) {
        return 1.0f;
    }

    public boolean m_6813_(ItemStack itemstack, Level world, BlockState blockstate, BlockPos pos, LivingEntity entity) {
        itemstack.m_41622_(1, entity, i -> i.m_21166_(EquipmentSlot.MAINHAND));
        return true;
    }

    public boolean m_7579_(ItemStack itemstack, LivingEntity entity, LivingEntity sourceentity) {
        itemstack.m_41622_(2, entity, i -> i.m_21166_(EquipmentSlot.MAINHAND));
        return true;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player entity, InteractionHand hand) {
        InteractionResultHolder ar = super.m_7203_(world, entity, hand);
        DreamtwisterRightclickProcedure.execute((LevelAccessor)world, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), (Entity)entity, (ItemStack)ar.m_19095_());
        return ar;
    }

    public int m_6473_() {
        return 30;
    }

    public Multimap<Attribute, AttributeModifier> m_7167_(EquipmentSlot equipmentSlot) {
        if (equipmentSlot == EquipmentSlot.MAINHAND) {
            ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
            builder.putAll(super.m_7167_(equipmentSlot));
            builder.put((Object)Attributes.f_22281_, (Object)new AttributeModifier(f_41374_, "Tool modifier", 4.0, AttributeModifier.Operation.ADDITION));
            builder.put((Object)Attributes.f_22283_, (Object)new AttributeModifier(f_41375_, "Tool modifier", -3.2, AttributeModifier.Operation.ADDITION));
            return builder.build();
        }
        return super.m_7167_(equipmentSlot);
    }

    public boolean hasCraftingRemainingItem(ItemStack stack) {
        return true;
    }

    public ItemStack getCraftingRemainingItem(ItemStack itemstack) {
        ItemStack retval = new ItemStack((ItemLike)this);
        retval.m_41721_(itemstack.m_41773_() + 1);
        if (retval.m_41773_() >= retval.m_41776_()) {
            return ItemStack.f_41583_;
        }
        return retval;
    }

    public boolean isRepairable(ItemStack itemstack) {
        return false;
    }

    public void m_6883_(ItemStack itemstack, Level world, Entity entity, int slot, boolean selected) {
        super.m_6883_(itemstack, world, entity, slot, selected);
        if (selected) {
            DreamtwisterWithinTheHandProcedure.execute((LevelAccessor)world, entity);
        }
    }
}

