/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.mortality.item;

import java.util.List;
import net.mcreator.mortality.procedures.RacherUseProcedure;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.Level;

public class RacherGlaiveItem
extends SwordItem {
    private static final int[] COLORS = new int[]{-15066845, -15659756, -14871267, -7791812, -12973528, -11335338, -9436539};
    private static final long ANIMATION_DURATION = 6000L;

    public RacherGlaiveItem() {
        super(new Tier(){

            public int m_6609_() {
                return 8900;
            }

            public float m_6624_() {
                return 10.0f;
            }

            public float m_6631_() {
                return 14.0f;
            }

            public int m_6604_() {
                return 4;
            }

            public int m_6601_() {
                return 30;
            }

            public Ingredient m_6282_() {
                return Ingredient.m_151265_();
            }
        }, 3, -2.8f, new Item.Properties().m_41486_());
    }

    public boolean m_7579_(ItemStack itemstack, LivingEntity entity, LivingEntity sourceentity) {
        boolean retval = super.m_7579_(itemstack, entity, sourceentity);
        RacherUseProcedure.execute((Entity)sourceentity);
        return retval;
    }

    public void m_7373_(ItemStack itemstack, Level level, List<Component> list, TooltipFlag flag) {
        super.m_7373_(itemstack, level, list, flag);
        long currentTime = System.currentTimeMillis();
        list.add((Component)this.createAnimatedText("Each attack gives a stack of \"Bond of Life\"", currentTime, 0L));
        list.add((Component)this.createAnimatedText("Each stack of \"Bond of Life\" reduces Max Hp by 2", currentTime, 500L));
        list.add((Component)this.createAnimatedText("Each stack of \"Bond of Life\" increases Attack Damage by 3", currentTime, 1000L));
    }

    public Component m_7626_(ItemStack stack) {
        long currentTime = System.currentTimeMillis();
        return this.createAnimatedText("R\u00e4cher of Solnari", currentTime, 0L);
    }

    private MutableComponent createAnimatedText(String text, long currentTime, long timeOffset) {
        MutableComponent component = Component.m_237119_();
        long animationTime = (currentTime + timeOffset) % 6000L;
        float progress = (float)animationTime / 6000.0f;
        int colorIndex = (int)(progress * (float)COLORS.length);
        float lerpFactor = progress * (float)COLORS.length - (float)colorIndex;
        int currentColor = this.lerpColor(COLORS[colorIndex % COLORS.length], COLORS[(colorIndex + 1) % COLORS.length], lerpFactor);
        return Component.m_237113_((String)text).m_6270_(Style.f_131099_.m_178520_(currentColor));
    }

    private int lerpColor(int color1, int color2, float factor) {
        int r1 = color1 >> 16 & 0xFF;
        int g1 = color1 >> 8 & 0xFF;
        int b1 = color1 & 0xFF;
        int r2 = color2 >> 16 & 0xFF;
        int g2 = color2 >> 8 & 0xFF;
        int b2 = color2 & 0xFF;
        int r = (int)((float)r1 + (float)(r2 - r1) * factor);
        int g = (int)((float)g1 + (float)(g2 - g1) * factor);
        int b = (int)((float)b1 + (float)(b2 - b1) * factor);
        return r << 16 | g << 8 | b;
    }
}

