/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.mortality.item;

import java.util.List;
import java.util.Random;
import net.mcreator.mortality.init.MortalityModItems;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.util.Mth;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class TheScrapzoneKatanaItem
extends SwordItem {
    private static final int[] BASE_COLORS = new int[]{2003473, 0x2C7C72, 12443429, 2003473};
    private static final int[] RUST_COLORS = new int[]{9127187, 12092939, 13468991, 13789470, 9127187};
    private static final long BASE_ANIMATION_SPEED = 3000L;
    private static final long RUST_SWEEP_SPEED = 8000L;
    private static final int RUST_CLUSTER_SIZE = 4;
    private static final float RUST_SWEEP_CHANCE = 0.3f;
    private static final Random RANDOM = new Random();
    private long lastRustSweepTime = 0L;
    private boolean isRustSweeping = false;
    private int rustSweepPosition = 0;

    public TheScrapzoneKatanaItem() {
        super(new Tier(){

            public int m_6609_() {
                return 15000;
            }

            public float m_6624_() {
                return 15.0f;
            }

            public float m_6631_() {
                return 11.0f;
            }

            public int m_6604_() {
                return 5;
            }

            public int m_6601_() {
                return 32;
            }

            public Ingredient m_6282_() {
                return Ingredient.m_43927_((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)MortalityModItems.PLAGUE_CANISTER.get()), new ItemStack((ItemLike)MortalityModItems.PLAGUE_INJECTOR.get())});
            }
        }, 3, -1.5f, new Item.Properties().m_41486_());
    }

    public Component m_7626_(ItemStack stack) {
        return this.createDualSpeedGradientText("The Scrapzone");
    }

    public void m_7373_(ItemStack itemstack, Level level, List<Component> list, TooltipFlag flag) {
        super.m_7373_(itemstack, level, list, flag);
        list.add((Component)this.createDualSpeedGradientText("'Salvaged'"));
        list.add((Component)this.createDualSpeedGradientText("Killing entities with this weapon duplicates lootables"));
    }

    private MutableComponent createDualSpeedGradientText(String text) {
        MutableComponent gradientText = Component.m_237119_();
        int length = text.length();
        long currentTime = System.currentTimeMillis();
        float basePhase = (float)(currentTime % 3000L) / 3000.0f;
        this.updateRustSweepState(currentTime, length);
        for (int i = 0; i < length; ++i) {
            int color;
            if (this.isRustSweeping && i >= this.rustSweepPosition && i < this.rustSweepPosition + 4) {
                float rustPhase = (float)(currentTime % 500L) / 500.0f;
                float rustPosition = ((float)(i - this.rustSweepPosition) / 4.0f + rustPhase) % 1.0f;
                color = this.getRustColor(rustPosition);
            } else {
                float charPosition = (float)i / (float)Math.max(1, length - 1);
                float basePosition = (charPosition + basePhase) % 1.0f;
                color = this.getBaseColor(basePosition);
            }
            gradientText.m_7220_((Component)Component.m_237113_((String)String.valueOf(text.charAt(i))).m_6270_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)color))));
        }
        return gradientText;
    }

    private void updateRustSweepState(long currentTime, int textLength) {
        if (!this.isRustSweeping && currentTime - this.lastRustSweepTime > 3000L && RANDOM.nextFloat() < 0.3f) {
            this.isRustSweeping = true;
            this.rustSweepPosition = -4;
            this.lastRustSweepTime = currentTime;
        }
        if (this.isRustSweeping) {
            long sweepProgress = currentTime - this.lastRustSweepTime;
            float sweepRatio = (float)sweepProgress / 8000.0f;
            this.rustSweepPosition = (int)(sweepRatio * (float)(textLength + 4)) - 4;
            if (this.rustSweepPosition >= textLength) {
                this.isRustSweeping = false;
            }
        }
    }

    private int getBaseColor(float position) {
        int colorCount = BASE_COLORS.length;
        float segmentLength = 1.0f / (float)(colorCount - 1);
        int segment = (int)(position / segmentLength);
        segment = Math.min(segment, colorCount - 2);
        float segmentRatio = (position - (float)segment * segmentLength) / segmentLength;
        float easedRatio = this.smoothStep(segmentRatio);
        return this.interpolateColor(BASE_COLORS[segment], BASE_COLORS[segment + 1], easedRatio);
    }

    private int getRustColor(float position) {
        int colorCount = RUST_COLORS.length;
        float segmentLength = 1.0f / (float)(colorCount - 1);
        int segment = (int)(position / segmentLength);
        segment = Math.min(segment, colorCount - 2);
        float segmentRatio = (position - (float)segment * segmentLength) / segmentLength;
        float easedRatio = this.smoothStep(segmentRatio);
        return this.interpolateColor(RUST_COLORS[segment], RUST_COLORS[segment + 1], easedRatio);
    }

    private float smoothStep(float x) {
        return x * x * (3.0f - 2.0f * x);
    }

    private int interpolateColor(int startColor, int endColor, float ratio) {
        int startR = startColor >> 16 & 0xFF;
        int startG = startColor >> 8 & 0xFF;
        int startB = startColor & 0xFF;
        int endR = endColor >> 16 & 0xFF;
        int endG = endColor >> 8 & 0xFF;
        int endB = endColor & 0xFF;
        float currentR = (float)startR + ratio * (float)(endR - startR);
        float currentG = (float)startG + ratio * (float)(endG - startG);
        float currentB = (float)startB + ratio * (float)(endB - startB);
        int r = Mth.m_14045_((int)((int)currentR), (int)0, (int)255);
        int g = Mth.m_14045_((int)((int)currentG), (int)0, (int)255);
        int b = Mth.m_14045_((int)((int)currentB), (int)0, (int)255);
        return r << 16 | g << 8 | b;
    }
}

