/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.mortality.item;

import java.util.List;
import java.util.Random;
import net.mcreator.mortality.procedures.WitcherCrestEqProcedure;
import net.mcreator.mortality.procedures.WitcherCrestUneqProcedure;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.type.capability.ICurioItem;

public class WitcherCrestItem
extends Item
implements ICurioItem {
    private static final int COLOR_WHITE = 0xFFFFFF;
    private static final int COLOR_POISON_GREEN = 3329330;
    private static final int COLOR_DARK_GREEN = 25600;
    private static final int COLOR_POISON_PURPLE = 9055202;
    private static final int COLOR_TOXIC_PINK = 16716947;
    private static final int COLOR_VENOM_YELLOW = 0xCCCC00;
    private static final int COLOR_ACID_BLUE = 4251856;
    private static final int[] EERIE_COLORS = new int[]{3329330, 25600, 9055202, 16716947, 0xCCCC00, 4251856};
    private static final long ANIMATION_SPEED = 4000L;
    private static final Random RANDOM = new Random();

    public WitcherCrestItem() {
        super(new Item.Properties().m_41487_(1).m_41486_().m_41497_(Rarity.COMMON));
    }

    public Component m_7626_(ItemStack stack) {
        return this.createAnimatedText("Witcher Crest");
    }

    private MutableComponent createAnimatedText(String text) {
        MutableComponent animatedText = Component.m_237119_();
        int length = text.length();
        long time = System.currentTimeMillis();
        float phase = (float)(time % 4000L) / 4000.0f;
        long seed = time / 4000L;
        Random colorRandom = new Random(seed);
        for (int i = 0; i < length; ++i) {
            float charOffset = (float)i / (float)length * 0.3f;
            float charPhase = (phase + charOffset) % 1.0f;
            int color = this.getRandomEerieColor(charPhase, colorRandom, i);
            animatedText.m_7220_((Component)Component.m_237113_((String)String.valueOf(text.charAt(i))).m_6270_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)color))));
        }
        return animatedText;
    }

    private int getRandomEerieColor(float phase, Random random, int charIndex) {
        if (phase < 0.1f || phase > 0.45f && phase < 0.55f || phase > 0.9f) {
            if (phase < 0.1f) {
                return this.interpolateColor(0xFFFFFF, this.getRandomEerieColor(0.1f, random, charIndex), phase * 10.0f);
            }
            if (phase > 0.9f) {
                return this.interpolateColor(this.getRandomEerieColor(0.9f, random, charIndex), 0xFFFFFF, (phase - 0.9f) * 10.0f);
            }
            float middlePhase = (phase - 0.45f) * 10.0f;
            if (middlePhase < 0.5f) {
                return this.interpolateColor(this.getRandomEerieColor(0.45f, random, charIndex), 0xFFFFFF, middlePhase * 2.0f);
            }
            return this.interpolateColor(0xFFFFFF, this.getRandomEerieColor(0.55f, random, charIndex), (middlePhase - 0.5f) * 2.0f);
        }
        int colorIndex = (charIndex + random.nextInt(100)) % EERIE_COLORS.length;
        int nextColorIndex = (colorIndex + 1 + random.nextInt(EERIE_COLORS.length - 1)) % EERIE_COLORS.length;
        float erraticPhase = (float)Math.pow(phase * 2.0f % 1.0f, 1.5);
        return this.interpolateColor(EERIE_COLORS[colorIndex], EERIE_COLORS[nextColorIndex], erraticPhase);
    }

    private int interpolateColor(int startColor, int endColor, float ratio) {
        ratio = Mth.m_14036_((float)ratio, (float)0.0f, (float)1.0f);
        int startR = startColor >> 16 & 0xFF;
        int startG = startColor >> 8 & 0xFF;
        int startB = startColor & 0xFF;
        int endR = endColor >> 16 & 0xFF;
        int endG = endColor >> 8 & 0xFF;
        int endB = endColor & 0xFF;
        float currentR = (float)startR + ratio * (float)(endR - startR);
        float currentG = (float)startG + ratio * (float)(endG - startG);
        float currentB = (float)startB + ratio * (float)(endB - startB);
        int r = Mth.m_14045_((int)((int)currentR), (int)0, (int)255);
        int g = Mth.m_14045_((int)((int)currentG), (int)0, (int)255);
        int b = Mth.m_14045_((int)((int)currentB), (int)0, (int)255);
        return r << 16 | g << 8 | b;
    }

    public void m_7373_(ItemStack itemstack, Level level, List<Component> list, TooltipFlag flag) {
        super.m_7373_(itemstack, level, list, flag);
        list.add((Component)Component.m_237113_((String)"Passive Effect:"));
        list.add((Component)Component.m_237113_((String)"-Grants Two Additional Ring Slots"));
        list.add((Component)Component.m_237113_((String)"-Grants Two Additional Charm Slots"));
    }

    public void onEquip(SlotContext slotContext, ItemStack prevStack, ItemStack stack) {
        if ("crest_slot".equals(slotContext.identifier())) {
            WitcherCrestEqProcedure.execute((Entity)slotContext.entity());
        }
    }

    public void onUnequip(SlotContext slotContext, ItemStack newStack, ItemStack stack) {
        if ("crest_slot".equals(slotContext.identifier())) {
            WitcherCrestUneqProcedure.execute((Entity)slotContext.entity());
        }
    }

    public boolean canEquip(SlotContext slotContext, ItemStack stack) {
        return "crest_slot".equals(slotContext.identifier());
    }
}

