/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.mortality.procedures;

import net.mcreator.mortality.entity.MalachiteProjectileEntity;
import net.mcreator.mortality.init.MortalityModEntities;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.registries.ForgeRegistries;

public class MalachiteRightclickProcedure {
    private static final int BASE_COOLDOWN = 20;

    public static void execute(LevelAccessor world, double x, double y, double z, Entity entity, ItemStack itemstack, InteractionHand hand) {
        ItemStack offhandItem;
        ItemStack _ist;
        if (entity == null || !(entity instanceof LivingEntity)) {
            return;
        }
        LivingEntity livingEntity = (LivingEntity)entity;
        if (world instanceof Level) {
            Level _level = (Level)world;
            if (!_level.m_5776_()) {
                _level.m_5594_(null, BlockPos.m_274561_((double)x, (double)y, (double)z), (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("entity.snowball.throw")), SoundSource.PLAYERS, 1.0f, 0.8f);
            } else {
                _level.m_7785_(x, y, z, (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("entity.snowball.throw")), SoundSource.PLAYERS, 1.0f, 0.8f, false);
            }
        }
        if ((_ist = itemstack).m_220157_(3, RandomSource.m_216327_(), null)) {
            _ist.m_41774_(1);
            _ist.m_41721_(0);
        }
        float attackSpeed = MalachiteRightclickProcedure.getAttackSpeed(livingEntity);
        int scaledCooldown = MalachiteRightclickProcedure.calculateScaledCooldown(attackSpeed);
        if (entity instanceof Player) {
            Player _player = (Player)entity;
            _player.m_36335_().m_41524_(itemstack.m_41720_(), scaledCooldown);
        }
        int sharpnessLevel = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44977_, (ItemStack)itemstack);
        int sweepingLevel = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44983_, (ItemStack)itemstack);
        float baseDamage = 6.0f;
        float sharpnessBonus = (float)sharpnessLevel * 0.5f;
        float totalDamage = baseDamage + sharpnessBonus;
        MalachiteRightclickProcedure.shootEnchantedProjectiles(world, livingEntity, 2.6f, totalDamage, sweepingLevel);
        livingEntity.m_21011_(hand, true);
        if (hand == InteractionHand.MAIN_HAND && (offhandItem = livingEntity.m_21206_()).m_41720_() == itemstack.m_41720_()) {
            MalachiteRightclickProcedure.scheduleOffhandActivation(world, livingEntity, offhandItem, 5);
        }
    }

    public static void execute(LevelAccessor world, double x, double y, double z, Entity entity, ItemStack itemstack) {
        MalachiteRightclickProcedure.execute(world, x, y, z, entity, itemstack, InteractionHand.MAIN_HAND);
    }

    private static float getAttackSpeed(LivingEntity entity) {
        float baseSpeed = 4.0f;
        if (entity.m_21023_(MobEffects.f_19598_)) {
            int amplifier = entity.m_21124_(MobEffects.f_19598_).m_19564_();
            baseSpeed += (float)(amplifier + 1) * 0.2f;
        }
        if (entity.m_21051_(Attributes.f_22283_) != null) {
            double attackSpeedAttribute = entity.m_21133_(Attributes.f_22283_);
            baseSpeed = (float)attackSpeedAttribute;
        }
        return baseSpeed;
    }

    private static int calculateScaledCooldown(float attackSpeed) {
        int minCooldown = 5;
        float scaleFactor = Math.max(0.1f, attackSpeed / 4.0f);
        int calculatedCooldown = (int)(20.0f / scaleFactor);
        return Math.max(minCooldown, Math.min(calculatedCooldown, 20));
    }

    private static void shootEnchantedProjectiles(LevelAccessor world, LivingEntity shooter, float velocity, float damage, int sweepingLevel) {
        if (world.m_5776_()) {
            return;
        }
        int volleyCount = 1 + sweepingLevel;
        for (int volley = 0; volley < volleyCount; ++volley) {
            float spreadMultiplier = 1.0f + (float)volley * 0.5f;
            if (volley > 0) {
                int delayTicks = volley * 2;
                MalachiteRightclickProcedure.scheduleVolley(world, shooter, velocity, damage, spreadMultiplier, delayTicks);
                continue;
            }
            MalachiteRightclickProcedure.shootProjectileVolley(world, shooter, velocity, damage, spreadMultiplier);
        }
    }

    private static void shootProjectileVolley(LevelAccessor world, LivingEntity shooter, float velocity, float damage, float spreadMultiplier) {
        float[] spreadAngles;
        Vec3 lookVec = shooter.m_20154_();
        float baseSpread = 25.0f;
        for (float angle : spreadAngles = new float[]{0.0f, baseSpread * spreadMultiplier, -baseSpread * spreadMultiplier}) {
            Projectile projectile = MalachiteRightclickProcedure.createProjectile((Level)world, (Entity)shooter, damage);
            if (projectile == null) continue;
            projectile.m_6034_(shooter.m_20185_(), shooter.m_20188_() - 0.1, shooter.m_20189_());
            Vec3 spreadVec = MalachiteRightclickProcedure.applyYawRotation(lookVec, angle);
            RandomSource random = RandomSource.m_216327_();
            float randomSpread = (spreadMultiplier - 1.0f) * 5.0f;
            float randomX = (random.m_188501_() - 0.5f) * randomSpread * 0.1f;
            float randomY = (random.m_188501_() - 0.5f) * randomSpread * 0.1f;
            float randomZ = (random.m_188501_() - 0.5f) * randomSpread * 0.1f;
            Vec3 finalVec = spreadVec.m_82520_((double)randomX, (double)randomY, (double)randomZ).m_82541_();
            projectile.m_6686_(finalVec.f_82479_, finalVec.f_82480_, finalVec.f_82481_, velocity, 0.0f);
            ((Level)world).m_7967_((Entity)projectile);
        }
    }

    private static void scheduleVolley(LevelAccessor world, LivingEntity shooter, float velocity, float damage, float spreadMultiplier, int delayTicks) {
        Level level;
        if (!(world instanceof Level) || (level = (Level)world).m_5776_()) {
            return;
        }
        new Thread(() -> {
            try {
                Thread.sleep(delayTicks * 50);
                level.m_7654_().execute(() -> {
                    if (shooter.m_6084_()) {
                        MalachiteRightclickProcedure.shootProjectileVolley((LevelAccessor)level, shooter, velocity, damage, spreadMultiplier);
                    }
                });
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }).start();
    }

    private static Vec3 applyYawRotation(Vec3 direction, float yawDegrees) {
        double yawRadians = Math.toRadians(yawDegrees);
        double cosYaw = Math.cos(yawRadians);
        double sinYaw = Math.sin(yawRadians);
        double newX = direction.f_82479_ * cosYaw - direction.f_82481_ * sinYaw;
        double newZ = direction.f_82479_ * sinYaw + direction.f_82481_ * cosYaw;
        return new Vec3(newX, direction.f_82480_, newZ);
    }

    private static Projectile createProjectile(Level level, Entity shooter, float damage) {
        try {
            MalachiteProjectileEntity entityToSpawn = new MalachiteProjectileEntity((EntityType<? extends MalachiteProjectileEntity>)((EntityType)MortalityModEntities.MALACHITE_PROJECTILE.get()), level);
            entityToSpawn.m_5602_(shooter);
            entityToSpawn.m_36781_(damage);
            entityToSpawn.m_36735_(0);
            entityToSpawn.m_20225_(true);
            entityToSpawn.m_36767_((byte)2);
            return entityToSpawn;
        }
        catch (Exception e) {
            return null;
        }
    }

    private static void scheduleOffhandActivation(LevelAccessor world, LivingEntity entity, ItemStack offhandItem, int delayTicks) {
        Level level;
        if (!(world instanceof Level) || (level = (Level)world).m_5776_()) {
            return;
        }
        new Thread(() -> {
            try {
                Thread.sleep(delayTicks * 50);
                level.m_7654_().execute(() -> MalachiteRightclickProcedure.activateOffhand(level, entity, offhandItem));
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }).start();
    }

    private static void activateOffhand(Level world, LivingEntity entity, ItemStack offhandItem) {
        if (world.m_5776_()) {
            return;
        }
        int sharpnessLevel = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44977_, (ItemStack)offhandItem);
        int sweepingLevel = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44983_, (ItemStack)offhandItem);
        float baseDamage = 6.0f;
        float sharpnessBonus = (float)sharpnessLevel * 0.5f;
        float totalDamage = baseDamage + sharpnessBonus;
        Vec3 pos = entity.m_20182_();
        if (!world.m_5776_()) {
            world.m_5594_(null, BlockPos.m_274561_((double)pos.f_82479_, (double)pos.f_82480_, (double)pos.f_82481_), (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("entity.snowball.throw")), SoundSource.PLAYERS, 1.0f, 0.7f);
        }
        MalachiteRightclickProcedure.shootEnchantedProjectiles((LevelAccessor)world, entity, 2.6f, totalDamage, sweepingLevel);
        ItemStack _ist = offhandItem;
        if (_ist.m_220157_(3, RandomSource.m_216327_(), null)) {
            _ist.m_41774_(1);
            _ist.m_41721_(0);
        }
        entity.m_21011_(InteractionHand.OFF_HAND, true);
    }
}

