/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.mortality.procedures;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.mcreator.mortality.MortalityMod;
import net.mcreator.mortality.entity.VenoshopodEntity;
import net.mcreator.mortality.init.MortalityModMobEffects;
import net.mcreator.mortality.init.MortalityModParticleTypes;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.core.registries.Registries;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class VenoshopodAttackAndSpecialsProcedure {
    private static final int ATTACK_COUNT = 2;
    private static final int[] ATTACK_DELAYS = new int[]{5, 10};
    private static final float DAMAGE = 8.0f;
    private static final double ATTACK_RADIUS_XZ = 4.5;
    private static final double ATTACK_RADIUS_Y = 1.5;
    private static final double ATTACK_HEIGHT_OFFSET = 1.0;
    private static final double PARTICLE_HEIGHT_OFFSET = 2.0;
    private static final int PLAGUE_DURATION = 80;
    private static final int ARMOR_CRUNCH_DURATION = 100;
    private static final int HURT_RESPONSE_COOLDOWN = 320;
    private static final int HURT_RESPONSE_EFFECT_AMPLIFIER = 1;
    private static final int MAX_HARVEST_LEVEL = 2;
    private static final float BLOCK_DROP_CHANCE = 0.05f;
    private static final Random RANDOM = new Random();
    private static final Predicate<Entity> VALID_TARGET_PREDICATE = entity -> !(entity instanceof VenoshopodEntity) && entity instanceof LivingEntity;

    @SubscribeEvent
    public static void onEntityHurt(LivingHurtEvent event) {
        if (event != null && event.getEntity() != null) {
            VenoshopodAttackAndSpecialsProcedure.execute((Event)event, (LevelAccessor)event.getEntity().m_9236_(), (Entity)event.getEntity(), event.getSource().m_7639_());
        }
    }

    public static void execute() {
    }

    public static void execute(LevelAccessor world, Entity entity, Entity sourceentity) {
        VenoshopodAttackAndSpecialsProcedure.execute(null, world, entity, sourceentity);
    }

    private static void execute(@Nullable Event event, LevelAccessor world, Entity entity, Entity sourceentity) {
        if (entity == null) {
            return;
        }
        if (entity instanceof VenoshopodEntity && entity instanceof LivingEntity) {
            MobEffectInstance effect;
            LivingEntity livingVenoshopod = (LivingEntity)entity;
            boolean hasHurtCooldown = false;
            if (livingVenoshopod.m_21023_((MobEffect)MortalityModMobEffects.MORTALITY_ATTACKING.get()) && (effect = livingVenoshopod.m_21124_((MobEffect)MortalityModMobEffects.MORTALITY_ATTACKING.get())) != null && effect.m_19564_() == 1) {
                hasHurtCooldown = true;
            }
            if (!hasHurtCooldown) {
                VenoshopodAttackAndSpecialsProcedure.initiateHurtResponse(event, world, livingVenoshopod, sourceentity);
            }
        }
    }

    private static void initiateHurtResponse(@Nullable Event event, LevelAccessor world, LivingEntity venoshopod, Entity damager) {
        if (!venoshopod.m_9236_().m_5776_()) {
            venoshopod.m_7292_(new MobEffectInstance((MobEffect)MortalityModMobEffects.MORTALITY_ATTACKING.get(), 320, 1, false, false, true));
        }
        if (venoshopod instanceof VenoshopodEntity) {
            VenoshopodEntity venoshopodEntity = (VenoshopodEntity)venoshopod;
            venoshopodEntity.setAnimation("animation.venoshopod.ravage");
        }
        for (int i = 0; i < 2; ++i) {
            int attackIndex = i;
            MortalityMod.queueServerWork(ATTACK_DELAYS[i], () -> VenoshopodAttackAndSpecialsProcedure.performAreaAttackOnHurt(world, venoshopod, attackIndex));
        }
    }

    private static void performAreaAttackOnHurt(LevelAccessor world, LivingEntity venoshopod, int attackIndex) {
        Vec3 center = new Vec3(venoshopod.m_20185_(), venoshopod.m_20186_() + 1.0, venoshopod.m_20189_());
        AABB attackArea = new AABB(center.f_82479_ - 4.5, center.f_82480_ - 1.5, center.f_82481_ - 4.5, center.f_82479_ + 4.5, center.f_82480_ + 1.5, center.f_82481_ + 4.5);
        List entitiesInRange = world.m_6443_(Entity.class, attackArea, VALID_TARGET_PREDICATE);
        for (Entity target : entitiesInRange) {
            VenoshopodAttackAndSpecialsProcedure.applyAttackEffects(world, (Entity)venoshopod, target);
        }
        VenoshopodAttackAndSpecialsProcedure.destroyBlocksInArea(world, venoshopod);
        VenoshopodAttackAndSpecialsProcedure.spawnAttackParticles(world, (Entity)venoshopod);
    }

    private static void destroyBlocksInArea(LevelAccessor world, LivingEntity venoshopod) {
        if (!(world instanceof Level)) {
            return;
        }
        Level level = (Level)world;
        Vec3 center = new Vec3(venoshopod.m_20185_(), venoshopod.m_20186_(), venoshopod.m_20189_());
        int radiusXZ = (int)Math.ceil(4.5);
        int minY = (int)Math.floor(center.f_82480_) - 1;
        int maxY = (int)Math.floor(center.f_82480_) + 2;
        ArrayList<BlockPos> candidateBlocks = new ArrayList<BlockPos>();
        for (int x = -radiusXZ; x <= radiusXZ; ++x) {
            for (int y = minY; y <= maxY; ++y) {
                for (int z = -radiusXZ; z <= radiusXZ; ++z) {
                    double verticalDistance;
                    BlockPos pos = new BlockPos((int)center.f_82479_ + x, y, (int)center.f_82481_ + z);
                    double horizontalDistance = Math.sqrt(x * x + z * z);
                    if (!(horizontalDistance * horizontalDistance / 20.25 + (verticalDistance = Math.abs((double)y - center.f_82480_)) * verticalDistance / 2.25 <= 1.0)) continue;
                    candidateBlocks.add(pos);
                }
            }
        }
        for (BlockPos pos : candidateBlocks) {
            if (!VenoshopodAttackAndSpecialsProcedure.isBlockConnectedToAir(level, pos)) continue;
            VenoshopodAttackAndSpecialsProcedure.attemptBreakBlock(level, pos, venoshopod);
        }
    }

    private static boolean isBlockConnectedToAir(Level level, BlockPos pos) {
        BlockState blockState = level.m_8055_(pos);
        if (blockState.m_60795_() || blockState.m_60800_((BlockGetter)level, pos) < 0.0f) {
            return false;
        }
        for (Direction direction : Direction.values()) {
            BlockPos adjacentPos = pos.m_121945_(direction);
            BlockState adjacentState = level.m_8055_(adjacentPos);
            if (!adjacentState.m_60795_()) continue;
            return true;
        }
        return false;
    }

    private static void attemptBreakBlock(Level level, BlockPos pos, LivingEntity venoshopod) {
        BlockState blockState = level.m_8055_(pos);
        if (blockState.m_60795_() || blockState.m_60800_((BlockGetter)level, pos) < 0.0f) {
            return;
        }
        if (VenoshopodAttackAndSpecialsProcedure.getBlockHarvestLevel(blockState) <= 2) {
            boolean shouldDropBlock;
            boolean bl = shouldDropBlock = RANDOM.nextFloat() <= 0.05f;
            if (shouldDropBlock) {
                Block.m_49950_((BlockState)blockState, (Level)level, (BlockPos)pos);
            }
            level.m_46961_(pos, false);
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                serverLevel.m_8767_((ParticleOptions)((SimpleParticleType)MortalityModParticleTypes.CLAW_STRIKE_PARTICLE.get()), (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, 3, 0.3, 0.3, 0.3, 0.1);
            }
        }
    }

    private static int getBlockHarvestLevel(BlockState blockState) {
        Block block = blockState.m_60734_();
        if (blockState.m_60834_()) {
            float hardness = blockState.m_60800_(null, null);
            if (hardness >= 50.0f) {
                return 4;
            }
            if (hardness >= 30.0f) {
                return 3;
            }
            if (hardness >= 15.0f) {
                return 2;
            }
            if (hardness >= 5.0f) {
                return 1;
            }
            return 0;
        }
        return 0;
    }

    private static void applyAttackEffects(LevelAccessor world, Entity venoshopod, Entity target) {
        if (!(target instanceof LivingEntity)) {
            return;
        }
        LivingEntity livingTarget = (LivingEntity)target;
        DamageSource damageSource = new DamageSource((Holder)world.m_9598_().m_175515_(Registries.f_268580_).m_246971_(DamageTypes.f_268433_), venoshopod);
        livingTarget.m_6469_(damageSource, 8.0f);
        if (!livingTarget.m_9236_().m_5776_()) {
            livingTarget.m_7292_(new MobEffectInstance((MobEffect)MortalityModMobEffects.PLAGUE.get(), 80, 1));
            livingTarget.m_7292_(new MobEffectInstance((MobEffect)MortalityModMobEffects.ARMOR_CRUNCH.get(), 100, 0));
        }
    }

    private static void spawnAttackParticles(LevelAccessor world, Entity venoshopod) {
        if (world instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)world;
            serverLevel.m_8767_((ParticleOptions)((SimpleParticleType)MortalityModParticleTypes.CLAW_STRIKE_PARTICLE.get()), venoshopod.m_20185_(), venoshopod.m_20186_() + 2.0, venoshopod.m_20189_(), 5, 5.0, 3.0, 5.0, 0.0);
        }
    }
}

