/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.yajatkaul.mega_showdown;

import com.cobblemon.yajatkaul.mega_showdown.block.entity.ModBlockEntities;
import com.cobblemon.yajatkaul.mega_showdown.block.entity.renderer.PedestalBlockEntityRenderer;
import com.cobblemon.yajatkaul.mega_showdown.item.render.LikosPendantLayer;
import com.cobblemon.yajatkaul.mega_showdown.megaevo.Controls;
import com.cobblemon.yajatkaul.mega_showdown.networking.packets.MegaEvo;
import com.cobblemon.yajatkaul.mega_showdown.networking.packets.UltraTrans;
import com.cobblemon.yajatkaul.mega_showdown.screen.ModMenuTypes;
import com.cobblemon.yajatkaul.mega_showdown.screen.custom.ZygardeCubeScreen;
import com.cobblemon.yajatkaul.mega_showdown.utility.PackRegister;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.resources.PlayerSkin;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.inventory.MenuType;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import net.neoforged.neoforge.client.event.EntityRenderersEvent;
import net.neoforged.neoforge.client.event.RegisterKeyMappingsEvent;
import net.neoforged.neoforge.client.event.RegisterMenuScreensEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.AddPackFindersEvent;
import net.neoforged.neoforge.network.PacketDistributor;

@EventBusSubscriber(modid="mega_showdown", bus=EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
public class MegaShowdownClient {
    @SubscribeEvent
    public static void onClientSetup(FMLClientSetupEvent event) {
        NeoForge.EVENT_BUS.addListener(MegaShowdownClient::onClientTick);
    }

    @SubscribeEvent
    public static void onAddPackFinders(AddPackFindersEvent event) {
        PackRegister.register(event);
    }

    @SubscribeEvent
    public static void registerBindings(RegisterKeyMappingsEvent event) {
        event.register((KeyMapping)Controls.MEGA_ITEM_KEY.get());
        event.register((KeyMapping)Controls.ULTRA_KEY.get());
    }

    public static void onClientTick(ClientTickEvent.Post event) {
        while (((KeyMapping)Controls.MEGA_ITEM_KEY.get()).consumeClick()) {
            PacketDistributor.sendToServer((CustomPacketPayload)new MegaEvo("mega_evo"), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
        while (((KeyMapping)Controls.ULTRA_KEY.get()).consumeClick()) {
            PacketDistributor.sendToServer((CustomPacketPayload)new UltraTrans("ultra_trans"), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    @SubscribeEvent
    public static void registerBER(EntityRenderersEvent.RegisterRenderers event) {
        event.registerBlockEntityRenderer(ModBlockEntities.PEDESTAL_BE.get(), PedestalBlockEntityRenderer::new);
    }

    @SubscribeEvent
    public static void registerScreens(RegisterMenuScreensEvent event) {
        event.register((MenuType)ModMenuTypes.ZYGARDE_CUBE_MENU.get(), ZygardeCubeScreen::new);
    }

    @SubscribeEvent
    public static void registerLayer(EntityRenderersEvent.AddLayers event) {
        LivingEntityRenderer armorStandRenderer;
        LivingEntityRenderer skeletonRenderer;
        for (PlayerSkin.Model skin : PlayerSkin.Model.values()) {
            LivingEntityRenderer renderer = (LivingEntityRenderer)event.getSkin(skin);
            if (renderer == null) continue;
            renderer.addLayer(new LikosPendantLayer(renderer));
        }
        LivingEntityRenderer zombieRenderer = (LivingEntityRenderer)event.getRenderer(EntityType.ZOMBIE);
        if (zombieRenderer != null) {
            zombieRenderer.addLayer(new LikosPendantLayer(zombieRenderer));
        }
        if ((skeletonRenderer = (LivingEntityRenderer)event.getRenderer(EntityType.SKELETON)) != null) {
            skeletonRenderer.addLayer(new LikosPendantLayer(skeletonRenderer));
        }
        if ((armorStandRenderer = (LivingEntityRenderer)event.getRenderer(EntityType.ARMOR_STAND)) != null) {
            armorStandRenderer.addLayer(new LikosPendantLayer(armorStandRenderer));
        }
    }
}

