/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.yajatkaul.mega_showdown.megaevo;

import com.cobblemon.mod.common.api.battles.model.PokemonBattle;
import com.cobblemon.mod.common.api.moves.Move;
import com.cobblemon.mod.common.api.pokemon.feature.StringSpeciesFeature;
import com.cobblemon.mod.common.battles.pokemon.BattlePokemon;
import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.cobblemon.yajatkaul.mega_showdown.advancement.AdvancementHelper;
import com.cobblemon.yajatkaul.mega_showdown.config.MegaShowdownConfig;
import com.cobblemon.yajatkaul.mega_showdown.datamanage.DataManage;
import com.cobblemon.yajatkaul.mega_showdown.datamanage.PokeHandler;
import com.cobblemon.yajatkaul.mega_showdown.datapack.data.MegaData;
import com.cobblemon.yajatkaul.mega_showdown.event.cobbleEvents.CobbleEventsHandler;
import com.cobblemon.yajatkaul.mega_showdown.item.MegaStones;
import com.cobblemon.yajatkaul.mega_showdown.sound.ModSounds;
import com.cobblemon.yajatkaul.mega_showdown.utility.LazyLib;
import com.cobblemon.yajatkaul.mega_showdown.utility.ModTags;
import com.cobblemon.yajatkaul.mega_showdown.utility.Utils;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import kotlin.Unit;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.component.CustomModelData;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import top.theillusivec4.curios.api.CuriosApi;

public class MegaLogic {
    private static final Map<UUID, Long> cooldowns = new HashMap<UUID, Long>();
    private static final long COOLDOWN_TIME = 6000L;

    public static boolean Possible(ServerPlayer player, boolean fromBattle) {
        UUID playerId = player.getUUID();
        long currentTime = System.currentTimeMillis();
        if (cooldowns.containsKey(playerId) && currentTime < cooldowns.get(playerId) && !fromBattle) {
            player.displayClientMessage((Component)Component.translatable((String)"message.mega_showdown.not_so_fast").withColor(0xFF0000), true);
            return false;
        }
        boolean hasMegaItemCurios = CuriosApi.getCuriosInventory((LivingEntity)player).map(inventory -> inventory.isEquipped(stack -> stack.is(ModTags.Items.MEGA_BRACELETS))).orElse(false);
        boolean hasOffhandMegaItem = player.getOffhandItem().is(ModTags.Items.MEGA_BRACELETS);
        boolean hasMainhandMegaItem = player.getMainHandItem().is(ModTags.Items.MEGA_BRACELETS);
        if (fromBattle ? !hasMegaItemCurios && !hasOffhandMegaItem : !hasMegaItemCurios && !hasOffhandMegaItem && !hasMainhandMegaItem) {
            return false;
        }
        cooldowns.put(playerId, currentTime + 6000L);
        return true;
    }

    public static void EvoLogic(Player playerContext) {
        ServerPlayer player = (ServerPlayer)playerContext;
        if (MegaShowdownConfig.battleModeOnly) {
            return;
        }
        double range = 5.0;
        Vec3 startPos = player.getEyePosition();
        Vec3 lookVec = player.getViewVector(1.0f);
        Vec3 endPos = startPos.add(lookVec.multiply(range, range, range));
        AABB searchBox = new AABB(startPos, endPos).inflate(1.0);
        EntityHitResult entityHit = ProjectileUtil.getEntityHitResult((Level)player.level(), (Entity)player, (Vec3)startPos, (Vec3)endPos, (AABB)searchBox, entity -> !entity.isSpectator() && entity.isPickable(), (float)0.3f);
        if (entityHit == null) {
            return;
        }
        Entity entity2 = entityHit.getEntity();
        if (entity2 instanceof PokemonEntity) {
            PokemonEntity pk = (PokemonEntity)entity2;
            if (pk.level().isClientSide) {
                return;
            }
            if (!MegaShowdownConfig.mega || pk.getPokemon().getOwnerPlayer() != player || !Utils.MEGA_POKEMONS.contains(pk.getPokemon().getSpecies().getName()) && !pk.getPokemon().getSpecies().getName().equals("Rayquaza") || !MegaLogic.Possible(player, false)) {
                return;
            }
            boolean isMega = pk.getAspects().stream().anyMatch(aspect -> aspect.startsWith("mega"));
            if (isMega) {
                MegaLogic.Devolve(pk.getPokemon(), false);
            } else {
                MegaLogic.Evolve(pk, playerContext);
            }
        }
    }

    public static void Evolve(PokemonEntity context, Player player) {
        if (player.level().isClientSide) {
            return;
        }
        Pokemon pokemon = context.getPokemon();
        String species = Utils.MEGA_STONE_IDS.get(pokemon.heldItem().getItem());
        if (((Boolean)player.getData(DataManage.MEGA_DATA)).booleanValue() && !MegaShowdownConfig.multipleMegas) {
            player.displayClientMessage((Component)Component.translatable((String)"message.mega_showdown.mega_limit").withColor(0xFF0000), true);
            return;
        }
        if (pokemon.getEntity().isBattling()) {
            player.displayClientMessage((Component)Component.translatable((String)"message.mega_showdown.battle_not_allowed").withColor(0xFF0000), true);
            return;
        }
        if (pokemon.getSpecies().getName().equals("Rayquaza")) {
            if (MegaShowdownConfig.friendshipMode && pokemon.getFriendship() < 200 && !pokemon.getEntity().isBattling()) {
                player.displayClientMessage((Component)Component.translatable((String)"message.mega_showdown.bond_not_close_mega").withColor(0xFF0000), true);
                return;
            }
            boolean found = false;
            for (int i = 0; i < 4; ++i) {
                if (!((Move)pokemon.getMoveSet().getMoves().get(i)).getName().equals("dragonascent")) continue;
                player.setData(DataManage.MEGA_POKEMON, (Object)new PokeHandler(pokemon));
                player.setData(DataManage.MEGA_DATA, (Object)true);
                MegaLogic.megaEvolve(context, "mega");
                Utils.setTradable(pokemon, false);
                found = true;
            }
            if (!found) {
                player.displayClientMessage((Component)Component.translatable((String)"message.mega_showdown.rayquaza_no_dragonascent").withColor(0xFF0000), true);
            }
            return;
        }
        if (species == null) {
            for (MegaData megaPok : Utils.megaRegistry) {
                String[] parts = megaPok.item_id().split(":");
                ResourceLocation paperId = ResourceLocation.fromNamespaceAndPath((String)parts[0], (String)parts[1]);
                Item paperItem = (Item)BuiltInRegistries.ITEM.get(paperId);
                if (paperItem == pokemon.heldItem().getItem() && (pokemon.heldItem().get(DataComponents.CUSTOM_MODEL_DATA) != null && ((CustomModelData)pokemon.heldItem().get(DataComponents.CUSTOM_MODEL_DATA)).value() == megaPok.custom_model_data().intValue() || megaPok.custom_model_data() == 0)) {
                    species = megaPok.pokemon();
                }
                if (species == null) continue;
                if (species.equals(pokemon.getSpecies().getName())) {
                    player.setData(DataManage.MEGA_DATA, (Object)true);
                    player.setData(DataManage.MEGA_POKEMON, (Object)new PokeHandler(pokemon));
                    for (String aspect : megaPok.aspects()) {
                        String[] aspectDiv = aspect.split("=");
                        if (aspectDiv[1].equals("true") || aspectDiv[1].equals("false")) {
                            MegaLogic.megaEvolve(context, aspectDiv[0]);
                            continue;
                        }
                        MegaLogic.megaEvolve(context, aspectDiv[1]);
                    }
                    Utils.setTradable(pokemon, false);
                    return;
                }
                player.displayClientMessage((Component)Component.translatable((String)"message.mega_showdown.incorrect_mega_stone").withColor(0xFF0000), true);
                return;
            }
            return;
        }
        if (MegaShowdownConfig.friendshipMode && pokemon.getFriendship() < 200 && !pokemon.getEntity().isBattling()) {
            player.displayClientMessage((Component)Component.translatable((String)"message.mega_showdown.bond_not_close_mega").withColor(0xFF0000), true);
            return;
        }
        if (species.equals(pokemon.getSpecies().getName())) {
            if (species.equals("Charizard")) {
                if (pokemon.heldItem().is(MegaStones.CHARIZARDITE_X)) {
                    player.setData(DataManage.MEGA_DATA, (Object)true);
                    player.setData(DataManage.MEGA_POKEMON, (Object)new PokeHandler(pokemon));
                    MegaLogic.megaEvolve(context, "mega_x");
                    Utils.setTradable(pokemon, false);
                } else if (pokemon.heldItem().is(MegaStones.CHARIZARDITE_Y)) {
                    player.setData(DataManage.MEGA_DATA, (Object)true);
                    player.setData(DataManage.MEGA_POKEMON, (Object)new PokeHandler(pokemon));
                    MegaLogic.megaEvolve(context, "mega_y");
                    Utils.setTradable(pokemon, false);
                }
            } else if (species.equals("Mewtwo")) {
                if (pokemon.heldItem().is(MegaStones.MEWTWONITE_X)) {
                    player.setData(DataManage.MEGA_DATA, (Object)true);
                    player.setData(DataManage.MEGA_POKEMON, (Object)new PokeHandler(pokemon));
                    MegaLogic.megaEvolve(context, "mega_x");
                    Utils.setTradable(pokemon, false);
                } else if (pokemon.heldItem().is(MegaStones.MEWTWONITE_Y)) {
                    player.setData(DataManage.MEGA_DATA, (Object)true);
                    player.setData(DataManage.MEGA_POKEMON, (Object)new PokeHandler(pokemon));
                    MegaLogic.megaEvolve(context, "mega_y");
                    Utils.setTradable(pokemon, false);
                }
            } else {
                player.setData(DataManage.MEGA_DATA, (Object)true);
                player.setData(DataManage.MEGA_POKEMON, (Object)new PokeHandler(pokemon));
                Utils.setTradable(pokemon, false);
                MegaLogic.megaEvolve(context, "mega");
            }
        } else {
            player.displayClientMessage((Component)Component.translatable((String)"message.mega_showdown.incorrect_mega_stone").withColor(0xFF0000), true);
        }
    }

    public static void Devolve(Pokemon context, boolean fromBattle) {
        ServerPlayer player = context.getOwnerPlayer();
        if (context.getOwnerPlayer() != player) {
            return;
        }
        if (context.getEntity() != null && context.getEntity().isBattling() && !fromBattle) {
            player.displayClientMessage((Component)Component.translatable((String)"message.mega_showdown.battle_not_allowed").withColor(0xFF0000), true);
            return;
        }
        player.setData(DataManage.MEGA_DATA, (Object)false);
        player.removeData(DataManage.MEGA_POKEMON);
        if (context.getEntity() != null) {
            MegaLogic.playDevolveAnimation((LivingEntity)context.getEntity());
        }
        new StringSpeciesFeature("mega_evolution", "none").apply(context);
        Utils.setTradable(context, true);
    }

    public static void megaEvolve(PokemonEntity context, String type) {
        AdvancementHelper.grantAdvancement(context.getPokemon().getOwnerPlayer(), "mega/mega_evolve");
        context.getEntityData().set(PokemonEntity.getEVOLUTION_STARTED(), (Object)true);
        LazyLib.Companion.snowStormPartileSpawner((Entity)context, "mega_evolution", "target");
        BlockPos entityPos = context.getOnPos();
        context.level().playSound(null, (double)entityPos.getX(), (double)entityPos.getY(), (double)entityPos.getZ(), ModSounds.MEGA.get(), SoundSource.PLAYERS, 0.2f, 0.8f);
        context.after(4.7f, () -> {
            LazyLib.Companion.cryAnimation((Entity)context);
            context.getEntityData().set(PokemonEntity.getEVOLUTION_STARTED(), (Object)false);
            new StringSpeciesFeature("mega_evolution", type).apply(context.getPokemon());
            return Unit.INSTANCE;
        });
    }

    public static void Evolve(PokemonEntity context, Player player, BattlePokemon battlePokemon, PokemonBattle pokemonBattle) {
        if (player.level().isClientSide) {
            return;
        }
        Pokemon pokemon = context.getPokemon();
        String species = Utils.MEGA_STONE_IDS.get(pokemon.heldItem().getItem());
        if (((Boolean)player.getData(DataManage.MEGA_DATA)).booleanValue() && !MegaShowdownConfig.multipleMegas) {
            player.displayClientMessage((Component)Component.translatable((String)"message.mega_showdown.mega_limit").withColor(0xFF0000), true);
            return;
        }
        if (pokemon.getSpecies().getName().equals("Rayquaza")) {
            if (MegaShowdownConfig.friendshipMode && pokemon.getFriendship() < 200 && !pokemon.getEntity().isBattling()) {
                player.displayClientMessage((Component)Component.translatable((String)"message.mega_showdown.bond_not_close_mega").withColor(0xFF0000), true);
                return;
            }
            boolean found = false;
            for (int i = 0; i < 4; ++i) {
                if (!((Move)pokemon.getMoveSet().getMoves().get(i)).getName().equals("dragonascent")) continue;
                player.setData(DataManage.MEGA_POKEMON, (Object)new PokeHandler(pokemon));
                player.setData(DataManage.MEGA_DATA, (Object)true);
                MegaLogic.megaEvolve(context, "mega", battlePokemon, pokemonBattle);
                Utils.setTradable(pokemon, false);
                found = true;
            }
            if (!found) {
                player.displayClientMessage((Component)Component.translatable((String)"message.mega_showdown.rayquaza_no_dragonascent").withColor(0xFF0000), true);
            }
            return;
        }
        if (species == null) {
            for (MegaData megaPok : Utils.megaRegistry) {
                String[] parts = megaPok.item_id().split(":");
                ResourceLocation paperId = ResourceLocation.fromNamespaceAndPath((String)parts[0], (String)parts[1]);
                Item paperItem = (Item)BuiltInRegistries.ITEM.get(paperId);
                if (paperItem == pokemon.heldItem().getItem() && (pokemon.heldItem().get(DataComponents.CUSTOM_MODEL_DATA) != null && ((CustomModelData)pokemon.heldItem().get(DataComponents.CUSTOM_MODEL_DATA)).value() == megaPok.custom_model_data().intValue() || megaPok.custom_model_data() == 0)) {
                    species = megaPok.pokemon();
                }
                if (species == null) continue;
                if (species.equals(pokemon.getSpecies().getName())) {
                    player.setData(DataManage.MEGA_DATA, (Object)true);
                    player.setData(DataManage.MEGA_POKEMON, (Object)new PokeHandler(pokemon));
                    for (String aspect : megaPok.aspects()) {
                        String[] aspectDiv = aspect.split("=");
                        if (aspectDiv[1].equals("true") || aspectDiv[1].equals("false")) {
                            MegaLogic.megaEvolve(context, aspectDiv[0], battlePokemon, pokemonBattle);
                            continue;
                        }
                        MegaLogic.megaEvolve(context, aspectDiv[1], battlePokemon, pokemonBattle);
                    }
                    Utils.setTradable(pokemon, false);
                    return;
                }
                player.displayClientMessage((Component)Component.translatable((String)"message.mega_showdown.incorrect_mega_stone").withColor(0xFF0000), true);
                return;
            }
            return;
        }
        if (MegaShowdownConfig.friendshipMode && pokemon.getFriendship() < 200 && !pokemon.getEntity().isBattling()) {
            player.displayClientMessage((Component)Component.translatable((String)"message.mega_showdown.bond_not_close_mega").withColor(0xFF0000), true);
            return;
        }
        if (species.equals(pokemon.getSpecies().getName())) {
            if (species.equals("Charizard")) {
                if (pokemon.heldItem().is(MegaStones.CHARIZARDITE_X)) {
                    player.setData(DataManage.MEGA_DATA, (Object)true);
                    player.setData(DataManage.MEGA_POKEMON, (Object)new PokeHandler(pokemon));
                    MegaLogic.megaEvolve(context, "mega_x", battlePokemon, pokemonBattle);
                    Utils.setTradable(pokemon, false);
                } else if (pokemon.heldItem().is(MegaStones.CHARIZARDITE_Y)) {
                    player.setData(DataManage.MEGA_DATA, (Object)true);
                    player.setData(DataManage.MEGA_POKEMON, (Object)new PokeHandler(pokemon));
                    MegaLogic.megaEvolve(context, "mega_y", battlePokemon, pokemonBattle);
                    Utils.setTradable(pokemon, false);
                }
            } else if (species.equals("Mewtwo")) {
                if (pokemon.heldItem().is(MegaStones.MEWTWONITE_X)) {
                    player.setData(DataManage.MEGA_DATA, (Object)true);
                    player.setData(DataManage.MEGA_POKEMON, (Object)new PokeHandler(pokemon));
                    MegaLogic.megaEvolve(context, "mega_x", battlePokemon, pokemonBattle);
                    Utils.setTradable(pokemon, false);
                } else if (pokemon.heldItem().is(MegaStones.MEWTWONITE_Y)) {
                    player.setData(DataManage.MEGA_DATA, (Object)true);
                    player.setData(DataManage.MEGA_POKEMON, (Object)new PokeHandler(pokemon));
                    MegaLogic.megaEvolve(context, "mega_y", battlePokemon, pokemonBattle);
                    Utils.setTradable(pokemon, false);
                }
            } else {
                player.setData(DataManage.MEGA_DATA, (Object)true);
                player.setData(DataManage.MEGA_POKEMON, (Object)new PokeHandler(pokemon));
                Utils.setTradable(pokemon, false);
                MegaLogic.megaEvolve(context, "mega", battlePokemon, pokemonBattle);
            }
        } else {
            player.displayClientMessage((Component)Component.translatable((String)"message.mega_showdown.incorrect_mega_stone").withColor(0xFF0000), true);
        }
    }

    public static void megaEvolve(PokemonEntity context, String type, BattlePokemon battlePokemon, PokemonBattle pokemonBattle) {
        AdvancementHelper.grantAdvancement(context.getPokemon().getOwnerPlayer(), "mega/mega_evolve");
        context.getEntityData().set(PokemonEntity.getEVOLUTION_STARTED(), (Object)true);
        LazyLib.Companion.snowStormPartileSpawner((Entity)context, "mega_evolution", "target");
        BlockPos entityPos = context.getOnPos();
        context.level().playSound(null, (double)entityPos.getX(), (double)entityPos.getY(), (double)entityPos.getZ(), ModSounds.MEGA.get(), SoundSource.PLAYERS, 0.2f, 0.8f);
        context.after(4.7f, () -> {
            LazyLib.Companion.cryAnimation((Entity)context);
            context.getEntityData().set(PokemonEntity.getEVOLUTION_STARTED(), (Object)false);
            new StringSpeciesFeature("mega_evolution", type).apply(context.getPokemon());
            CobbleEventsHandler.updatePackets(pokemonBattle, battlePokemon, true);
            return Unit.INSTANCE;
        });
    }

    public static void playDevolveAnimation(LivingEntity context) {
        Level level = context.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            Vec3 entityPos = context.position();
            double entityWidth = context.getBbWidth();
            double entityHeight = context.getBbHeight();
            serverLevel.playSound(null, entityPos.x, entityPos.y, entityPos.z, SoundEvents.BEACON_DEACTIVATE, SoundSource.PLAYERS, 1.5f, 0.5f + (float)Math.random() * 0.5f);
            int particleCount = (int)(100.0 * entityWidth * entityHeight);
            double radius = entityWidth * 0.8;
            for (int i = 0; i < particleCount; ++i) {
                double angle = Math.random() * 2.0 * Math.PI;
                double xOffset = Math.cos(angle) * radius;
                double zOffset = Math.sin(angle) * radius;
                double yOffset = Math.random() * entityHeight;
                serverLevel.sendParticles((ParticleOptions)ParticleTypes.END_ROD, entityPos.x + xOffset, entityPos.y + yOffset, entityPos.z + zOffset, 1, 0.0, 0.0, 0.0, 0.1);
            }
        }
    }

    public static void NPCEvolve(PokemonEntity context, BattlePokemon battlePokemon, PokemonBattle pokemonBattle) {
        Pokemon pokemon = context.getPokemon();
        String species = Utils.MEGA_STONE_IDS.get(pokemon.heldItem().getItem());
        if (pokemon.getSpecies().getName().equals("Rayquaza")) {
            for (int i = 0; i < 4; ++i) {
                if (!((Move)pokemon.getMoveSet().getMoves().get(i)).getName().equals("dragonascent")) continue;
                MegaLogic.megaEvolve(context, "mega", battlePokemon, pokemonBattle);
                Utils.setTradable(pokemon, false);
            }
            return;
        }
        if (species == null) {
            for (MegaData megaPok : Utils.megaRegistry) {
                String[] parts = megaPok.item_id().split(":");
                ResourceLocation paperId = ResourceLocation.fromNamespaceAndPath((String)parts[0], (String)parts[1]);
                Item paperItem = (Item)BuiltInRegistries.ITEM.get(paperId);
                if (paperItem == pokemon.heldItem().getItem() && (pokemon.heldItem().get(DataComponents.CUSTOM_MODEL_DATA) != null && ((CustomModelData)pokemon.heldItem().get(DataComponents.CUSTOM_MODEL_DATA)).value() == megaPok.custom_model_data().intValue() || megaPok.custom_model_data() == 0)) {
                    species = megaPok.pokemon();
                }
                if (species == null) continue;
                if (species.equals(pokemon.getSpecies().getName())) {
                    for (String aspect : megaPok.aspects()) {
                        String[] aspectDiv = aspect.split("=");
                        if (aspectDiv[1].equals("true") || aspectDiv[1].equals("false")) {
                            MegaLogic.megaEvolve(context, aspectDiv[0], battlePokemon, pokemonBattle);
                            continue;
                        }
                        MegaLogic.megaEvolve(context, aspectDiv[1], battlePokemon, pokemonBattle);
                    }
                    Utils.setTradable(pokemon, false);
                    return;
                }
                return;
            }
            return;
        }
        if (species.equals(pokemon.getSpecies().getName())) {
            if (species.equals("Charizard")) {
                if (pokemon.heldItem().is(MegaStones.CHARIZARDITE_X)) {
                    MegaLogic.megaEvolve(context, "mega_x", battlePokemon, pokemonBattle);
                    Utils.setTradable(pokemon, false);
                } else if (pokemon.heldItem().is(MegaStones.CHARIZARDITE_Y)) {
                    MegaLogic.megaEvolve(context, "mega_y", battlePokemon, pokemonBattle);
                    Utils.setTradable(pokemon, false);
                }
            } else if (species.equals("Mewtwo")) {
                if (pokemon.heldItem().is(MegaStones.MEWTWONITE_X)) {
                    MegaLogic.megaEvolve(context, "mega_x", battlePokemon, pokemonBattle);
                    Utils.setTradable(pokemon, false);
                } else if (pokemon.heldItem().is(MegaStones.MEWTWONITE_Y)) {
                    MegaLogic.megaEvolve(context, "mega_y", battlePokemon, pokemonBattle);
                    Utils.setTradable(pokemon, false);
                }
            } else {
                Utils.setTradable(pokemon, false);
                MegaLogic.megaEvolve(context, "mega", battlePokemon, pokemonBattle);
            }
        }
    }
}

