/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.yajatkaul.mega_showdown.utility;

import com.cobblemon.mod.common.api.types.ElementalType;
import com.cobblemon.mod.common.api.types.ElementalTypes;
import com.cobblemon.mod.common.api.types.tera.TeraType;
import com.cobblemon.mod.common.api.types.tera.TeraTypes;
import com.cobblemon.yajatkaul.mega_showdown.item.TeraMoves;
import com.cobblemon.yajatkaul.mega_showdown.item.ZCrystals;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.registries.DeferredItem;

public class TeraTypeHelper {
    private static final Map<Item, TeraType> ITEM_TO_TERA_MAP = new HashMap<Item, TeraType>();

    public static void loadShardData() {
        ITEM_TO_TERA_MAP.put((Item)TeraMoves.BUG_TERA_SHARD.get(), TeraTypes.getBUG());
        ITEM_TO_TERA_MAP.put((Item)TeraMoves.DARK_TERA_SHARD.get(), TeraTypes.getDARK());
        ITEM_TO_TERA_MAP.put((Item)TeraMoves.DRAGON_TERA_SHARD.get(), TeraTypes.getDRAGON());
        ITEM_TO_TERA_MAP.put((Item)TeraMoves.ELECTRIC_TERA_SHARD.get(), TeraTypes.getELECTRIC());
        ITEM_TO_TERA_MAP.put((Item)TeraMoves.FAIRY_TERA_SHARD.get(), TeraTypes.getFAIRY());
        ITEM_TO_TERA_MAP.put((Item)TeraMoves.FIGHTING_TERA_SHARD.get(), TeraTypes.getFIGHTING());
        ITEM_TO_TERA_MAP.put((Item)TeraMoves.FIRE_TERA_SHARD.get(), TeraTypes.getFIRE());
        ITEM_TO_TERA_MAP.put((Item)TeraMoves.FLYING_TERA_SHARD.get(), TeraTypes.getFLYING());
        ITEM_TO_TERA_MAP.put((Item)TeraMoves.GHOST_TERA_SHARD.get(), TeraTypes.getGHOST());
        ITEM_TO_TERA_MAP.put((Item)TeraMoves.GRASS_TERA_SHARD.get(), TeraTypes.getGRASS());
        ITEM_TO_TERA_MAP.put((Item)TeraMoves.GROUND_TERA_SHARD.get(), TeraTypes.getGROUND());
        ITEM_TO_TERA_MAP.put((Item)TeraMoves.ICE_TERA_SHARD.get(), TeraTypes.getICE());
        ITEM_TO_TERA_MAP.put((Item)TeraMoves.NORMAL_TERA_SHARD.get(), TeraTypes.getNORMAL());
        ITEM_TO_TERA_MAP.put((Item)TeraMoves.POISON_TERA_SHARD.get(), TeraTypes.getPOISON());
        ITEM_TO_TERA_MAP.put((Item)TeraMoves.PSYCHIC_TERA_SHARD.get(), TeraTypes.getPSYCHIC());
        ITEM_TO_TERA_MAP.put((Item)TeraMoves.ROCK_TERA_SHARD.get(), TeraTypes.getROCK());
        ITEM_TO_TERA_MAP.put((Item)TeraMoves.STEEL_TERA_SHARD.get(), TeraTypes.getSTEEL());
        ITEM_TO_TERA_MAP.put((Item)TeraMoves.STELLAR_TERA_SHARD.get(), TeraTypes.getSTELLAR());
        ITEM_TO_TERA_MAP.put((Item)TeraMoves.WATER_TERA_SHARD.get(), TeraTypes.getWATER());
    }

    public static TeraType getType(Item item) {
        return ITEM_TO_TERA_MAP.getOrDefault(item, TeraTypes.getNORMAL());
    }

    public static DeferredItem<Item> getTeraShardForType(Iterable<ElementalType> types) {
        for (ElementalType type : types) {
            if (type.equals(ElementalTypes.INSTANCE.getBUG())) {
                return TeraMoves.BUG_TERA_SHARD;
            }
            if (type.equals(ElementalTypes.INSTANCE.getDARK())) {
                return TeraMoves.DARK_TERA_SHARD;
            }
            if (type.equals(ElementalTypes.INSTANCE.getDRAGON())) {
                return TeraMoves.DRAGON_TERA_SHARD;
            }
            if (type.equals(ElementalTypes.INSTANCE.getELECTRIC())) {
                return TeraMoves.ELECTRIC_TERA_SHARD;
            }
            if (type.equals(ElementalTypes.INSTANCE.getFAIRY())) {
                return TeraMoves.FAIRY_TERA_SHARD;
            }
            if (type.equals(ElementalTypes.INSTANCE.getFIGHTING())) {
                return TeraMoves.FIGHTING_TERA_SHARD;
            }
            if (type.equals(ElementalTypes.INSTANCE.getFIRE())) {
                return TeraMoves.FIRE_TERA_SHARD;
            }
            if (type.equals(ElementalTypes.INSTANCE.getFLYING())) {
                return TeraMoves.FLYING_TERA_SHARD;
            }
            if (type.equals(ElementalTypes.INSTANCE.getGHOST())) {
                return TeraMoves.GHOST_TERA_SHARD;
            }
            if (type.equals(ElementalTypes.INSTANCE.getGRASS())) {
                return TeraMoves.GRASS_TERA_SHARD;
            }
            if (type.equals(ElementalTypes.INSTANCE.getGROUND())) {
                return TeraMoves.GROUND_TERA_SHARD;
            }
            if (type.equals(ElementalTypes.INSTANCE.getICE())) {
                return TeraMoves.ICE_TERA_SHARD;
            }
            if (type.equals(ElementalTypes.INSTANCE.getNORMAL())) {
                return TeraMoves.NORMAL_TERA_SHARD;
            }
            if (type.equals(ElementalTypes.INSTANCE.getPOISON())) {
                return TeraMoves.POISON_TERA_SHARD;
            }
            if (type.equals(ElementalTypes.INSTANCE.getPSYCHIC())) {
                return TeraMoves.PSYCHIC_TERA_SHARD;
            }
            if (type.equals(ElementalTypes.INSTANCE.getROCK())) {
                return TeraMoves.ROCK_TERA_SHARD;
            }
            if (type.equals(ElementalTypes.INSTANCE.getSTEEL())) {
                return TeraMoves.STEEL_TERA_SHARD;
            }
            if (!type.equals(ElementalTypes.INSTANCE.getWATER())) continue;
            return TeraMoves.WATER_TERA_SHARD;
        }
        return TeraMoves.NORMAL_TERA_SHARD;
    }

    public static ChatFormatting getGlowColorForType(ItemStack heldItem) {
        if (heldItem.is(ZCrystals.ALORAICHIUM_Z)) {
            return ChatFormatting.YELLOW;
        }
        if (heldItem.is(ZCrystals.BUGINIUM_Z)) {
            return ChatFormatting.DARK_GREEN;
        }
        if (heldItem.is(ZCrystals.DARKINIUM_Z)) {
            return ChatFormatting.BLACK;
        }
        if (heldItem.is(ZCrystals.DRAGONIUM_Z) || heldItem.is(ZCrystals.KOMMONIUM_Z)) {
            return ChatFormatting.DARK_BLUE;
        }
        if (heldItem.is(ZCrystals.EEVIUM_Z) || heldItem.is(ZCrystals.SNORLIUM_Z) || heldItem.is(ZCrystals.NORMALIUM_Z)) {
            return ChatFormatting.WHITE;
        }
        if (heldItem.is(ZCrystals.ELECTRIUM_Z) || heldItem.is(ZCrystals.PIKANIUM_Z) || heldItem.is(ZCrystals.PIKASHUNIUM_Z)) {
            return ChatFormatting.YELLOW;
        }
        if (heldItem.is(ZCrystals.FAIRIUM_Z) || heldItem.is(ZCrystals.TAPUNIUM_Z)) {
            return ChatFormatting.LIGHT_PURPLE;
        }
        if (heldItem.is(ZCrystals.FIGHTINIUM_Z)) {
            return ChatFormatting.DARK_RED;
        }
        if (heldItem.is(ZCrystals.FIRIUM_Z) || heldItem.is(ZCrystals.INCINIUM_Z)) {
            return ChatFormatting.RED;
        }
        if (heldItem.is(ZCrystals.FLYINIUM_Z)) {
            return ChatFormatting.GRAY;
        }
        if (heldItem.is(ZCrystals.GHOSTIUM_Z) || heldItem.is(ZCrystals.MARSHADIUM_Z) || heldItem.is(ZCrystals.MIMIKIUM_Z)) {
            return ChatFormatting.DARK_PURPLE;
        }
        if (heldItem.is(ZCrystals.GRASSIUM_Z) || heldItem.is(ZCrystals.DECIDIUM_Z)) {
            return ChatFormatting.GREEN;
        }
        if (heldItem.is(ZCrystals.GROUNDIUM_Z) || heldItem.is(ZCrystals.LYCANIUM_Z)) {
            return ChatFormatting.DARK_RED;
        }
        if (heldItem.is(ZCrystals.ICIUM_Z)) {
            return ChatFormatting.BLUE;
        }
        if (heldItem.is(ZCrystals.POISONIUM_Z)) {
            return ChatFormatting.DARK_PURPLE;
        }
        if (heldItem.is(ZCrystals.PSYCHIUM_Z) || heldItem.is(ZCrystals.MEWNIUM_Z)) {
            return ChatFormatting.LIGHT_PURPLE;
        }
        if (heldItem.is(ZCrystals.ROCKIUM_Z)) {
            return ChatFormatting.DARK_GRAY;
        }
        if (heldItem.is(ZCrystals.STEELIUM_Z)) {
            return ChatFormatting.GRAY;
        }
        if (heldItem.is(ZCrystals.WATERIUM_Z) || heldItem.is(ZCrystals.PRIMARIUM_Z)) {
            return ChatFormatting.BLUE;
        }
        if (heldItem.is(ZCrystals.SOLGANIUM_Z) || heldItem.is(ZCrystals.LUNALIUM_Z) || heldItem.is(ZCrystals.ULTRANECROZIUM_Z)) {
            return ChatFormatting.GOLD;
        }
        return ChatFormatting.WHITE;
    }

    public static ChatFormatting getGlowColorForTeraType(TeraType teraType) {
        if (teraType.equals((Object)TeraTypes.getBUG())) {
            return ChatFormatting.DARK_GREEN;
        }
        if (teraType.equals((Object)TeraTypes.getDARK())) {
            return ChatFormatting.BLACK;
        }
        if (teraType.equals((Object)TeraTypes.getDRAGON())) {
            return ChatFormatting.DARK_BLUE;
        }
        if (teraType.equals((Object)TeraTypes.getELECTRIC())) {
            return ChatFormatting.YELLOW;
        }
        if (teraType.equals((Object)TeraTypes.getFAIRY())) {
            return ChatFormatting.LIGHT_PURPLE;
        }
        if (teraType.equals((Object)TeraTypes.getFIGHTING())) {
            return ChatFormatting.DARK_RED;
        }
        if (teraType.equals((Object)TeraTypes.getFIRE())) {
            return ChatFormatting.RED;
        }
        if (teraType.equals((Object)TeraTypes.getFLYING())) {
            return ChatFormatting.GRAY;
        }
        if (teraType.equals((Object)TeraTypes.getGHOST())) {
            return ChatFormatting.DARK_PURPLE;
        }
        if (teraType.equals((Object)TeraTypes.getGRASS())) {
            return ChatFormatting.GREEN;
        }
        if (teraType.equals((Object)TeraTypes.getGROUND())) {
            return ChatFormatting.DARK_RED;
        }
        if (teraType.equals((Object)TeraTypes.getICE())) {
            return ChatFormatting.BLUE;
        }
        if (teraType.equals((Object)TeraTypes.getNORMAL())) {
            return ChatFormatting.WHITE;
        }
        if (teraType.equals((Object)TeraTypes.getPOISON())) {
            return ChatFormatting.DARK_PURPLE;
        }
        if (teraType.equals((Object)TeraTypes.getPSYCHIC())) {
            return ChatFormatting.LIGHT_PURPLE;
        }
        if (teraType.equals((Object)TeraTypes.getROCK())) {
            return ChatFormatting.DARK_GRAY;
        }
        if (teraType.equals((Object)TeraTypes.getSTEEL())) {
            return ChatFormatting.GRAY;
        }
        if (teraType.equals((Object)TeraTypes.getWATER())) {
            return ChatFormatting.BLUE;
        }
        if (teraType.equals((Object)TeraTypes.getSTELLAR())) {
            return ChatFormatting.WHITE;
        }
        return ChatFormatting.WHITE;
    }
}

