/*
 * Decompiled with CFR 0.152.
 */
package com.github.yajatkaul.mega_showdown.codec.particles;

import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import com.github.yajatkaul.mega_showdown.MegaShowdown;
import com.github.yajatkaul.mega_showdown.codec.particles.AnimationData;
import com.github.yajatkaul.mega_showdown.codec.particles.SoundCodec;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public record MinecraftParticle(Optional<String> particle_apply, Optional<String> particle_revert, Optional<SoundCodec> sound_apply, Optional<SoundCodec> sound_revert, Optional<Float> particle_apply_amplifier, Optional<Float> particle_revert_amplifier, Optional<AnimationData> animations) {
    public static final Codec<MinecraftParticle> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.optionalFieldOf("particle_apply").forGetter(MinecraftParticle::particle_apply), (App)Codec.STRING.optionalFieldOf("particle_revert").forGetter(MinecraftParticle::particle_revert), (App)SoundCodec.CODEC.optionalFieldOf("sound_apply").forGetter(MinecraftParticle::sound_apply), (App)SoundCodec.CODEC.optionalFieldOf("sound_revert").forGetter(MinecraftParticle::sound_revert), (App)Codec.FLOAT.optionalFieldOf("particle_apply_amplifier").forGetter(MinecraftParticle::particle_apply_amplifier), (App)Codec.FLOAT.optionalFieldOf("particle_revert_amplifier").forGetter(MinecraftParticle::particle_revert_amplifier), (App)AnimationData.CODEC.optionalFieldOf("animations").forGetter(MinecraftParticle::animations)).apply((Applicative)instance, MinecraftParticle::new));

    public void apply(PokemonEntity context) {
        if (context == null) {
            return;
        }
        Level level = context.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            Vec3 entityPos = context.position();
            this.animations.ifPresent(animation -> animation.applyAnimations(context));
            this.sound_apply.ifPresent(sound_apply -> sound_apply.play(context));
            this.particle_apply.ifPresent(particle_apply -> {
                String[] partsParticle = particle_apply.split(":");
                ResourceLocation custom_particle_id = ResourceLocation.fromNamespaceAndPath((String)partsParticle[0], (String)partsParticle[1]);
                ParticleType particleType = (ParticleType)BuiltInRegistries.PARTICLE_TYPE.get(custom_particle_id);
                double entityWidth = context.getBbWidth();
                double entityHeight = context.getBbHeight();
                int baseParticleCount = (int)(100.0 * entityWidth * entityHeight);
                float amplifier = 1.0f;
                if (this.particle_apply_amplifier.isPresent()) {
                    amplifier = Math.max(1.0f, this.particle_apply_amplifier.get().floatValue());
                }
                float particleCount = (float)baseParticleCount * amplifier;
                double radius = entityWidth * (0.8 + (double)amplifier * 0.1);
                if (particleType instanceof ParticleOptions) {
                    ParticleOptions particle = (ParticleOptions)particleType;
                    int i = 0;
                    while ((float)i < particleCount) {
                        double angle = Math.random() * 2.0 * Math.PI;
                        double xOffset = Math.cos(angle) * radius;
                        double zOffset = Math.sin(angle) * radius;
                        double yOffset = Math.random() * entityHeight;
                        serverLevel.sendParticles(particle, entityPos.x + xOffset, entityPos.y + yOffset, entityPos.z + zOffset, 1, 0.0, 0.0, 0.0, 0.1);
                        ++i;
                    }
                } else {
                    MegaShowdown.LOGGER.error("Invalid Particle Apply used for pokemons: {}, particle id: {}", (Object)context.getPokemon().getSpecies().getName(), particle_apply);
                }
            });
        }
    }

    public void revert(PokemonEntity context) {
        if (context == null) {
            return;
        }
        Level level = context.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            Vec3 entityPos = context.position();
            this.animations.ifPresent(animation -> animation.revertAnimations(context));
            this.sound_revert.ifPresent(sound_revert -> sound_revert.play(context));
            this.particle_revert.ifPresent(particle_revert -> {
                String[] partsParticle = particle_revert.split(":");
                ResourceLocation custom_particle_id = ResourceLocation.fromNamespaceAndPath((String)partsParticle[0], (String)partsParticle[1]);
                ParticleType particleType = (ParticleType)BuiltInRegistries.PARTICLE_TYPE.get(custom_particle_id);
                double entityWidth = context.getBbWidth();
                double entityHeight = context.getBbHeight();
                int baseParticleCount = (int)(100.0 * entityWidth * entityHeight);
                float amplifier = 1.0f;
                if (this.particle_revert_amplifier.isPresent()) {
                    amplifier = Math.max(1.0f, this.particle_revert_amplifier.get().floatValue());
                }
                float particleCount = (float)baseParticleCount * amplifier;
                double radius = entityWidth * (0.8 + (double)amplifier * 0.1);
                if (particleType instanceof ParticleOptions) {
                    ParticleOptions particle = (ParticleOptions)particleType;
                    int i = 0;
                    while ((float)i < particleCount) {
                        double angle = Math.random() * 2.0 * Math.PI;
                        double xOffset = Math.cos(angle) * radius;
                        double zOffset = Math.sin(angle) * radius;
                        double yOffset = Math.random() * entityHeight;
                        serverLevel.sendParticles(particle, entityPos.x + xOffset, entityPos.y + yOffset, entityPos.z + zOffset, 1, 0.0, 0.0, 0.0, 0.1);
                        ++i;
                    }
                } else {
                    MegaShowdown.LOGGER.error("Invalid Particle Revert used for pokemons: {}, particle id: {}", (Object)context.getPokemon().getSpecies().getName(), particle_revert);
                }
            });
        }
    }
}

