/*
 * Decompiled with CFR 0.152.
 */
package com.github.yajatkaul.mega_showdown.codec.particles;

import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import com.github.yajatkaul.mega_showdown.utils.PokemonBehaviourHelper;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.HashSet;
import java.util.List;
import kotlin.Unit;
import net.minecraft.world.entity.Entity;

public record AnimationData(List<String> animations_apply, List<String> expressions_apply, List<String> animations_revert, List<String> expressions_revert, float applyDelay, float revertDelay) {
    public static final Codec<AnimationData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.list((Codec)Codec.STRING).optionalFieldOf("animations_apply", List.of()).forGetter(AnimationData::animations_apply), (App)Codec.list((Codec)Codec.STRING).optionalFieldOf("expressions_apply", List.of()).forGetter(AnimationData::expressions_apply), (App)Codec.list((Codec)Codec.STRING).optionalFieldOf("animations_revert", List.of()).forGetter(AnimationData::animations_revert), (App)Codec.list((Codec)Codec.STRING).optionalFieldOf("expressions_revert", List.of()).forGetter(AnimationData::expressions_revert), (App)Codec.FLOAT.optionalFieldOf("apply_delay", (Object)Float.valueOf(0.0f)).forGetter(AnimationData::applyDelay), (App)Codec.FLOAT.optionalFieldOf("revert_delay", (Object)Float.valueOf(0.0f)).forGetter(AnimationData::revertDelay)).apply((Applicative)instance, AnimationData::new));

    public void applyAnimations(PokemonEntity context) {
        context.after(this.applyDelay, () -> {
            PokemonBehaviourHelper.Companion.playAnimation((Entity)context, new HashSet<String>(this.animations_apply), this.expressions_apply);
            return Unit.INSTANCE;
        });
    }

    public void revertAnimations(PokemonEntity context) {
        context.after(this.revertDelay, () -> {
            PokemonBehaviourHelper.Companion.playAnimation((Entity)context, new HashSet<String>(this.animations_revert), this.expressions_revert);
            return Unit.INSTANCE;
        });
    }
}

