/*
 * Decompiled with CFR 0.152.
 */
package com.github.yajatkaul.mega_showdown.item.custom.dynamax;

import com.cobblemon.mod.common.CobblemonSounds;
import com.cobblemon.mod.common.advancement.CobblemonCriteria;
import com.cobblemon.mod.common.advancement.criterion.PokemonInteractContext;
import com.cobblemon.mod.common.api.battles.model.PokemonBattle;
import com.cobblemon.mod.common.api.battles.model.actor.BattleActor;
import com.cobblemon.mod.common.api.callback.PartySelectCallbacks;
import com.cobblemon.mod.common.api.item.HealingSource;
import com.cobblemon.mod.common.api.pokemon.stats.Stats;
import com.cobblemon.mod.common.api.text.TextKt;
import com.cobblemon.mod.common.battles.BagItemActionResponse;
import com.cobblemon.mod.common.battles.BattleRegistry;
import com.cobblemon.mod.common.battles.ShowdownActionResponse;
import com.cobblemon.mod.common.battles.pokemon.BattlePokemon;
import com.cobblemon.mod.common.item.battle.BagItem;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.cobblemon.mod.common.util.ItemStackExtensionsKt;
import com.cobblemon.mod.common.util.LocalizationUtilsKt;
import com.github.yajatkaul.mega_showdown.item.custom.ToolTipBlockItem;
import com.github.yajatkaul.mega_showdown.item.custom.dynamax.MaxMushroom;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000M\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\b\u0004*\u0001\u0018\b\u0016\u0018\u00002\u00020\u00012\u00020\u0002B\u0017\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ-\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\rH\u0016\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u0017\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0014\u001a\u00020\u0013H\u0016\u00a2\u0006\u0004\b\u0016\u0010\u0017R\u0014\u0010\u0019\u001a\u00020\u00188\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0019\u0010\u001a\u00a8\u0006\u001b"}, d2={"Lcom/github/yajatkaul/mega_showdown/item/custom/dynamax/MaxMushroom;", "Lcom/github/yajatkaul/mega_showdown/item/custom/ToolTipBlockItem;", "Lcom/cobblemon/mod/common/api/item/HealingSource;", "Lnet/minecraft/world/level/block/Block;", "block", "Lnet/minecraft/world/item/Item$Properties;", "settings", "<init>", "(Lnet/minecraft/world/level/block/Block;Lnet/minecraft/world/item/Item$Properties;)V", "Lnet/minecraft/world/level/Level;", "world", "Lnet/minecraft/world/entity/player/Player;", "user", "Lnet/minecraft/world/InteractionHand;", "hand", "Lnet/minecraft/world/InteractionResultHolder;", "Lnet/minecraft/world/item/ItemStack;", "use", "(Lnet/minecraft/world/level/Level;Lnet/minecraft/world/entity/player/Player;Lnet/minecraft/world/InteractionHand;)Lnet/minecraft/world/InteractionResultHolder;", "Lnet/minecraft/world/item/context/UseOnContext;", "arg", "Lnet/minecraft/world/InteractionResult;", "useOn", "(Lnet/minecraft/world/item/context/UseOnContext;)Lnet/minecraft/world/InteractionResult;", "com/github/yajatkaul/mega_showdown/item/custom/dynamax/MaxMushroom.bagItem.1", "bagItem", "Lcom/github/yajatkaul/mega_showdown/item/custom/dynamax/MaxMushroom$bagItem$1;", "mega_showdown-common"})
public class MaxMushroom
extends ToolTipBlockItem
implements HealingSource {
    @NotNull
    private final bagItem.1 bagItem;

    public MaxMushroom(@NotNull Block block, @NotNull Item.Properties settings) {
        Intrinsics.checkNotNullParameter((Object)block, (String)"block");
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        super(block, settings);
        this.bagItem = new BagItem(){
            private final String itemName;
            private final Item returnItem;
            {
                this.itemName = "item.mega_showdown.max_mushroom";
                this.returnItem = Items.AIR;
            }

            public String getItemName() {
                return this.itemName;
            }

            public Item getReturnItem() {
                return this.returnItem;
            }

            public boolean canUse(ItemStack stack, PokemonBattle battle, BattlePokemon target) {
                Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
                Intrinsics.checkNotNullParameter((Object)battle, (String)"battle");
                Intrinsics.checkNotNullParameter((Object)target, (String)"target");
                return target.getHealth() > 0;
            }

            public String getShowdownInput(BattleActor actor, BattlePokemon battlePokemon, String data) {
                Intrinsics.checkNotNullParameter((Object)actor, (String)"actor");
                Intrinsics.checkNotNullParameter((Object)battlePokemon, (String)"battlePokemon");
                Pokemon.incrementFriendship$default((Pokemon)battlePokemon.getEffectedPokemon(), (int)1, (boolean)false, (int)2, null);
                return "max_mushroom " + Stats.ATTACK.getShowdownId() + " " + Stats.DEFENCE.getShowdownId() + " " + Stats.SPECIAL_ATTACK.getShowdownId() + " " + Stats.SPECIAL_DEFENCE.getShowdownId() + " " + Stats.SPEED.getShowdownId() + " 1";
            }
        };
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(@NotNull Level world, @NotNull Player user, @NotNull InteractionHand hand) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)user, (String)"user");
        Intrinsics.checkNotNullParameter((Object)hand, (String)"hand");
        if (!(world instanceof ServerLevel)) {
            InteractionResultHolder interactionResultHolder = InteractionResultHolder.pass((Object)user.getItemInHand(hand));
            Intrinsics.checkNotNullExpressionValue((Object)interactionResultHolder, (String)"pass(...)");
            return interactionResultHolder;
        }
        ServerPlayer player = (ServerPlayer)user;
        ItemStack stack = user.getItemInHand(hand);
        PokemonBattle battle = BattleRegistry.getBattleByParticipatingPlayer((ServerPlayer)player);
        if (battle != null) {
            BattleActor battleActor = battle.getActor(player);
            Intrinsics.checkNotNull((Object)battleActor);
            BattleActor actor = battleActor;
            List battlePokemon = actor.getPokemonList();
            if (!actor.canFitForcedAction()) {
                MutableComponent mutableComponent = LocalizationUtilsKt.battleLang((String)"bagitem.cannot", (Object[])new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)mutableComponent, (String)"battleLang(...)");
                player.sendSystemMessage((Component)TextKt.red((MutableComponent)mutableComponent), true);
                InteractionResultHolder interactionResultHolder = InteractionResultHolder.consume((Object)stack);
                Intrinsics.checkNotNullExpressionValue((Object)interactionResultHolder, (String)"consume(...)");
                return interactionResultHolder;
            }
            int turn = battle.getTurn();
            PartySelectCallbacks.createBattleSelect$default((PartySelectCallbacks)PartySelectCallbacks.INSTANCE, (ServerPlayer)player, null, (List)battlePokemon, arg_0 -> MaxMushroom.use$lambda$0(this, stack, battle, arg_0), null, arg_0 -> MaxMushroom.use$lambda$1(actor, battle, turn, stack, player, this, arg_0), (int)18, null);
            InteractionResultHolder interactionResultHolder = InteractionResultHolder.success((Object)stack);
            Intrinsics.checkNotNullExpressionValue((Object)interactionResultHolder, (String)"success(...)");
            return interactionResultHolder;
        }
        InteractionResultHolder interactionResultHolder = super.use(world, user, hand);
        Intrinsics.checkNotNullExpressionValue((Object)interactionResultHolder, (String)"use(...)");
        return interactionResultHolder;
    }

    @NotNull
    public InteractionResult useOn(@NotNull UseOnContext arg) {
        PokemonBattle battle;
        Intrinsics.checkNotNullParameter((Object)arg, (String)"arg");
        Player player = arg.getPlayer();
        ItemStack stack = arg.getItemInHand();
        if (player instanceof ServerPlayer && (battle = BattleRegistry.getBattleByParticipatingPlayer((ServerPlayer)((ServerPlayer)player))) != null) {
            BattleActor battleActor = battle.getActor((ServerPlayer)player);
            Intrinsics.checkNotNull((Object)battleActor);
            BattleActor actor = battleActor;
            List battlePokemon = actor.getPokemonList();
            if (!actor.canFitForcedAction()) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                MutableComponent mutableComponent = LocalizationUtilsKt.battleLang((String)"bagitem.cannot", (Object[])new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)mutableComponent, (String)"battleLang(...)");
                serverPlayer.sendSystemMessage((Component)TextKt.red((MutableComponent)mutableComponent), false);
                return InteractionResult.PASS;
            }
            int turn = battle.getTurn();
            PartySelectCallbacks.createBattleSelect$default((PartySelectCallbacks)PartySelectCallbacks.INSTANCE, (ServerPlayer)((ServerPlayer)player), null, (List)battlePokemon, arg_0 -> MaxMushroom.useOn$lambda$2(this, stack, battle, arg_0), null, arg_0 -> MaxMushroom.useOn$lambda$3(actor, battle, turn, stack, player, this, arg_0), (int)18, null);
            return InteractionResult.SUCCESS;
        }
        InteractionResult interactionResult = super.useOn(arg);
        Intrinsics.checkNotNullExpressionValue((Object)interactionResult, (String)"useOn(...)");
        return interactionResult;
    }

    private static final boolean use$lambda$0(MaxMushroom this$0, ItemStack $stack, PokemonBattle $battle, BattlePokemon it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        bagItem.1 v0 = this$0.bagItem;
        Intrinsics.checkNotNull((Object)$stack);
        return v0.canUse($stack, $battle, it);
    }

    private static final Unit use$lambda$1(BattleActor $actor, PokemonBattle $battle, int $turn, ItemStack $stack, ServerPlayer $player, MaxMushroom this$0, BattlePokemon bp) {
        Intrinsics.checkNotNullParameter((Object)bp, (String)"bp");
        if ($actor.canFitForcedAction() && bp.getHealth() > 0 && $battle.getTurn() == $turn) {
            Intrinsics.checkNotNull((Object)$stack);
            if (ItemStackExtensionsKt.isHeld((ItemStack)$stack, (ServerPlayer)$player)) {
                $player.playSound(CobblemonSounds.ITEM_USE, 1.0f, 1.0f);
                $actor.forceChoose((ShowdownActionResponse)new BagItemActionResponse((BagItem)this$0.bagItem, bp, bp.getUuid().toString()));
                ResourceLocation resourceLocation = BuiltInRegistries.ITEM.getKey((Object)$stack.getItem());
                Intrinsics.checkNotNullExpressionValue((Object)resourceLocation, (String)"getKey(...)");
                ResourceLocation stackName = resourceLocation;
                $stack.consume(1, (LivingEntity)$player);
                CobblemonCriteria.POKEMON_INTERACT.trigger($player, (Object)new PokemonInteractContext(bp.getEffectedPokemon().getSpecies().getResourceIdentifier(), stackName));
            }
        }
        return Unit.INSTANCE;
    }

    private static final boolean useOn$lambda$2(MaxMushroom this$0, ItemStack $stack, PokemonBattle $battle, BattlePokemon it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        bagItem.1 v0 = this$0.bagItem;
        Intrinsics.checkNotNull((Object)$stack);
        return v0.canUse($stack, $battle, it);
    }

    private static final Unit useOn$lambda$3(BattleActor $actor, PokemonBattle $battle, int $turn, ItemStack $stack, Player $player, MaxMushroom this$0, BattlePokemon bp) {
        Intrinsics.checkNotNullParameter((Object)bp, (String)"bp");
        if ($actor.canFitForcedAction() && bp.getHealth() > 0 && $battle.getTurn() == $turn) {
            Intrinsics.checkNotNull((Object)$stack);
            if (ItemStackExtensionsKt.isHeld((ItemStack)$stack, (ServerPlayer)((ServerPlayer)$player))) {
                ((ServerPlayer)$player).playSound(CobblemonSounds.ITEM_USE, 1.0f, 1.0f);
                $actor.forceChoose((ShowdownActionResponse)new BagItemActionResponse((BagItem)this$0.bagItem, bp, bp.getUuid().toString()));
                ResourceLocation resourceLocation = BuiltInRegistries.ITEM.getKey((Object)$stack.getItem());
                Intrinsics.checkNotNullExpressionValue((Object)resourceLocation, (String)"getKey(...)");
                ResourceLocation stackName = resourceLocation;
                $stack.consume(1, (LivingEntity)$player);
                CobblemonCriteria.POKEMON_INTERACT.trigger((ServerPlayer)$player, (Object)new PokemonInteractContext(bp.getEffectedPokemon().getSpecies().getResourceIdentifier(), stackName));
            }
        }
        return Unit.INSTANCE;
    }
}

