/*
 * Decompiled with CFR 0.152.
 */
package com.github.yajatkaul.mega_showdown.item.custom.gimmick;

import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import com.github.yajatkaul.mega_showdown.MegaShowdown;
import com.github.yajatkaul.mega_showdown.gimmick.MegaGimmick;
import com.github.yajatkaul.mega_showdown.item.custom.ToolTipItem;
import com.github.yajatkaul.mega_showdown.utils.PlayerUtils;
import io.wispforest.accessories.api.AccessoriesCapability;
import io.wispforest.accessories.api.AccessoriesContainer;
import io.wispforest.accessories.data.SlotTypeLoader;
import io.wispforest.accessories.impl.ExpandedSimpleContainer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;

public class MegaBracelet
extends ToolTipItem {
    public MegaBracelet(Item.Properties properties) {
        super(properties);
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ItemStack stack;
        block5: {
            AccessoriesCapability capability;
            block4: {
                stack = player.getItemInHand(hand);
                capability = AccessoriesCapability.get((LivingEntity)player);
                if (level.isClientSide || capability == null) {
                    return InteractionResultHolder.pass((Object)stack);
                }
                EntityHitResult hitResult = PlayerUtils.getEntityLookingAt(player, 4.5f);
                Entity entity = null;
                if (hitResult != null) {
                    entity = hitResult.getEntity();
                }
                if (!(entity instanceof PokemonEntity)) break block4;
                PokemonEntity pokemonEntity = (PokemonEntity)entity;
                if (pokemonEntity.getPokemon().getOwnerPlayer() != player) break block5;
                MegaGimmick.megaToggle(pokemonEntity);
                break block5;
            }
            AccessoriesContainer slot = capability.getContainer(SlotTypeLoader.getSlotType((Level)level, (String)"mega_slot"));
            ExpandedSimpleContainer accessories = slot.getAccessories();
            if (accessories == null) {
                MegaShowdown.LOGGER.info("No mega_slot found");
                return InteractionResultHolder.pass((Object)stack);
            }
            for (int i = 0; i < accessories.getContainerSize(); ++i) {
                if (!accessories.getItem(i).isEmpty()) continue;
                accessories.setItem(i, stack.copy());
                player.setItemInHand(hand, ItemStack.EMPTY);
                level.playSound(null, player.getX(), player.getY(), player.getZ(), (SoundEvent)SoundEvents.ARMOR_EQUIP_GENERIC.value(), SoundSource.PLAYERS, 1.0f, 1.0f);
                break;
            }
        }
        return InteractionResultHolder.pass((Object)stack);
    }
}

