/*
 * Decompiled with CFR 0.152.
 */
package com.github.yajatkaul.mega_showdown.utils;

import com.cobblemon.mod.common.Cobblemon;
import com.cobblemon.mod.common.api.battles.model.PokemonBattle;
import com.cobblemon.mod.common.api.battles.model.actor.ActorType;
import com.cobblemon.mod.common.api.net.NetworkPacket;
import com.cobblemon.mod.common.api.pokemon.feature.FlagSpeciesFeature;
import com.cobblemon.mod.common.api.pokemon.feature.StringSpeciesFeature;
import com.cobblemon.mod.common.api.storage.party.PlayerPartyStore;
import com.cobblemon.mod.common.battles.ActiveBattlePokemon;
import com.cobblemon.mod.common.battles.pokemon.BattlePokemon;
import com.cobblemon.mod.common.net.messages.client.battle.BattleTransformPokemonPacket;
import com.cobblemon.mod.common.net.messages.client.battle.BattleUpdateTeamPokemonPacket;
import com.cobblemon.mod.common.net.messages.client.pokemon.update.AbilityUpdatePacket;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.github.yajatkaul.mega_showdown.codec.Effect;
import com.github.yajatkaul.mega_showdown.gimmick.MaxGimmick;
import com.github.yajatkaul.mega_showdown.tag.MegaShowdownTags;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffects;

public class AspectUtils {
    public static void applyAspects(Pokemon pokemon, List<String> aspects) {
        for (String aspect : aspects) {
            String[] aspect_split = aspect.split("=");
            if (aspect_split[1].equals("true") || aspect_split[1].equals("false")) {
                new FlagSpeciesFeature(aspect_split[0], Boolean.parseBoolean(aspect_split[1])).apply(pokemon);
                continue;
            }
            new StringSpeciesFeature(aspect_split[0], aspect_split[1]).apply(pokemon);
        }
    }

    public static void appendRevertDataPokemon(Effect effect, List<String> string, Pokemon pokemon, String tagName) {
        EffectPair effectPair = new EffectPair(effect, string);
        List<EffectPair> existing = AspectUtils.getRevertDataPokemon(pokemon, tagName);
        existing.add(effectPair);
        Tag encoded = (Tag)EffectPair.CODEC.listOf().encodeStart((DynamicOps)NbtOps.INSTANCE, existing).getOrThrow();
        pokemon.getPersistentData().put(tagName, encoded);
        pokemon.onChange(null);
    }

    public static List<EffectPair> getRevertDataPokemon(Pokemon pokemon, String tagName) {
        Tag raw = pokemon.getPersistentData().get(tagName);
        if (raw == null) {
            return new ArrayList<EffectPair>();
        }
        return EffectPair.CODEC.listOf().parse((DynamicOps)NbtOps.INSTANCE, (Object)raw).result().map(ArrayList::new).orElseGet(ArrayList::new);
    }

    public static void revertPokemonsIfRequired(ServerPlayer player) {
        if (player == null) {
            return;
        }
        PlayerPartyStore playerPartyStore = Cobblemon.INSTANCE.getStorage().getParty(player);
        for (Pokemon pokemon : playerPartyStore) {
            AspectUtils.revertPokemonsIfRequired(pokemon);
            if (!pokemon.getSpecies().getName().equals("Burmy")) continue;
            Holder biomeHolder = player.serverLevel().getBiome(player.blockPosition());
            boolean isSandy = biomeHolder.is(MegaShowdownTags.Biomes.sandyKey);
            boolean isForest = biomeHolder.is(MegaShowdownTags.Biomes.forestKey);
            boolean isTrash = biomeHolder.is(MegaShowdownTags.Biomes.trashKey);
            if (isForest) {
                new StringSpeciesFeature("bagworm_cloak", "plant").apply(pokemon);
                continue;
            }
            if (isSandy) {
                new StringSpeciesFeature("bagworm_cloak", "sandy").apply(pokemon);
                continue;
            }
            if (!isTrash) continue;
            new StringSpeciesFeature("bagworm_cloak", "trash").apply(pokemon);
        }
    }

    public static void revertPokemonsIfRequired(PlayerPartyStore playerPartyStore) {
        for (Pokemon pokemon : playerPartyStore) {
            AspectUtils.revertPokemonsIfRequired(pokemon);
        }
    }

    public static void revertPokemonsIfRequired(Pokemon pokemon) {
        List<EffectPair> aspects;
        if (pokemon.getPersistentData().contains("battle_end_revert")) {
            aspects = AspectUtils.getRevertDataPokemon(pokemon, "battle_end_revert");
            for (EffectPair effectPair : aspects) {
                effectPair.effect.revertEffects(pokemon, effectPair.aspects, null);
            }
            pokemon.getPersistentData().remove("battle_end_revert");
        }
        if (pokemon.getPersistentData().contains("revert_aspects")) {
            aspects = AspectUtils.getRevertDataPokemon(pokemon, "revert_aspects");
            for (EffectPair effectPair : aspects) {
                effectPair.effect.revertEffects(pokemon, effectPair.aspects, null);
            }
            pokemon.getPersistentData().remove("revert_aspects");
        }
        if (pokemon.getPersistentData().contains("apply_aspects")) {
            aspects = AspectUtils.getRevertDataPokemon(pokemon, "apply_aspects");
            for (EffectPair effectPair : aspects) {
                effectPair.effect.revertEffects(pokemon, effectPair.aspects, null);
            }
            pokemon.getPersistentData().remove("apply_aspects");
        }
        if (pokemon.getPersistentData().getBoolean("is_tera")) {
            pokemon.getPersistentData().putBoolean("is_tera", false);
            if (pokemon.getEntity() != null) {
                pokemon.getEntity().removeEffect(MobEffects.GLOWING);
            }
        }
        if (pokemon.getPersistentData().getBoolean("is_max")) {
            pokemon.getPersistentData().putBoolean("is_max", false);
            if (pokemon.getEntity() != null) {
                MaxGimmick.scaleDownDynamax(pokemon.getEntity());
            }
        }
        if (pokemon.getPersistentData().getBoolean("form_changing")) {
            pokemon.getPersistentData().putBoolean("form_changing", false);
        }
    }

    public static void updatePackets(BattlePokemon battlePokemon) {
        Pokemon pokemon = battlePokemon.getEntity().getPokemon();
        PokemonBattle battle = battlePokemon.getActor().getBattle();
        pokemon.updateAspects();
        if (battlePokemon.actor.getType().equals((Object)ActorType.PLAYER)) {
            battle.sendUpdate((NetworkPacket)new AbilityUpdatePacket(() -> ((BattlePokemon)battlePokemon).getEffectedPokemon(), pokemon.getAbility().getTemplate()));
            battle.sendUpdate((NetworkPacket)new BattleUpdateTeamPokemonPacket(pokemon));
        }
        for (ActiveBattlePokemon activeBattlePokemon : battle.getActivePokemon()) {
            if (!battlePokemon.actor.getType().equals((Object)ActorType.PLAYER) || activeBattlePokemon.getBattlePokemon() == null || activeBattlePokemon.getBattlePokemon().getEffectedPokemon().getOwnerPlayer() != battlePokemon.getEffectedPokemon().getOwnerPlayer() || activeBattlePokemon.getBattlePokemon() != battlePokemon) continue;
            battle.sendSidedUpdate(activeBattlePokemon.getActor(), (NetworkPacket)new BattleTransformPokemonPacket(activeBattlePokemon.getPNX(), battlePokemon, true), (NetworkPacket)new BattleTransformPokemonPacket(activeBattlePokemon.getPNX(), battlePokemon, false), false);
        }
    }

    public record EffectPair(Effect effect, List<String> aspects) {
        public static final Codec<EffectPair> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Effect.CODEC.fieldOf("effect").forGetter(EffectPair::effect), (App)Codec.STRING.listOf().fieldOf("aspects").forGetter(EffectPair::aspects)).apply((Applicative)instance, EffectPair::new));
    }
}

