/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.yajatkaul.mega_showdown.commands;

import com.cobblemon.mod.common.Cobblemon;
import com.cobblemon.mod.common.api.pokemon.feature.StringSpeciesFeature;
import com.cobblemon.mod.common.api.storage.party.PlayerPartyStore;
import com.cobblemon.mod.common.api.storage.pc.PCStore;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.cobblemon.yajatkaul.mega_showdown.datamanage.DataManage;
import com.cobblemon.yajatkaul.mega_showdown.datapack.data.FormChangeData;
import com.cobblemon.yajatkaul.mega_showdown.datapack.data.FusionData;
import com.cobblemon.yajatkaul.mega_showdown.datapack.data.HeldItemData;
import com.cobblemon.yajatkaul.mega_showdown.datapack.data.KeyItemData;
import com.cobblemon.yajatkaul.mega_showdown.datapack.data.MegaData;
import com.cobblemon.yajatkaul.mega_showdown.utility.Utils;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomModelData;
import net.minecraft.world.item.component.ItemLore;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.event.RegisterCommandsEvent;

public class MegaCommands {
    public static final List<String> VALID_ITEMS = new ArrayList<String>();

    public static void register(RegisterCommandsEvent event) {
        event.getDispatcher().register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"msdopreset").requires(source -> source.hasPermission(2))).executes(context -> MegaCommands.executeReset((Player)((CommandSourceStack)context.getSource()).getPlayer()))).then(Commands.argument((String)"player", (ArgumentType)EntityArgument.player()).executes(context -> MegaCommands.executeReset((Player)EntityArgument.getPlayer((CommandContext)context, (String)"player")))));
        event.getDispatcher().register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"msdresetlock").requires(source -> source.hasPermission(0))).executes(context -> MegaCommands.executeResetCommon((Player)((CommandSourceStack)context.getSource()).getPlayer())));
        event.getDispatcher().register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"msdresetmega").requires(source -> source.hasPermission(0))).executes(context -> MegaCommands.executeResetMega((Player)((CommandSourceStack)context.getSource()).getPlayer())));
        event.getDispatcher().register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"msd").requires(source -> source.hasPermission(2))).then(Commands.literal((String)"give").then(Commands.argument((String)"player", (ArgumentType)EntityArgument.player()).then(((RequiredArgumentBuilder)Commands.argument((String)"item", (ArgumentType)StringArgumentType.word()).suggests((context, builder) -> {
            for (String item : VALID_ITEMS) {
                builder.suggest(item);
            }
            return builder.buildFuture();
        }).executes(context -> {
            ServerPlayer player = EntityArgument.getPlayer((CommandContext)context, (String)"player");
            String item = StringArgumentType.getString((CommandContext)context, (String)"item");
            return MegaCommands.executeGive(player, item, 1);
        })).then(Commands.argument((String)"count", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(context -> {
            ServerPlayer player = EntityArgument.getPlayer((CommandContext)context, (String)"player");
            String item = StringArgumentType.getString((CommandContext)context, (String)"item");
            int count = IntegerArgumentType.getInteger((CommandContext)context, (String)"count");
            return MegaCommands.executeGive(player, item, count);
        }))))));
    }

    private static int executeGive(ServerPlayer player, String item, int count) {
        for (MegaData pokemon : Utils.megaRegistry) {
            if (!pokemon.msd_id().equals(item)) continue;
            item = pokemon.item_id();
            if (VALID_ITEMS.contains(item)) {
                player.sendSystemMessage((Component)Component.literal((String)("Invalid item: " + item)).withStyle(style -> style.withColor(ChatFormatting.RED)));
                return 0;
            }
            String[] itemId = item.split(":");
            ResourceLocation msdItemId = ResourceLocation.fromNamespaceAndPath((String)itemId[0], (String)itemId[1]);
            Item msdItem = (Item)BuiltInRegistries.ITEM.get(msdItemId);
            ItemStack stack = new ItemStack((ItemLike)msdItem, count);
            stack.set(DataComponents.CUSTOM_MODEL_DATA, (Object)new CustomModelData(pokemon.custom_model_data().intValue()));
            stack.set(DataComponents.CUSTOM_NAME, (Object)Component.translatable((String)pokemon.item_name()));
            ArrayList<MutableComponent> lore = new ArrayList<MutableComponent>();
            for (String line : pokemon.item_description()) {
                lore.add(Component.translatable((String)line));
            }
            stack.set(DataComponents.LORE, (Object)new ItemLore(lore));
            player.addItem(stack);
            player.sendSystemMessage((Component)Component.literal((String)("You received: " + item)).withStyle(style -> style.withColor(ChatFormatting.GREEN)));
            return 1;
        }
        for (Record items : Utils.heldItemsRegistry) {
            if (!((HeldItemData)items).msd_id().equals(item)) continue;
            item = ((HeldItemData)items).item_id();
            if (VALID_ITEMS.contains(item)) {
                player.sendSystemMessage((Component)Component.literal((String)("Invalid item: " + item)).withStyle(style -> style.withColor(ChatFormatting.RED)));
                return 0;
            }
            String[] itemId = item.split(":");
            ResourceLocation msdItemId = ResourceLocation.fromNamespaceAndPath((String)itemId[0], (String)itemId[1]);
            Item msdItem = (Item)BuiltInRegistries.ITEM.get(msdItemId);
            ItemStack stack = new ItemStack((ItemLike)msdItem, count);
            stack.set(DataComponents.CUSTOM_MODEL_DATA, (Object)new CustomModelData(((HeldItemData)items).custom_model_data().intValue()));
            stack.set(DataComponents.CUSTOM_NAME, (Object)Component.translatable((String)((HeldItemData)items).item_name()));
            ArrayList<MutableComponent> lore = new ArrayList<MutableComponent>();
            for (String line : ((HeldItemData)items).item_description()) {
                lore.add(Component.translatable((String)line));
            }
            stack.set(DataComponents.LORE, (Object)new ItemLore(lore));
            player.addItem(stack);
            player.sendSystemMessage((Component)Component.literal((String)("You received: " + item)).withStyle(style -> style.withColor(ChatFormatting.GREEN)));
            return 1;
        }
        for (Record items : Utils.formChangeRegistry) {
            if (!((FormChangeData)items).msd_id().equals(item)) continue;
            item = ((FormChangeData)items).item_id();
            if (VALID_ITEMS.contains(item)) {
                player.sendSystemMessage((Component)Component.literal((String)("Invalid item: " + item)).withStyle(style -> style.withColor(ChatFormatting.RED)));
                return 0;
            }
            String[] itemId = item.split(":");
            ResourceLocation msdItemId = ResourceLocation.fromNamespaceAndPath((String)itemId[0], (String)itemId[1]);
            Item msdItem = (Item)BuiltInRegistries.ITEM.get(msdItemId);
            ItemStack stack = new ItemStack((ItemLike)msdItem, count);
            stack.set(DataComponents.CUSTOM_MODEL_DATA, (Object)new CustomModelData(((FormChangeData)items).custom_model_data().intValue()));
            stack.set(DataComponents.CUSTOM_NAME, (Object)Component.translatable((String)((FormChangeData)items).item_name()));
            ArrayList<MutableComponent> lore = new ArrayList<MutableComponent>();
            for (String line : ((FormChangeData)items).item_description()) {
                lore.add(Component.translatable((String)line));
            }
            stack.set(DataComponents.LORE, (Object)new ItemLore(lore));
            player.addItem(stack);
            player.sendSystemMessage((Component)Component.literal((String)("You received: " + item)).withStyle(style -> style.withColor(ChatFormatting.GREEN)));
            return 1;
        }
        for (FusionData fusion : Utils.fusionRegistry) {
            if (!fusion.msd_id().equals(item)) continue;
            item = fusion.item_id();
            if (VALID_ITEMS.contains(item)) {
                player.sendSystemMessage((Component)Component.literal((String)("Invalid item: " + item)).withStyle(style -> style.withColor(ChatFormatting.RED)));
                return 0;
            }
            String[] itemId = item.split(":");
            ResourceLocation msdItemId = ResourceLocation.fromNamespaceAndPath((String)itemId[0], (String)itemId[1]);
            Item msdItem = (Item)BuiltInRegistries.ITEM.get(msdItemId);
            ItemStack stack = new ItemStack((ItemLike)msdItem, count);
            stack.set(DataComponents.CUSTOM_MODEL_DATA, (Object)new CustomModelData(fusion.custom_model_data()));
            stack.set(DataComponents.CUSTOM_NAME, (Object)Component.translatable((String)fusion.item_name()));
            ArrayList<MutableComponent> lore = new ArrayList<MutableComponent>();
            for (String line : fusion.item_description()) {
                lore.add(Component.translatable((String)line));
            }
            stack.set(DataComponents.LORE, (Object)new ItemLore(lore));
            player.addItem(stack);
            player.sendSystemMessage((Component)Component.literal((String)("You received: " + item)).withStyle(style -> style.withColor(ChatFormatting.GREEN)));
            return 1;
        }
        for (KeyItemData keyItems : Utils.keyItemsRegistry) {
            if (!keyItems.msd_id().equals(item)) continue;
            item = keyItems.item_id();
            if (VALID_ITEMS.contains(item)) {
                player.sendSystemMessage((Component)Component.literal((String)("Invalid item: " + item)).withStyle(style -> style.withColor(ChatFormatting.RED)));
                return 0;
            }
            String[] itemId = item.split(":");
            ResourceLocation msdItemId = ResourceLocation.fromNamespaceAndPath((String)itemId[0], (String)itemId[1]);
            Item msdItem = (Item)BuiltInRegistries.ITEM.get(msdItemId);
            ItemStack stack = new ItemStack((ItemLike)msdItem, count);
            stack.set(DataComponents.CUSTOM_MODEL_DATA, (Object)new CustomModelData(keyItems.custom_model_data().intValue()));
            stack.set(DataComponents.CUSTOM_NAME, (Object)Component.translatable((String)keyItems.item_name()));
            ArrayList<MutableComponent> lore = new ArrayList<MutableComponent>();
            for (String line : keyItems.item_description()) {
                lore.add(Component.translatable((String)line));
            }
            stack.set(DataComponents.LORE, (Object)new ItemLore(lore));
            player.addItem(stack);
            player.sendSystemMessage((Component)Component.literal((String)("You received: " + item)).withStyle(style -> style.withColor(ChatFormatting.GREEN)));
            return 1;
        }
        return 0;
    }

    private static int reloadCustomConfig(CommandSourceStack source) {
        source.getServer().reloadableRegistries();
        Utils.registryLoader(source.registryAccess());
        return 1;
    }

    private static int executeReset(Player player) {
        player.removeData(DataManage.MEGA_DATA);
        player.removeData(DataManage.MEGA_POKEMON);
        player.removeData(DataManage.PRIMAL_DATA);
        player.removeData(DataManage.PRIMAL_POKEMON);
        player.sendSystemMessage((Component)Component.translatable((String)"message.mega_showdown.reset_completed"));
        return 1;
    }

    private static int executeResetCommon(Player player) {
        player.removeData(DataManage.MEGA_DATA);
        player.removeData(DataManage.MEGA_POKEMON);
        player.removeData(DataManage.PRIMAL_DATA);
        player.removeData(DataManage.PRIMAL_POKEMON);
        PCStore storge = Cobblemon.INSTANCE.getStorage().getPC((ServerPlayer)player);
        PlayerPartyStore party = Cobblemon.INSTANCE.getStorage().getParty((ServerPlayer)player);
        for (Pokemon pokemon : storge) {
            if (pokemon.getAspects().contains("mega") || pokemon.getAspects().contains("mega_y") || pokemon.getAspects().contains("mega_x")) {
                new StringSpeciesFeature("mega_evolution", "none").apply(pokemon);
            }
            if (!pokemon.getAspects().contains("primal")) continue;
            new StringSpeciesFeature("reversion_state", "standard").apply(pokemon);
        }
        for (Pokemon pokemon : party) {
            if (pokemon.getAspects().contains("mega") || pokemon.getAspects().contains("mega_y") || pokemon.getAspects().contains("mega_x")) {
                new StringSpeciesFeature("mega_evolution", "none").apply(pokemon);
            }
            if (!pokemon.getAspects().contains("primal")) continue;
            new StringSpeciesFeature("reversion_state", "standard").apply(pokemon);
        }
        player.sendSystemMessage((Component)Component.translatable((String)"message.mega_showdown.reset_completed"));
        return 1;
    }

    private static int executeResetMega(Player player) {
        player.removeData(DataManage.MEGA_DATA);
        player.removeData(DataManage.MEGA_POKEMON);
        PCStore storge = Cobblemon.INSTANCE.getStorage().getPC((ServerPlayer)player);
        PlayerPartyStore party = Cobblemon.INSTANCE.getStorage().getParty((ServerPlayer)player);
        for (Pokemon pokemon : storge) {
            if (!pokemon.getAspects().contains("mega") && !pokemon.getAspects().contains("mega_y") && !pokemon.getAspects().contains("mega_x")) continue;
            new StringSpeciesFeature("mega_evolution", "none").apply(pokemon);
        }
        for (Pokemon pokemon : party) {
            if (!pokemon.getAspects().contains("mega") && !pokemon.getAspects().contains("mega_y") && !pokemon.getAspects().contains("mega_x")) continue;
            new StringSpeciesFeature("mega_evolution", "none").apply(pokemon);
        }
        return 1;
    }
}

