/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.yajatkaul.mega_showdown.datapack.showdown;

import com.cobblemon.mod.common.Cobblemon;
import com.cobblemon.mod.common.api.Priority;
import com.cobblemon.mod.common.api.data.DataRegistry;
import com.cobblemon.mod.common.api.reactive.SimpleObservable;
import com.cobblemon.mod.common.battles.runner.graal.GraalShowdownService;
import com.cobblemon.mod.relocations.graalvm.polyglot.Value;
import com.cobblemon.yajatkaul.mega_showdown.MegaShowdown;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import kotlin.Unit;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.resources.ResourceManager;
import org.jetbrains.annotations.NotNull;

public class Conditions
implements DataRegistry {
    private static final ResourceLocation ID = ResourceLocation.fromNamespaceAndPath((String)"mega_showdown", (String)"showdown/conditions");
    private static final SimpleObservable<Conditions> OBSERVABLE = new SimpleObservable();
    public static final Conditions INSTANCE = new Conditions();
    private final Map<String, String> conditionScripts = new HashMap<String, String>();

    private Conditions() {
        OBSERVABLE.subscribe(Priority.NORMAL, this::conditionsLoad);
    }

    private Unit conditionsLoad(Conditions condition) {
        Cobblemon.INSTANCE.getShowdownThread().queue(showdownService -> {
            if (showdownService instanceof GraalShowdownService) {
                GraalShowdownService service = (GraalShowdownService)showdownService;
                Value receiveConditionDataFn = service.context.getBindings("js").getMember("receiveConditionData");
                for (Map.Entry<String, String> entry : INSTANCE.getConditionScripts().entrySet()) {
                    String conditionId = entry.getKey();
                    String js = entry.getValue().replace("\n", " ");
                    receiveConditionDataFn.execute(new Object[]{conditionId, js});
                }
            }
            return Unit.INSTANCE;
        });
        return Unit.INSTANCE;
    }

    public Map<String, String> getConditionScripts() {
        return this.conditionScripts;
    }

    @NotNull
    public ResourceLocation getId() {
        return ID;
    }

    @NotNull
    public PackType getType() {
        return PackType.SERVER_DATA;
    }

    @NotNull
    public SimpleObservable<? extends DataRegistry> getObservable() {
        return OBSERVABLE;
    }

    public void reload(@NotNull ResourceManager resourceManager) {
        this.conditionScripts.clear();
        resourceManager.listResources("showdown/conditions", path -> path.getPath().endsWith(".js")).forEach((id, resource) -> {
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(resource.open(), StandardCharsets.UTF_8));){
                String js = reader.lines().collect(Collectors.joining("\n"));
                String conditionId = new File(id.getPath()).getName().replace(".js", "");
                this.conditionScripts.put(conditionId, js);
            }
            catch (IOException e) {
                MegaShowdown.LOGGER.error("Failed to load condition script: {} {}", id, (Object)e);
            }
        });
        OBSERVABLE.emit((Object[])new Conditions[]{this});
    }

    public void sync(@NotNull ServerPlayer serverPlayer) {
    }
}

