/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.yajatkaul.mega_showdown.event.cobbleEvents;

import com.cobblemon.mod.common.api.battles.model.PokemonBattle;
import com.cobblemon.mod.common.api.battles.model.actor.ActorType;
import com.cobblemon.mod.common.api.drop.ItemDropEntry;
import com.cobblemon.mod.common.api.events.battles.instruction.FormeChangeEvent;
import com.cobblemon.mod.common.api.events.battles.instruction.MegaEvolutionEvent;
import com.cobblemon.mod.common.api.events.battles.instruction.TerastallizationEvent;
import com.cobblemon.mod.common.api.events.battles.instruction.ZMoveUsedEvent;
import com.cobblemon.mod.common.api.events.drops.LootDroppedEvent;
import com.cobblemon.mod.common.api.events.pokemon.HeldItemEvent;
import com.cobblemon.mod.common.api.events.pokemon.PokemonCapturedEvent;
import com.cobblemon.mod.common.api.events.pokemon.PokemonSentPostEvent;
import com.cobblemon.mod.common.api.events.pokemon.healing.PokemonHealedEvent;
import com.cobblemon.mod.common.api.events.storage.ReleasePokemonEvent;
import com.cobblemon.mod.common.api.net.NetworkPacket;
import com.cobblemon.mod.common.api.pokemon.feature.FlagSpeciesFeature;
import com.cobblemon.mod.common.api.pokemon.feature.StringSpeciesFeature;
import com.cobblemon.mod.common.api.types.tera.TeraType;
import com.cobblemon.mod.common.api.types.tera.TeraTypes;
import com.cobblemon.mod.common.battles.ActiveBattlePokemon;
import com.cobblemon.mod.common.battles.pokemon.BattlePokemon;
import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import com.cobblemon.mod.common.net.messages.client.battle.BattleTransformPokemonPacket;
import com.cobblemon.mod.common.net.messages.client.battle.BattleUpdateTeamPokemonPacket;
import com.cobblemon.mod.common.net.messages.client.pokemon.update.AbilityUpdatePacket;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.cobblemon.yajatkaul.mega_showdown.advancement.AdvancementHelper;
import com.cobblemon.yajatkaul.mega_showdown.config.MegaShowdownConfig;
import com.cobblemon.yajatkaul.mega_showdown.datamanage.DataManage;
import com.cobblemon.yajatkaul.mega_showdown.datamanage.PokeHandler;
import com.cobblemon.yajatkaul.mega_showdown.datapack.data.FormChangeData;
import com.cobblemon.yajatkaul.mega_showdown.event.cobbleEvents.EventUtils;
import com.cobblemon.yajatkaul.mega_showdown.event.cobbleEvents.HeldItemChangeFormes;
import com.cobblemon.yajatkaul.mega_showdown.item.TeraMoves;
import com.cobblemon.yajatkaul.mega_showdown.item.configActions.ConfigResults;
import com.cobblemon.yajatkaul.mega_showdown.item.custom.TeraItem;
import com.cobblemon.yajatkaul.mega_showdown.megaevo.MegaLogic;
import com.cobblemon.yajatkaul.mega_showdown.sound.ModSounds;
import com.cobblemon.yajatkaul.mega_showdown.utility.LazyLib;
import com.cobblemon.yajatkaul.mega_showdown.utility.TeraAccessor;
import com.cobblemon.yajatkaul.mega_showdown.utility.TeraTypeHelper;
import com.cobblemon.yajatkaul.mega_showdown.utility.Utils;
import java.util.Random;
import java.util.UUID;
import kotlin.Unit;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.server.ServerScoreboard;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.scores.PlayerTeam;
import net.neoforged.neoforge.registries.DeferredItem;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotResult;

public class CobbleEventsHandler {
    public static Unit onHeldItemChange(HeldItemEvent.Post event) {
        if (event.getReturned() == event.getReceived() || event.getPokemon().getOwnerPlayer() == null) {
            return Unit.INSTANCE;
        }
        HeldItemChangeFormes.genesectChange(event);
        HeldItemChangeFormes.silvallyChange(event);
        HeldItemChangeFormes.arcuesChange(event);
        HeldItemChangeFormes.ultraEvent(event);
        HeldItemChangeFormes.crownedEvent(event);
        HeldItemChangeFormes.ogerponChange(event);
        HeldItemChangeFormes.eternamaxChange(event);
        HeldItemChangeFormes.originChange(event);
        HeldItemChangeFormes.customEvents(event);
        if (MegaShowdownConfig.battleModeOnly) {
            return Unit.INSTANCE;
        }
        HeldItemChangeFormes.megaEvent(event);
        return Unit.INSTANCE;
    }

    public static Unit onHeldItemChangePrimals(HeldItemEvent.Pre event) {
        if (event.getReceiving() == event.getReturning() || event.getPokemon().getOwnerPlayer() == null) {
            return Unit.INSTANCE;
        }
        PokemonEntity pokemonEntity = event.getPokemon().getEntity();
        if (pokemonEntity != null && ((Boolean)pokemonEntity.getEntityData().get(PokemonEntity.getEVOLUTION_STARTED())).booleanValue()) {
            event.cancel();
            return Unit.INSTANCE;
        }
        HeldItemChangeFormes.primalEvent(event);
        return Unit.INSTANCE;
    }

    public static Unit onReleasePokemon(ReleasePokemonEvent.Post post) {
        Pokemon released = post.getPokemon();
        ServerPlayer player = post.getPlayer();
        if (((PokeHandler)player.getData(DataManage.MEGA_POKEMON)).getPokemon() == released) {
            player.setData(DataManage.MEGA_DATA, (Object)false);
            player.removeData(DataManage.MEGA_POKEMON);
        }
        if (((PokeHandler)player.getData(DataManage.PRIMAL_POKEMON)).getPokemon() == released) {
            player.setData(DataManage.PRIMAL_DATA, (Object)false);
            player.removeData(DataManage.PRIMAL_POKEMON);
        }
        return Unit.INSTANCE;
    }

    public static Unit megaEvolution(MegaEvolutionEvent megaEvolutionEvent) {
        PokemonBattle battle = megaEvolutionEvent.getBattle();
        Pokemon pokemon = megaEvolutionEvent.getPokemon().getEffectedPokemon();
        battle.dispatchWaitingToFront(5.9f, () -> Unit.INSTANCE);
        if (pokemon.getOwnerPlayer() == null) {
            MegaLogic.NPCEvolve(pokemon.getEntity(), megaEvolutionEvent.getPokemon(), battle);
        } else {
            MegaLogic.Evolve(pokemon.getEntity(), (Player)pokemon.getOwnerPlayer(), megaEvolutionEvent.getPokemon(), battle);
        }
        return Unit.INSTANCE;
    }

    public static Unit zMovesUsed(ZMoveUsedEvent zMoveUsedEvent) {
        PokemonEntity pokemon = zMoveUsedEvent.getPokemon().getEffectedPokemon().getEntity();
        Pokemon pk = zMoveUsedEvent.getPokemon().getEffectedPokemon();
        AdvancementHelper.grantAdvancement(pk.getOwnerPlayer(), "z/z_moves");
        if (pk.getSpecies().getName().equals("Pikachu") && pk.getAspects().contains("partner-cap")) {
            AdvancementHelper.grantAdvancement(pk.getOwnerPlayer(), "bond/ash_pikachu");
        }
        pokemon.addEffect(new MobEffectInstance(MobEffects.GLOWING, 140, 0, false, false));
        Level level = pokemon.level();
        if (level instanceof ServerLevel) {
            String teamName;
            ServerLevel serverLevel = (ServerLevel)level;
            ServerScoreboard scoreboard = serverLevel.getScoreboard();
            PlayerTeam team = scoreboard.getPlayerTeam(teamName = "glow_" + UUID.randomUUID().toString().substring(0, 8));
            if (team == null) {
                team = scoreboard.addPlayerTeam(teamName);
                team.setColor(TeraTypeHelper.getGlowColorForType(pk.getHeldItem$common()));
                team.setSeeFriendlyInvisibles(false);
                team.setAllowFriendlyFire(true);
            }
            scoreboard.addPlayerToTeam(pokemon.getScoreboardName(), team);
        }
        LazyLib.Companion.snowStormPartileSpawner((Entity)pk.getEntity(), "z_moves", "target");
        BlockPos entityPos = pokemon.getOnPos();
        pokemon.level().playSound(null, (double)entityPos.getX(), (double)entityPos.getY(), (double)entityPos.getZ(), ModSounds.ZMOVE.get(), SoundSource.PLAYERS, 0.2f, 0.7f);
        zMoveUsedEvent.getBattle().dispatchWaitingToFront(4.0f, () -> Unit.INSTANCE);
        pk.getEntity().after(2.5f, () -> {
            LazyLib.Companion.cryAnimation((Entity)pk.getEntity());
            return Unit.INSTANCE;
        });
        return Unit.INSTANCE;
    }

    public static Unit terrastallizationUsed(TerastallizationEvent terastallizationEvent) {
        PokemonEntity pokemon = terastallizationEvent.getPokemon().getEffectedPokemon().getEntity();
        Pokemon pk = terastallizationEvent.getPokemon().getEffectedPokemon();
        Vec3 entityPos = pokemon.position();
        AdvancementHelper.grantAdvancement(pk.getOwnerPlayer(), "tera/terastallized");
        pokemon.level().playSound(null, entityPos.x, entityPos.y, entityPos.z, ModSounds.TERASTALLIZATION.get(), SoundSource.PLAYERS, 0.4f, 1.0f);
        if (pk.getSpecies().getName().equals("Terapagos")) {
            new StringSpeciesFeature("tera_form", "stellar").apply(pk);
            CobbleEventsHandler.updatePackets(terastallizationEvent.getBattle(), terastallizationEvent.getPokemon(), false);
            EventUtils.playEvolveAnimation((LivingEntity)pokemon);
        } else if (pk.getSpecies().getName().equals("Ogerpon")) {
            new FlagSpeciesFeature("embody-aspect", true).apply(pk);
            CobbleEventsHandler.updatePackets(terastallizationEvent.getBattle(), terastallizationEvent.getPokemon(), false);
        }
        if (pk instanceof TeraAccessor) {
            TeraAccessor accessor = (TeraAccessor)pk;
            accessor.setTeraEnabled(true);
        }
        pokemon.addEffect(new MobEffectInstance(MobEffects.GLOWING, Integer.MAX_VALUE, 0, false, false));
        Level level = pokemon.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            ServerScoreboard scoreboard = serverLevel.getScoreboard();
            String teamName = "glow_" + UUID.randomUUID().toString().substring(0, 8);
            PlayerTeam team = scoreboard.getPlayerTeam(teamName);
            TeraType teraType = terastallizationEvent.getPokemon().getEffectedPokemon().getTeraType();
            ChatFormatting color = TeraTypeHelper.getGlowColorForTeraType(teraType);
            if (team == null) {
                team = scoreboard.addPlayerTeam(teamName);
                team.setColor(color);
                team.setSeeFriendlyInvisibles(false);
                team.setAllowFriendlyFire(true);
            }
            scoreboard.addPlayerToTeam(pokemon.getScoreboardName(), team);
        }
        ServerPlayer player = terastallizationEvent.getPokemon().getEffectedPokemon().getOwnerPlayer();
        CuriosApi.getCuriosInventory((LivingEntity)player).flatMap(curiosInventory -> curiosInventory.findFirstCurio(stack -> stack.getItem() instanceof TeraItem)).map(SlotResult::stack).ifPresent(teraOrb -> teraOrb.setDamageValue(teraOrb.getDamageValue() + 10));
        terastallizationEvent.getBattle().dispatchWaitingToFront(3.0f, () -> CobbleEventsHandler.lambda$terrastallizationUsed$6((LivingEntity)pokemon));
        return Unit.INSTANCE;
    }

    public static Unit healedPokemons(PokemonHealedEvent pokemonHealedEvent) {
        if (pokemonHealedEvent.getPokemon().getOwnerPlayer() == null) {
            return Unit.INSTANCE;
        }
        ItemStack teraOrb = CuriosApi.getCuriosInventory((LivingEntity)pokemonHealedEvent.getPokemon().getOwnerPlayer()).flatMap(curiosInventory -> curiosInventory.findFirstCurio(stack -> stack.getItem() instanceof TeraItem)).map(SlotResult::stack).orElse(null);
        if (teraOrb != null) {
            teraOrb.setDamageValue(0);
        }
        return Unit.INSTANCE;
    }

    public static Unit dropShardPokemon(LootDroppedEvent lootDroppedEvent) {
        if (!MegaShowdownConfig.teralization || MegaShowdownConfig.disableTeraShardDrop || !(lootDroppedEvent.getEntity() instanceof PokemonEntity)) {
            return Unit.INSTANCE;
        }
        Pokemon pokemon = ((PokemonEntity)lootDroppedEvent.getEntity()).getPokemon();
        DeferredItem<Item> correspondingTeraShard = TeraTypeHelper.getTeraShardForType(pokemon.getTypes());
        ItemDropEntry teraShardDropEntry = new ItemDropEntry();
        teraShardDropEntry.setItem(BuiltInRegistries.ITEM.getKey((Object)((Item)correspondingTeraShard.get())));
        int randomValue = new Random().nextInt(101);
        if (randomValue >= 10 && randomValue <= 20) {
            lootDroppedEvent.getDrops().add(teraShardDropEntry);
        } else if (randomValue == 33) {
            teraShardDropEntry.setItem(BuiltInRegistries.ITEM.getKey((Object)((Item)TeraMoves.STELLAR_TERA_SHARD.get())));
            lootDroppedEvent.getDrops().add(teraShardDropEntry);
        }
        return Unit.INSTANCE;
    }

    public static Unit formeChanges(FormeChangeEvent formeChangeEvent) {
        if (formeChangeEvent.getFormeName().equals("x") || formeChangeEvent.getFormeName().equals("y") || formeChangeEvent.getFormeName().equals("mega") || formeChangeEvent.getFormeName().equals("tera")) {
            return Unit.INSTANCE;
        }
        Pokemon pokemon = formeChangeEvent.getPokemon().getEffectedPokemon();
        PokemonBattle battle = formeChangeEvent.getBattle();
        PokemonEntity pokemonEntity = pokemon.getEntity();
        BlockPos entityPos = pokemonEntity.getOnPos();
        switch (pokemon.getSpecies().getName()) {
            case "Aegislash": {
                if (formeChangeEvent.getFormeName().equals("blade")) {
                    new StringSpeciesFeature("stance_forme", "blade").apply(pokemon);
                    break;
                }
                if (!formeChangeEvent.getFormeName().equals("aegislash")) break;
                new StringSpeciesFeature("stance_forme", "shield").apply(pokemon);
                break;
            }
            case "Minior": {
                if (formeChangeEvent.getFormeName().equals("meteor")) {
                    EventUtils.playFormeChangeAnimation((LivingEntity)pokemon.getEntity());
                    new StringSpeciesFeature("meteor_shield", "meteor").apply(pokemon);
                    break;
                }
                EventUtils.playFormeChangeAnimation((LivingEntity)pokemon.getEntity());
                new StringSpeciesFeature("meteor_shield", "core").apply(pokemon);
                break;
            }
            case "Castform": {
                switch (formeChangeEvent.getFormeName()) {
                    case "sunny": {
                        EventUtils.playFormeChangeAnimation((LivingEntity)pokemon.getEntity());
                        new StringSpeciesFeature("forecast_form", "sunny").apply(pokemon);
                        break;
                    }
                    case "rainy": {
                        EventUtils.playFormeChangeAnimation((LivingEntity)pokemon.getEntity());
                        new StringSpeciesFeature("forecast_form", "rainy").apply(pokemon);
                        break;
                    }
                    case "snowy": {
                        EventUtils.playFormeChangeAnimation((LivingEntity)pokemon.getEntity());
                        new StringSpeciesFeature("forecast_form", "snowy").apply(pokemon);
                    }
                }
                break;
            }
            case "Wishiwashi": {
                if (formeChangeEvent.getFormeName().equals("school")) {
                    battle.dispatchWaitingToFront(4.5f, () -> {
                        LazyLib.Companion.snowStormPartileSpawner((Entity)pokemonEntity, "wishiwashi_effect", "target");
                        pokemonEntity.level().playSound(null, (double)entityPos.getX(), (double)entityPos.getY(), (double)entityPos.getZ(), ModSounds.FORM_CHANGE_BASIC.get(), SoundSource.PLAYERS, 0.2f, 1.3f);
                        return Unit.INSTANCE;
                    });
                    pokemonEntity.after(5.0f, () -> {
                        new StringSpeciesFeature("schooling_form", "school").apply(pokemon);
                        LazyLib.Companion.cryAnimation((Entity)pokemon.getEntity());
                        CobbleEventsHandler.updatePackets(formeChangeEvent.getBattle(), formeChangeEvent.getPokemon(), false);
                        return Unit.INSTANCE;
                    });
                    break;
                }
                if (!formeChangeEvent.getFormeName().equals("wishiwashi")) break;
                new StringSpeciesFeature("schooling_form", "solo").apply(pokemon);
                EventUtils.playFormeChangeAnimation((LivingEntity)pokemon.getEntity());
                break;
            }
            case "Mimikyu": {
                if (!formeChangeEvent.getFormeName().equals("busted")) break;
                new StringSpeciesFeature("disguise_form", "busted").apply(pokemon);
                break;
            }
            case "Greninja": {
                if (formeChangeEvent.getFormeName().equals("ash")) {
                    pokemonEntity.level().playSound(null, (double)entityPos.getX(), (double)entityPos.getY(), (double)entityPos.getZ(), ModSounds.FORM_CHANGE_BASIC.get(), SoundSource.PLAYERS, 0.2f, 1.3f);
                    battle.dispatchWaitingToFront(4.5f, () -> {
                        LazyLib.Companion.snowStormPartileSpawner((Entity)pokemonEntity, "battlebond_effect", "root");
                        return Unit.INSTANCE;
                    });
                    pokemonEntity.after(4.0f, () -> {
                        new StringSpeciesFeature("battle_bond", "ash").apply(pokemon);
                        LazyLib.Companion.cryAnimation((Entity)pokemon.getEntity());
                        CobbleEventsHandler.updatePackets(formeChangeEvent.getBattle(), formeChangeEvent.getPokemon(), false);
                        return Unit.INSTANCE;
                    });
                    AdvancementHelper.grantAdvancement(pokemon.getOwnerPlayer(), "bond/ash_greninja");
                    break;
                }
                AdvancementHelper.grantAdvancement(pokemon.getOwnerPlayer(), "bond/ash_battle_bond");
                break;
            }
            case "Cherrim": {
                if (formeChangeEvent.getFormeName().equals("sunshine")) {
                    EventUtils.playFormeChangeAnimation((LivingEntity)pokemon.getEntity());
                    new StringSpeciesFeature("blossom_form", "sunshine").apply(pokemon);
                    break;
                }
                EventUtils.playFormeChangeAnimation((LivingEntity)pokemon.getEntity());
                new StringSpeciesFeature("blossom_form", "overcast").apply(pokemon);
                break;
            }
            case "Palafin": {
                if (!formeChangeEvent.getFormeName().equals("hero")) break;
                EventUtils.playFormeChangeAnimation((LivingEntity)pokemon.getEntity());
                new StringSpeciesFeature("dolphin_form", "hero").apply(pokemon);
                break;
            }
            case "Morpeko": {
                if (!formeChangeEvent.getFormeName().equals("hangry")) break;
                EventUtils.playFormeChangeAngryAnimation((LivingEntity)pokemon.getEntity());
                new StringSpeciesFeature("hunger_mode", "hangry").apply(pokemon);
                break;
            }
            case "Eiscue": {
                if (formeChangeEvent.getFormeName().equals("noice")) {
                    EventUtils.playFormeChangeAnimation((LivingEntity)pokemon.getEntity());
                    new StringSpeciesFeature("penguin_head", "noice_face").apply(pokemon);
                    break;
                }
                EventUtils.playFormeChangeAnimation((LivingEntity)pokemon.getEntity());
                new StringSpeciesFeature("penguin_head", "ice_face").apply(pokemon);
                break;
            }
            case "Cramorant": {
                switch (formeChangeEvent.getFormeName()) {
                    case "gulping": {
                        EventUtils.playFormeChangeAnimation((LivingEntity)pokemon.getEntity());
                        new StringSpeciesFeature("missile_form", "gulping").apply(pokemon);
                        break;
                    }
                    case "cramorant": {
                        EventUtils.playFormeChangeAnimation((LivingEntity)pokemon.getEntity());
                        new StringSpeciesFeature("missile_form", "none").apply(pokemon);
                        break;
                    }
                    case "gorging": {
                        EventUtils.playFormeChangeAnimation((LivingEntity)pokemon.getEntity());
                        new StringSpeciesFeature("missile_form", "gorging").apply(pokemon);
                    }
                }
                break;
            }
            case "Darmanitan": {
                if (formeChangeEvent.getFormeName().equals("zen")) {
                    EventUtils.playFormeChangeAnimation((LivingEntity)pokemon.getEntity());
                    new StringSpeciesFeature("blazing_mode", "zen").apply(pokemon);
                    break;
                }
                EventUtils.playFormeChangeAnimation((LivingEntity)pokemon.getEntity());
                new StringSpeciesFeature("blazing_mode", "standard").apply(pokemon);
                break;
            }
            case "Arceus": {
                battle.dispatchWaitingToFront(4.5f, () -> {
                    LazyLib.Companion.snowStormPartileSpawner((Entity)pokemonEntity, "arceus_" + formeChangeEvent.getFormeName(), "target");
                    pokemonEntity.level().playSound(null, (double)entityPos.getX(), (double)entityPos.getY(), (double)entityPos.getZ(), ModSounds.ARCEUS_MULTITYPE.get(), SoundSource.PLAYERS, 0.2f, 1.3f);
                    return Unit.INSTANCE;
                });
                pokemonEntity.after(4.0f, () -> {
                    new StringSpeciesFeature("multitype", formeChangeEvent.getFormeName()).apply(pokemon);
                    LazyLib.Companion.cryAnimation((Entity)pokemon.getEntity());
                    CobbleEventsHandler.updatePackets(formeChangeEvent.getBattle(), formeChangeEvent.getPokemon(), false);
                    return Unit.INSTANCE;
                });
                break;
            }
            case "Xerneas": {
                if (!formeChangeEvent.getFormeName().equals("active")) break;
                EventUtils.playFormeChangeAnimation((LivingEntity)pokemon.getEntity());
                new StringSpeciesFeature("life_mode", "active").apply(pokemon);
                break;
            }
            case "Terapagos": {
                if (!formeChangeEvent.getFormeName().equals("terastal")) break;
                battle.dispatchWaitingToFront(4.5f, () -> {
                    LazyLib.Companion.snowStormPartileSpawner((Entity)pokemonEntity, "terapagos_effect", "target");
                    pokemonEntity.level().playSound(null, (double)entityPos.getX(), (double)entityPos.getY(), (double)entityPos.getZ(), ModSounds.FORM_CHANGE_BASIC.get(), SoundSource.PLAYERS, 0.2f, 2.1f);
                    return Unit.INSTANCE;
                });
                pokemonEntity.after(3.9f, () -> {
                    new StringSpeciesFeature("tera_form", "terastal").apply(pokemon);
                    LazyLib.Companion.cryAnimation((Entity)pokemon.getEntity());
                    CobbleEventsHandler.updatePackets(formeChangeEvent.getBattle(), formeChangeEvent.getPokemon(), false);
                    return Unit.INSTANCE;
                });
                break;
            }
            case "Meloetta": {
                if (formeChangeEvent.getFormeName().equals("pirouette")) {
                    new StringSpeciesFeature("song_forme", "pirouette").apply(pokemon);
                    EventUtils.playEvolveAnimation((LivingEntity)pokemon.getEntity());
                    break;
                }
                new StringSpeciesFeature("song_forme", "aria").apply(pokemon);
                break;
            }
            case "Zygarde": {
                if (!formeChangeEvent.getFormeName().equals("complete")) break;
                pokemonEntity.level().playSound(null, (double)entityPos.getX(), (double)entityPos.getY(), (double)entityPos.getZ(), ModSounds.POWER_CONSTRUCT.get(), SoundSource.PLAYERS, 0.2f, 0.8f);
                battle.dispatchWaitingToFront(4.5f, () -> {
                    LazyLib.Companion.snowStormPartileSpawner((Entity)pokemonEntity, "power_construct_event", "root");
                    return Unit.INSTANCE;
                });
                pokemonEntity.after(4.0f, () -> {
                    new FlagSpeciesFeature("complete-percent", true).apply(pokemon);
                    LazyLib.Companion.cryAnimation((Entity)pokemon.getEntity());
                    CobbleEventsHandler.updatePackets(formeChangeEvent.getBattle(), formeChangeEvent.getPokemon(), false);
                    return Unit.INSTANCE;
                });
                break;
            }
            case "Shaymin": {
                if (!formeChangeEvent.getFormeName().equals("shaymin")) break;
                new StringSpeciesFeature("gracidea_forme", "land").apply(pokemon);
                EventUtils.playEvolveAnimation((LivingEntity)pokemon.getEntity());
            }
        }
        for (FormChangeData forme : Utils.formChangeRegistry) {
            if (!forme.battle_mode_only().booleanValue() || !forme.pokemons().contains(formeChangeEvent.getPokemon().getEffectedPokemon().getSpecies().getName()) || !formeChangeEvent.getFormeName().equals(forme.form_name())) continue;
            for (String aspects : forme.aspects()) {
                String[] aspectsDiv = aspects.split("=");
                if (aspectsDiv[1].equals("true") || aspectsDiv[1].equals("false")) {
                    new FlagSpeciesFeature(aspectsDiv[0], Boolean.parseBoolean(aspectsDiv[1])).apply(pokemon);
                    continue;
                }
                new StringSpeciesFeature(aspectsDiv[0], aspectsDiv[1]).apply(pokemon);
            }
            ConfigResults.particleEffect((LivingEntity)pokemon.getEntity(), forme.effects(), true);
            break;
        }
        CobbleEventsHandler.updatePackets(battle, formeChangeEvent.getPokemon(), false);
        return Unit.INSTANCE;
    }

    public static Unit fixTera(PokemonCapturedEvent pokemonCapturedEvent) {
        Pokemon pokemon = pokemonCapturedEvent.getPokemon();
        if (pokemon.getSpecies().getName().equals("Ogerpon")) {
            pokemon.setTeraType(TeraTypes.getGRASS());
        } else if (pokemon.getSpecies().getName().equals("Terapagos")) {
            pokemon.setTeraType(TeraTypes.getSTELLAR());
        }
        return Unit.INSTANCE;
    }

    public static Unit pokemonSent(PokemonSentPostEvent pokemonSentPostEvent) {
        TeraAccessor accessor;
        PokemonEntity pokemon = pokemonSentPostEvent.getPokemonEntity();
        Pokemon pk = pokemonSentPostEvent.getPokemon();
        if (pk instanceof TeraAccessor && (accessor = (TeraAccessor)pk).isTeraEnabled()) {
            pokemon.addEffect(new MobEffectInstance(MobEffects.GLOWING, Integer.MAX_VALUE, 0, false, false));
            Level level = pokemon.level();
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                ServerScoreboard scoreboard = serverLevel.getScoreboard();
                String teamName = "glow_" + UUID.randomUUID().toString().substring(0, 8);
                PlayerTeam team = scoreboard.getPlayerTeam(teamName);
                TeraType teraType = pk.getTeraType();
                ChatFormatting color = TeraTypeHelper.getGlowColorForTeraType(teraType);
                if (team == null) {
                    team = scoreboard.addPlayerTeam(teamName);
                    team.setColor(color);
                    team.setSeeFriendlyInvisibles(false);
                    team.setAllowFriendlyFire(true);
                }
                scoreboard.addPlayerToTeam(pokemon.getScoreboardName(), team);
            }
        }
        return Unit.INSTANCE;
    }

    public static void updatePackets(PokemonBattle battle, BattlePokemon pk, boolean abilities) {
        Pokemon pokemon = pk.getEntity().getPokemon();
        if (abilities && pk.actor.getType().equals((Object)ActorType.PLAYER)) {
            battle.sendUpdate((NetworkPacket)new AbilityUpdatePacket(() -> ((BattlePokemon)pk).getEffectedPokemon(), pokemon.getAbility().getTemplate()));
            battle.sendUpdate((NetworkPacket)new BattleUpdateTeamPokemonPacket(pokemon));
        }
        for (ActiveBattlePokemon activeBattlePokemon : battle.getActivePokemon()) {
            if (!pk.actor.getType().equals((Object)ActorType.PLAYER) || activeBattlePokemon.getBattlePokemon() == null || activeBattlePokemon.getBattlePokemon().getEffectedPokemon().getOwnerPlayer() != pk.getEffectedPokemon().getOwnerPlayer() || activeBattlePokemon.getBattlePokemon() != pk) continue;
            battle.sendSidedUpdate(activeBattlePokemon.getActor(), (NetworkPacket)new BattleTransformPokemonPacket(activeBattlePokemon.getPNX(), pk, true), (NetworkPacket)new BattleTransformPokemonPacket(activeBattlePokemon.getPNX(), pk, false), false);
        }
    }

    private static /* synthetic */ Unit lambda$terrastallizationUsed$6(LivingEntity pokemon) {
        LazyLib.Companion.cryAnimation((Entity)pokemon);
        return Unit.INSTANCE;
    }
}

