/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.yajatkaul.mega_showdown.item.configActions;

import com.cobblemon.mod.common.Cobblemon;
import com.cobblemon.mod.common.api.pokemon.feature.FlagSpeciesFeature;
import com.cobblemon.mod.common.api.pokemon.feature.StringSpeciesFeature;
import com.cobblemon.mod.common.api.storage.party.PlayerPartyStore;
import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.cobblemon.mod.common.pokemon.helditem.CobblemonHeldItemManager;
import com.cobblemon.yajatkaul.mega_showdown.MegaShowdown;
import com.cobblemon.yajatkaul.mega_showdown.commands.MegaCommands;
import com.cobblemon.yajatkaul.mega_showdown.datamanage.DataManage;
import com.cobblemon.yajatkaul.mega_showdown.datamanage.PokeHandler;
import com.cobblemon.yajatkaul.mega_showdown.datapack.data.EffectsData;
import com.cobblemon.yajatkaul.mega_showdown.datapack.data.FormChangeData;
import com.cobblemon.yajatkaul.mega_showdown.datapack.data.FusionData;
import com.cobblemon.yajatkaul.mega_showdown.datapack.data.GmaxData;
import com.cobblemon.yajatkaul.mega_showdown.datapack.data.HeldItemData;
import com.cobblemon.yajatkaul.mega_showdown.datapack.data.KeyItemData;
import com.cobblemon.yajatkaul.mega_showdown.datapack.data.MegaData;
import com.cobblemon.yajatkaul.mega_showdown.utility.Utils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.CustomModelData;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;

public class ConfigResults {
    private static final Map<UUID, Long> cooldowns = new HashMap<UUID, Long>();
    private static final long COOLDOWN_TIME = 1000L;

    public static boolean Possible(ServerPlayer player) {
        UUID playerId = player.getUUID();
        long currentTime = System.currentTimeMillis();
        if (cooldowns.containsKey(playerId) && currentTime < cooldowns.get(playerId)) {
            player.displayClientMessage((Component)Component.translatable((String)"message.mega_showdown.not_so_fast").withColor(0xFF0000), true);
            return false;
        }
        cooldowns.put(playerId, currentTime + 1000L);
        return true;
    }

    public static void registerCustomShowdown() {
        Item customHeldItem;
        ResourceLocation custom_held_item_id;
        String[] parts;
        Utils.GMAX_SPECIES.clear();
        Utils.addGmaxToMap();
        Utils.MEGA_POKEMONS.clear();
        Utils.addMegaList();
        Utils.MEGA_STONE_IDS.clear();
        Utils.loadMegaStoneIds();
        MegaCommands.VALID_ITEMS.clear();
        for (Record pokemon : Utils.megaRegistry) {
            MegaCommands.VALID_ITEMS.add(((MegaData)pokemon).msd_id());
            Utils.MEGA_POKEMONS.add(((MegaData)pokemon).pokemon());
            parts = ((MegaData)pokemon).item_id().split(":");
            ResourceLocation custom_stone_item_id = ResourceLocation.fromNamespaceAndPath((String)parts[0], (String)parts[1]);
            Item customStone = (Item)BuiltInRegistries.ITEM.get(custom_stone_item_id);
            CobblemonHeldItemManager.INSTANCE.registerStackRemap(arg_0 -> ConfigResults.lambda$registerCustomShowdown$0(customStone, (MegaData)pokemon, arg_0));
        }
        for (Record items : Utils.heldItemsRegistry) {
            MegaCommands.VALID_ITEMS.add(((HeldItemData)items).msd_id());
            parts = ((HeldItemData)items).item_id().split(":");
            custom_held_item_id = ResourceLocation.fromNamespaceAndPath((String)parts[0], (String)parts[1]);
            customHeldItem = (Item)BuiltInRegistries.ITEM.get(custom_held_item_id);
            CobblemonHeldItemManager.INSTANCE.registerStackRemap(arg_0 -> ConfigResults.lambda$registerCustomShowdown$1(customHeldItem, (HeldItemData)items, arg_0));
        }
        for (Record items : Utils.formChangeRegistry) {
            MegaCommands.VALID_ITEMS.add(((FormChangeData)items).msd_id());
            if (!((FormChangeData)items).battle_mode_only().booleanValue()) continue;
            parts = ((FormChangeData)items).item_id().split(":");
            custom_held_item_id = ResourceLocation.fromNamespaceAndPath((String)parts[0], (String)parts[1]);
            customHeldItem = (Item)BuiltInRegistries.ITEM.get(custom_held_item_id);
            CobblemonHeldItemManager.INSTANCE.registerStackRemap(arg_0 -> ConfigResults.lambda$registerCustomShowdown$2(customHeldItem, (FormChangeData)items, arg_0));
        }
        for (Record pokemon : Utils.gmaxRegistry) {
            Utils.GMAX_SPECIES.add(((GmaxData)pokemon).pokemon());
        }
        for (FusionData fusion : Utils.fusionRegistry) {
            MegaCommands.VALID_ITEMS.add(fusion.msd_id());
        }
        for (KeyItemData keyItem : Utils.keyItemsRegistry) {
            MegaCommands.VALID_ITEMS.add(keyItem.msd_id());
        }
    }

    public static boolean useItem(Player player, Level level, InteractionHand hand, ItemStack itemStack) {
        if (level.isClientSide || player.isCrouching()) {
            return false;
        }
        if (!itemStack.isEmpty()) {
            Pokemon pokemon;
            PokemonEntity pk;
            Entity context;
            EntityHitResult entityHit;
            Item item;
            if (itemStack.is(Items.WHEAT_SEEDS)) {
                EntityHitResult entityHit2 = ConfigResults.getEntityLookingAt(player, 4.5f);
                if (entityHit2 != null) {
                    Entity context2 = entityHit2.getEntity();
                    if (player.level().isClientSide || player.isCrouching()) {
                        return false;
                    }
                }
                return false;
            }
            CustomModelData nbt = (CustomModelData)itemStack.get(DataComponents.CUSTOM_MODEL_DATA);
            for (FusionData fusion : Utils.fusionRegistry) {
                item = (Item)BuiltInRegistries.ITEM.get(ResourceLocation.parse((String)fusion.item_id()));
                if (!itemStack.is(item) || (nbt == null || fusion.custom_model_data() != nbt.value()) && fusion.custom_model_data() != 0) continue;
                entityHit = ConfigResults.getEntityLookingAt(player, 4.5f);
                if (entityHit == null) {
                    PlayerPartyStore playerPartyStore = Cobblemon.INSTANCE.getStorage().getParty((ServerPlayer)player);
                    PokeHandler currentValue = (PokeHandler)itemStack.getOrDefault(DataManage.POKEMON_STORAGE, null);
                    if (currentValue.getPokemon() != null) {
                        playerPartyStore.add(currentValue.getPokemon());
                        itemStack.set(DataManage.POKEMON_STORAGE, null);
                        return true;
                    }
                    return false;
                }
                context = entityHit.getEntity();
                if (!(context instanceof PokemonEntity)) {
                    return false;
                }
                pk = (PokemonEntity)context;
                pokemon = pk.getPokemon();
                if (pokemon.getOwnerPlayer() != player || pokemon.getEntity() == null || pk.isBattling()) {
                    return false;
                }
                PlayerPartyStore playerPartyStore = Cobblemon.INSTANCE.getStorage().getParty((ServerPlayer)player);
                Pokemon currentValue = null;
                if (itemStack.get(DataManage.POKEMON_STORAGE) != null) {
                    currentValue = ((PokeHandler)itemStack.get(DataManage.POKEMON_STORAGE)).getPokemon();
                }
                if (ConfigResults.checkEnabled(fusion, pokemon) && fusion.fusion_mon().contains(pokemon.getSpecies().getName())) {
                    HashMap map;
                    if (!fusion.required_aspects_fusion_mon().isEmpty()) {
                        Object aspects2;
                        ArrayList aspectList = new ArrayList();
                        for (Object aspects2 : fusion.required_aspects_fusion_mon()) {
                            String[] aspectDiv = ((String)aspects2).split("=");
                            if (aspectDiv[1].equals("true") || aspectDiv[1].equals("false")) {
                                aspectList.add(aspectDiv[0]);
                                continue;
                            }
                            aspectList.add(aspectDiv[1]);
                        }
                        boolean allMatch = true;
                        aspects2 = aspectList.iterator();
                        while (aspects2.hasNext()) {
                            String requiredAspect = (String)aspects2.next();
                            boolean matched = false;
                            for (String pokemonAspect : pokemon.getAspects()) {
                                if (!pokemonAspect.startsWith(requiredAspect)) continue;
                                matched = true;
                                break;
                            }
                            if (matched) continue;
                            allMatch = false;
                            break;
                        }
                        if (!allMatch) {
                            return false;
                        }
                    }
                    if (itemStack.get(DataManage.POKEMON_STORAGE) != null) {
                        player.displayClientMessage((Component)Component.translatable((String)"message.mega_showdown.already_fused").withColor(0xFF0000), true);
                        return false;
                    }
                    ConfigResults.particleEffect((LivingEntity)pk, fusion.effects(), false);
                    for (String aspects : fusion.default_aspects()) {
                        String[] aspectsDiv = aspects.split("=");
                        if (aspectsDiv[1].equals("true") || aspectsDiv[1].equals("false")) {
                            new FlagSpeciesFeature(aspectsDiv[0], Boolean.parseBoolean(aspectsDiv[1])).apply(pokemon);
                            continue;
                        }
                        new StringSpeciesFeature(aspectsDiv[0], aspectsDiv[1]).apply(pokemon);
                    }
                    if (!fusion.tradable_form()) {
                        Utils.setTradable(pokemon, true);
                    }
                    if ((map = (HashMap)player.getData(DataManage.DATA_MAP)) == null) {
                        map = new HashMap();
                    }
                    Pokemon toAdd = (Pokemon)map.get(pokemon.getUuid());
                    playerPartyStore.add(toAdd);
                    map.remove(pokemon.getUuid());
                    player.setData(DataManage.DATA_MAP, map);
                    itemStack.set(DataManage.POKEMON_STORAGE, null);
                    itemStack.set(DataComponents.CUSTOM_NAME, (Object)Component.translatable((String)(fusion.item_name() + "inactive")));
                    return true;
                }
                if (currentValue != null && fusion.fusion_mon().contains(pokemon.getSpecies().getName())) {
                    HashMap<UUID, Pokemon> map;
                    if (!fusion.required_aspects_fusion_mon().isEmpty()) {
                        Object aspects3;
                        ArrayList aspectList = new ArrayList();
                        for (Object aspects3 : fusion.required_aspects_fusion_mon()) {
                            String[] aspectDiv = ((String)aspects3).split("=");
                            if (aspectDiv[1].equals("true") || aspectDiv[1].equals("false")) {
                                aspectList.add(aspectDiv[0]);
                                continue;
                            }
                            aspectList.add(aspectDiv[1]);
                        }
                        boolean allMatch = true;
                        aspects3 = aspectList.iterator();
                        while (aspects3.hasNext()) {
                            String requiredAspect = (String)aspects3.next();
                            boolean matched = false;
                            for (String pokemonAspect : pokemon.getAspects()) {
                                if (!pokemonAspect.startsWith(requiredAspect)) continue;
                                matched = true;
                                break;
                            }
                            if (matched) continue;
                            allMatch = false;
                            break;
                        }
                        if (!allMatch) {
                            return false;
                        }
                    }
                    for (String aspects : fusion.fusion_aspects()) {
                        String[] aspectsDiv = aspects.split("=");
                        if (aspectsDiv[1].equals("true") || aspectsDiv[1].equals("false")) {
                            new FlagSpeciesFeature(aspectsDiv[0], Boolean.parseBoolean(aspectsDiv[1])).apply(pokemon);
                            continue;
                        }
                        new StringSpeciesFeature(aspectsDiv[0], aspectsDiv[1]).apply(pokemon);
                    }
                    ConfigResults.particleEffect((LivingEntity)pk, fusion.effects(), true);
                    if (!fusion.tradable_form()) {
                        Utils.setTradable(pokemon, false);
                    }
                    if ((map = (HashMap<UUID, Pokemon>)player.getData(DataManage.DATA_MAP)) == null) {
                        map = new HashMap<UUID, Pokemon>();
                    }
                    map.put(pokemon.getUuid(), currentValue);
                    player.setData(DataManage.DATA_MAP, map);
                    itemStack.set(DataManage.POKEMON_STORAGE, null);
                    itemStack.set(DataComponents.CUSTOM_NAME, (Object)Component.translatable((String)(fusion.item_name() + "inactive")));
                    return true;
                }
                if (currentValue == null && fusion.fuse_with_mon().contains(pokemon.getSpecies().getName())) {
                    if (!fusion.required_aspects_fuse_with_mon().isEmpty()) {
                        ArrayList<String> aspectList = new ArrayList<String>();
                        for (Object aspects : fusion.required_aspects_fuse_with_mon()) {
                            String[] aspectDiv = ((String)aspects).split("=");
                            if (aspectDiv[1].equals("true") || aspectDiv[1].equals("false")) {
                                aspectList.add(aspectDiv[0]);
                                continue;
                            }
                            aspectList.add(aspectDiv[1]);
                        }
                        boolean allMatch = true;
                        for (String requiredAspect : aspectList) {
                            boolean matched = false;
                            for (String pokemonAspect : pokemon.getAspects()) {
                                if (!pokemonAspect.startsWith(requiredAspect)) continue;
                                matched = true;
                                break;
                            }
                            if (matched) continue;
                            allMatch = false;
                            break;
                        }
                        if (!allMatch) {
                            return false;
                        }
                    }
                    itemStack.set(DataManage.POKEMON_STORAGE, (Object)new PokeHandler(pk.getPokemon()));
                    playerPartyStore.remove(pk.getPokemon());
                    itemStack.set(DataComponents.CUSTOM_NAME, (Object)Component.translatable((String)(fusion.item_name() + "charged")));
                    return true;
                }
                player.setItemInHand(hand, itemStack);
            }
            for (KeyItemData keyItems : Utils.keyItemsRegistry) {
                String[] aspectDiv;
                item = (Item)BuiltInRegistries.ITEM.get(ResourceLocation.parse((String)keyItems.item_id()));
                if (!itemStack.is(item) || (nbt == null || keyItems.custom_model_data().intValue() != nbt.value()) && keyItems.custom_model_data() != 0 || (entityHit = ConfigResults.getEntityLookingAt(player, 4.5f)) == null) continue;
                context = entityHit.getEntity();
                if (!(context instanceof PokemonEntity)) {
                    return false;
                }
                pk = (PokemonEntity)context;
                pokemon = pk.getPokemon();
                if (pokemon.getOwnerPlayer() != player || pokemon.getEntity() == null || pk.isBattling()) {
                    return false;
                }
                if (!keyItems.pokemons().contains(pokemon.getSpecies().getName())) continue;
                if (!keyItems.required_aspects().isEmpty()) {
                    ArrayList<String> aspectList = new ArrayList<String>();
                    for (String aspects : keyItems.required_aspects()) {
                        aspectDiv = aspects.split("=");
                        if (aspectDiv[1].equals("true") || aspectDiv[1].equals("false")) {
                            aspectList.add(aspectDiv[0]);
                            continue;
                        }
                        aspectList.add(aspectDiv[1]);
                    }
                    boolean allMatch = true;
                    for (String requiredAspect : aspectList) {
                        boolean matched = false;
                        for (String pokemonAspect : pokemon.getAspects()) {
                            if (!pokemonAspect.startsWith(requiredAspect)) continue;
                            matched = true;
                            break;
                        }
                        if (matched) continue;
                        allMatch = false;
                        break;
                    }
                    if (!allMatch) {
                        return false;
                    }
                }
                if (!ConfigResults.Possible((ServerPlayer)player)) {
                    return false;
                }
                if (keyItems.toggle_aspects().isEmpty()) {
                    ArrayList<String> aspectList = new ArrayList<String>();
                    for (String aspects : keyItems.aspects()) {
                        aspectDiv = aspects.split("=");
                        if (aspectDiv[1].equals("true") || aspectDiv[1].equals("false")) {
                            aspectList.add(aspectDiv[0]);
                            continue;
                        }
                        aspectList.add(aspectDiv[1]);
                    }
                    boolean allMatch = true;
                    for (String requiredAspect : aspectList) {
                        boolean matched = false;
                        for (String pokemonAspect : pokemon.getAspects()) {
                            if (!pokemonAspect.startsWith(requiredAspect)) continue;
                            matched = true;
                            break;
                        }
                        if (matched) continue;
                        allMatch = false;
                        break;
                    }
                    if (allMatch) {
                        for (String aspects : keyItems.default_aspects()) {
                            String[] aspectsDiv = aspects.split("=");
                            if (aspectsDiv[1].equals("true") || aspectsDiv[1].equals("false")) {
                                new FlagSpeciesFeature(aspectsDiv[0], Boolean.parseBoolean(aspectsDiv[1])).apply(pokemon);
                            } else {
                                new StringSpeciesFeature(aspectsDiv[0], aspectsDiv[1]).apply(pokemon);
                            }
                            if (keyItems.tradable_form().booleanValue()) continue;
                            Utils.setTradable(pokemon, true);
                        }
                        ConfigResults.particleEffect((LivingEntity)pk, keyItems.effects(), false);
                        if (!keyItems.consume().booleanValue()) continue;
                        itemStack.shrink(1);
                        continue;
                    }
                    for (String aspects : keyItems.aspects()) {
                        String[] aspectsDiv = aspects.split("=");
                        if (aspectsDiv[1].equals("true") || aspectsDiv[1].equals("false")) {
                            new FlagSpeciesFeature(aspectsDiv[0], Boolean.parseBoolean(aspectsDiv[1])).apply(pokemon);
                        } else {
                            new StringSpeciesFeature(aspectsDiv[0], aspectsDiv[1]).apply(pokemon);
                        }
                        if (keyItems.tradable_form().booleanValue()) continue;
                        Utils.setTradable(pokemon, false);
                    }
                    ConfigResults.particleEffect((LivingEntity)pk, keyItems.effects(), true);
                    if (!keyItems.consume().booleanValue()) continue;
                    itemStack.shrink(1);
                    continue;
                }
                int currentIndex = -1;
                List<String> currentAspects = pokemon.getAspects().stream().map(String::toLowerCase).toList();
                for (int i = 0; i < keyItems.toggle_aspects().size(); ++i) {
                    List<String> sublist = keyItems.toggle_aspects().get(i);
                    for (String aspect : sublist) {
                        String value = aspect.split("=")[1].toLowerCase();
                        for (String current : currentAspects) {
                            if (!current.contains(value) && !value.contains(current)) continue;
                            currentIndex = i;
                            break;
                        }
                        if (currentIndex == -1) continue;
                        break;
                    }
                    if (currentIndex != -1) break;
                }
                int nextIndex = (currentIndex + 1) % keyItems.toggle_aspects().size();
                List<String> nextAspects = keyItems.toggle_aspects().get(nextIndex);
                for (String aspect : nextAspects) {
                    String[] parts = aspect.split("=");
                    String key = parts[0];
                    String value = parts[1];
                    if (value.equals("true") || value.equals("false")) {
                        new FlagSpeciesFeature(key, Boolean.parseBoolean(value)).apply(pokemon);
                        continue;
                    }
                    new StringSpeciesFeature(key, value).apply(pokemon);
                }
                ConfigResults.particleEffect((LivingEntity)pk, keyItems.effects(), true);
                Utils.setTradable(pokemon, keyItems.tradable_form() == false);
                if (!keyItems.consume().booleanValue()) continue;
                itemStack.shrink(1);
            }
        }
        return false;
    }

    private static boolean checkEnabled(FusionData fusion, Pokemon pk) {
        for (String aspects : fusion.fusion_aspects()) {
            String[] aspectsDiv = aspects.split("=");
            if (aspectsDiv[1].equals("true") || aspectsDiv[1].equals("false")) {
                if (!pk.getAspects().contains(aspectsDiv[0])) continue;
                return true;
            }
            for (String aspect : pk.getAspects()) {
                if (!aspect.startsWith(aspectsDiv[1])) continue;
                return true;
            }
        }
        return false;
    }

    public static EntityHitResult getEntityLookingAt(Player player, float distance) {
        Vec3 eyePos = player.getEyePosition();
        Vec3 lookVec = player.getViewVector(1.0f);
        Vec3 targetPos = eyePos.add(lookVec.scale((double)distance));
        AABB rayTraceBox = new AABB(eyePos, targetPos);
        return ProjectileUtil.getEntityHitResult((Level)player.level(), (Entity)player, (Vec3)eyePos, (Vec3)targetPos, (AABB)rayTraceBox, entity -> !entity.isSpectator() && entity instanceof LivingEntity && entity.isPickable(), (float)0.3f);
    }

    public static void particleEffect(LivingEntity context, EffectsData effects, boolean apply) {
        int amplifier = apply ? effects.particle_apply_amplifier() : effects.particle_revert_amplifier();
        Level level = context.level();
        if (level instanceof ServerLevel) {
            String[] partsSound;
            String[] partsParticle;
            ServerLevel serverLevel = (ServerLevel)level;
            if (apply) {
                partsParticle = effects.particle_apply().split(":");
                partsSound = effects.sound_apply().split(":");
            } else {
                partsParticle = effects.particle_revert().split(":");
                partsSound = effects.sound_revert().split(":");
            }
            ResourceLocation custom_particle_id = ResourceLocation.fromNamespaceAndPath((String)partsParticle[0], (String)partsParticle[1]);
            ParticleType particleType = (ParticleType)BuiltInRegistries.PARTICLE_TYPE.get(custom_particle_id);
            ResourceLocation custom_sound_id = ResourceLocation.fromNamespaceAndPath((String)partsSound[0], (String)partsSound[1]);
            SoundEvent soundEvent = (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(custom_sound_id);
            Vec3 entityPos = context.position();
            double entityWidth = context.getBbWidth();
            double entityHeight = context.getBbHeight();
            if (soundEvent == null) {
                if (apply && !effects.sound_apply().isEmpty()) {
                    MegaShowdown.LOGGER.error("A: Invalid Sound used for pokemon: {}, sound id: {}", (Object)((PokemonEntity)context).getPokemon().getSpecies().getName(), (Object)effects.sound_apply());
                } else if (!apply && !effects.sound_revert().isEmpty()) {
                    MegaShowdown.LOGGER.error("R: Invalid Sound used for pokemon: {}, sound id: {}", (Object)((PokemonEntity)context).getPokemon().getSpecies().getName(), (Object)effects.sound_revert());
                }
            } else {
                serverLevel.playSound(null, entityPos.x, entityPos.y, entityPos.z, soundEvent, SoundSource.PLAYERS, 1.5f, 0.5f + (float)Math.random() * 0.5f);
            }
            int baseParticleCount = (int)(100.0 * entityWidth * entityHeight);
            int particleCount = baseParticleCount * Math.max(1, amplifier);
            double radius = entityWidth * (0.8 + (double)amplifier * 0.1);
            if (particleType instanceof ParticleOptions) {
                ParticleOptions particle = (ParticleOptions)particleType;
                for (int i = 0; i < particleCount; ++i) {
                    double angle = Math.random() * 2.0 * Math.PI;
                    double xOffset = Math.cos(angle) * radius;
                    double zOffset = Math.sin(angle) * radius;
                    double yOffset = Math.random() * entityHeight;
                    serverLevel.sendParticles(particle, entityPos.x + xOffset, entityPos.y + yOffset, entityPos.z + zOffset, 1, 0.0, 0.0, 0.0, 0.1);
                }
            } else if (apply && !effects.particle_apply().isEmpty()) {
                MegaShowdown.LOGGER.error("A: Invalid Particle used for pokemon: {}, particle id: {}", (Object)((PokemonEntity)context).getPokemon().getSpecies().getName(), (Object)effects.particle_apply());
            } else if (!apply && !effects.particle_revert().isEmpty()) {
                MegaShowdown.LOGGER.error("R: Invalid Particle used for pokemon: {}, particle id: {}", (Object)((PokemonEntity)context).getPokemon().getSpecies().getName(), (Object)effects.particle_revert());
            }
        }
    }

    private static /* synthetic */ String lambda$registerCustomShowdown$2(Item customHeldItem, FormChangeData items, ItemStack stack) {
        if (stack.getItem().equals(customHeldItem) && (stack.get(DataComponents.CUSTOM_MODEL_DATA) != null && ((CustomModelData)stack.get(DataComponents.CUSTOM_MODEL_DATA)).value() == items.custom_model_data().intValue() || items.custom_model_data() == 0)) {
            return items.showdown_id();
        }
        return null;
    }

    private static /* synthetic */ String lambda$registerCustomShowdown$1(Item customHeldItem, HeldItemData items, ItemStack stack) {
        if (stack.getItem().equals(customHeldItem) && (stack.get(DataComponents.CUSTOM_MODEL_DATA) != null && ((CustomModelData)stack.get(DataComponents.CUSTOM_MODEL_DATA)).value() == items.custom_model_data().intValue() || items.custom_model_data() == 0)) {
            return items.showdown_id();
        }
        return null;
    }

    private static /* synthetic */ String lambda$registerCustomShowdown$0(Item customStone, MegaData pokemon, ItemStack stack) {
        if (stack.getItem().equals(customStone) && (stack.get(DataComponents.CUSTOM_MODEL_DATA) != null && ((CustomModelData)stack.get(DataComponents.CUSTOM_MODEL_DATA)).value() == pokemon.custom_model_data().intValue() || pokemon.custom_model_data() == 0)) {
            return pokemon.showdown_id();
        }
        return null;
    }
}

