/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.yajatkaul.mega_showdown.item.custom.dynamax;

import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.cobblemon.yajatkaul.mega_showdown.advancement.AdvancementHelper;
import java.util.List;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class DynamaxCandy
extends Item {
    public DynamaxCandy(Item.Properties arg) {
        super(arg);
    }

    public InteractionResult interactLivingEntity(ItemStack stack, Player player, LivingEntity context, InteractionHand arg4) {
        if (player.level().isClientSide || player.isCrouching()) {
            return InteractionResult.PASS;
        }
        if (context instanceof PokemonEntity) {
            PokemonEntity pk = (PokemonEntity)context;
            Pokemon pokemon = pk.getPokemon();
            if (pokemon.getEntity() == null || pokemon.getEntity().level().isClientSide || pokemon.getEntity().isBattling()) {
                return InteractionResult.PASS;
            }
            if (pokemon.getOwnerPlayer() == player && pokemon.getDmaxLevel() < 10) {
                pokemon.setDmaxLevel(pokemon.getDmaxLevel() + 1);
                if (pokemon.getDmaxLevel() == 10) {
                    AdvancementHelper.grantAdvancement(pk.getPokemon().getOwnerPlayer(), "dynamax/dynamax_candy_max");
                }
                if (pokemon.getSpecies().getName().equals("Calyrex")) {
                    this.particleEffect((LivingEntity)pokemon.getEntity(), ParticleTypes.SOUL_FIRE_FLAME);
                } else {
                    this.particleEffect((LivingEntity)pokemon.getEntity(), ParticleTypes.FLAME);
                }
                stack.shrink(1);
                return InteractionResult.SUCCESS;
            }
            if (pokemon.getDmaxLevel() >= 10 && pokemon.getOwnerPlayer() == player) {
                player.displayClientMessage((Component)Component.translatable((String)"message.mega_showdown.dmax_level_cap").withColor(0xFF0000), true);
            }
        }
        return super.interactLivingEntity(stack, player, context, arg4);
    }

    private void particleEffect(LivingEntity context, SimpleParticleType particleType) {
        Level level = context.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            Vec3 entityPos = context.position();
            double entityWidth = context.getBbWidth();
            double entityHeight = context.getBbHeight();
            double scaleFactor = 0.5;
            double adjustedWidth = entityWidth * scaleFactor;
            double adjustedHeight = entityHeight * scaleFactor;
            double adjustedDepth = entityWidth * scaleFactor;
            serverLevel.playSound(null, entityPos.x, entityPos.y, entityPos.z, SoundEvents.AMETHYST_BLOCK_CHIME, SoundSource.PLAYERS, 1.5f, 0.5f + (float)Math.random() * 0.5f);
            int particleCount = (int)(175.0 * adjustedWidth * adjustedHeight);
            for (int i = 0; i < particleCount; ++i) {
                double xOffset = (Math.random() - 0.5) * adjustedWidth;
                double yOffset = Math.random() * adjustedHeight;
                double zOffset = (Math.random() - 0.5) * adjustedDepth;
                serverLevel.sendParticles((ParticleOptions)particleType, entityPos.x + xOffset, entityPos.y + yOffset, entityPos.z + zOffset, 1, 0.0, 0.0, 0.0, 0.1);
            }
        }
    }

    public void appendHoverText(ItemStack arg, Item.TooltipContext arg2, List<Component> tooltipComponents, TooltipFlag arg3) {
        tooltipComponents.add((Component)Component.translatable((String)"tooltip.mega_showdown.dynamax_candy.tooltip"));
        super.appendHoverText(arg, arg2, tooltipComponents, arg3);
    }
}

