/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.yajatkaul.mega_showdown.event;

import com.cobblemon.mod.common.Cobblemon;
import com.cobblemon.mod.common.api.battles.model.PokemonBattle;
import com.cobblemon.mod.common.api.pokemon.feature.FlagSpeciesFeature;
import com.cobblemon.mod.common.api.pokemon.feature.StringSpeciesFeature;
import com.cobblemon.mod.common.api.storage.party.PlayerPartyStore;
import com.cobblemon.mod.common.battles.BattleRegistry;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.cobblemon.yajatkaul.mega_showdown.Config;
import com.cobblemon.yajatkaul.mega_showdown.datamanage.DataManage;
import com.cobblemon.yajatkaul.mega_showdown.item.MegaStones;
import com.cobblemon.yajatkaul.mega_showdown.item.ModItems;
import com.cobblemon.yajatkaul.mega_showdown.item.TeraMoves;
import com.cobblemon.yajatkaul.mega_showdown.item.ZMoves;
import com.cobblemon.yajatkaul.mega_showdown.mixin.LootPoolAccessor;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.ItemLore;
import net.minecraft.world.item.trading.ItemCost;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.maps.MapDecorationTypes;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.functions.ExplorationMapFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.util.TriState;
import net.neoforged.neoforge.event.LootTableLoadEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.village.VillagerTradesEvent;
import top.theillusivec4.curios.api.event.CurioCanUnequipEvent;

@EventBusSubscriber(modid="mega_showdown", bus=EventBusSubscriber.Bus.GAME)
public class ModEvents {
    @SubscribeEvent
    public static void onLootTableLoad(LootTableLoadEvent event) {
        ResourceLocation lootTableId = event.getName();
        ResourceLocation desertPyramidLootTable = ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"archaeology/desert_pyramid");
        ResourceLocation desertWellLootTable = ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"archaeology/desert_well");
        ResourceLocation ruinWarmLootTable = ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"archaeology/ocean_warm_cold");
        ResourceLocation ruinColdLootTable = ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"archaeology/ocean_ruin_cold");
        ResourceLocation trialChamberLootTable = ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"chests/trial_chambers/reward_ominous_unique");
        ResourceLocation luna_ruins = ResourceLocation.fromNamespaceAndPath((String)"cobblemon", (String)"ruins/common/luna_henge_ruins");
        ResourceLocation mossy_ruins = ResourceLocation.fromNamespaceAndPath((String)"cobblemon", (String)"ruins/common/mossy_oubliette_ruins");
        ResourceLocation ancient_city = ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"chests/ancient_city");
        LootTable table = event.getTable();
        LootPool mainPool = table.getPool("main");
        if (desertPyramidLootTable.equals((Object)lootTableId) || desertWellLootTable.equals((Object)lootTableId)) {
            table = event.getTable();
            mainPool = table.getPool("main");
            if (mainPool != null && !mainPool.isFrozen()) {
                LootPoolAccessor poolAccessor = (LootPoolAccessor)mainPool;
                LootPool.Builder newPoolBuilder = LootPool.lootPool().setRolls(mainPool.getRolls()).setBonusRolls(mainPool.getBonusRolls());
                poolAccessor.getEntries().forEach(entry -> newPoolBuilder.add(new LootPoolEntryContainer.Builder((LootPoolEntryContainer)entry){
                    final /* synthetic */ LootPoolEntryContainer val$entry;
                    {
                        this.val$entry = lootPoolEntryContainer;
                    }

                    protected LootPoolEntryContainer.Builder getThis() {
                        return null;
                    }

                    public LootPoolEntryContainer build() {
                        return this.val$entry;
                    }
                }));
                newPoolBuilder.add((LootPoolEntryContainer.Builder)LootItem.lootTableItem(MegaStones.RED_ORB).setWeight(1));
                if (mainPool.getName() != null) {
                    newPoolBuilder.name(mainPool.getName());
                }
                table.removePool("main");
                table.addPool(newPoolBuilder.build());
            }
        } else if (ruinColdLootTable.equals((Object)lootTableId) || ruinWarmLootTable.equals((Object)lootTableId)) {
            if (mainPool != null && !mainPool.isFrozen()) {
                LootPoolAccessor poolAccessor = (LootPoolAccessor)mainPool;
                LootPool.Builder newPoolBuilder = LootPool.lootPool().setRolls(mainPool.getRolls()).setBonusRolls(mainPool.getBonusRolls());
                poolAccessor.getEntries().forEach(entry -> newPoolBuilder.add(new LootPoolEntryContainer.Builder((LootPoolEntryContainer)entry){
                    final /* synthetic */ LootPoolEntryContainer val$entry;
                    {
                        this.val$entry = lootPoolEntryContainer;
                    }

                    protected LootPoolEntryContainer.Builder getThis() {
                        return null;
                    }

                    public LootPoolEntryContainer build() {
                        return this.val$entry;
                    }
                }));
                newPoolBuilder.add((LootPoolEntryContainer.Builder)LootItem.lootTableItem(MegaStones.BLUE_ORB).setWeight(1));
                if (mainPool.getName() != null) {
                    newPoolBuilder.name(mainPool.getName());
                }
                table.removePool("main");
                table.addPool(newPoolBuilder.build());
            }
        } else if (trialChamberLootTable.equals((Object)lootTableId)) {
            if (mainPool != null && !mainPool.isFrozen()) {
                LootPoolAccessor poolAccessor = (LootPoolAccessor)mainPool;
                LootPool.Builder newPoolBuilder = LootPool.lootPool().setRolls(mainPool.getRolls()).setBonusRolls(mainPool.getBonusRolls());
                poolAccessor.getEntries().forEach(entry -> newPoolBuilder.add(new LootPoolEntryContainer.Builder((LootPoolEntryContainer)entry){
                    final /* synthetic */ LootPoolEntryContainer val$entry;
                    {
                        this.val$entry = lootPoolEntryContainer;
                    }

                    protected LootPoolEntryContainer.Builder getThis() {
                        return null;
                    }

                    public LootPoolEntryContainer build() {
                        return this.val$entry;
                    }
                }));
                newPoolBuilder.add((LootPoolEntryContainer.Builder)LootItem.lootTableItem(ZMoves.BLANK_Z).setWeight(2));
                if (mainPool.getName() != null) {
                    newPoolBuilder.name(mainPool.getName());
                }
                table.removePool("main");
                table.addPool(newPoolBuilder.build());
            }
        } else if (luna_ruins.equals((Object)lootTableId)) {
            if (mainPool != null && !mainPool.isFrozen()) {
                LootPoolAccessor poolAccessor = (LootPoolAccessor)mainPool;
                LootPool.Builder newPoolBuilder = LootPool.lootPool().setRolls(mainPool.getRolls()).setBonusRolls(mainPool.getBonusRolls());
                poolAccessor.getEntries().forEach(entry -> newPoolBuilder.add(new LootPoolEntryContainer.Builder((LootPoolEntryContainer)entry){
                    final /* synthetic */ LootPoolEntryContainer val$entry;
                    {
                        this.val$entry = lootPoolEntryContainer;
                    }

                    protected LootPoolEntryContainer.Builder getThis() {
                        return null;
                    }

                    public LootPoolEntryContainer build() {
                        return this.val$entry;
                    }
                }));
                newPoolBuilder.add((LootPoolEntryContainer.Builder)LootItem.lootTableItem(ModItems.RUSTED_SWORD).setWeight(6));
                if (mainPool.getName() != null) {
                    newPoolBuilder.name(mainPool.getName());
                }
                table.removePool("main");
                table.addPool(newPoolBuilder.build());
            }
        } else if (mossy_ruins.equals((Object)lootTableId)) {
            if (mainPool != null && !mainPool.isFrozen()) {
                LootPoolAccessor poolAccessor = (LootPoolAccessor)mainPool;
                LootPool.Builder newPoolBuilder = LootPool.lootPool().setRolls(mainPool.getRolls()).setBonusRolls(mainPool.getBonusRolls());
                poolAccessor.getEntries().forEach(entry -> newPoolBuilder.add(new LootPoolEntryContainer.Builder((LootPoolEntryContainer)entry){
                    final /* synthetic */ LootPoolEntryContainer val$entry;
                    {
                        this.val$entry = lootPoolEntryContainer;
                    }

                    protected LootPoolEntryContainer.Builder getThis() {
                        return null;
                    }

                    public LootPoolEntryContainer build() {
                        return this.val$entry;
                    }
                }));
                newPoolBuilder.add((LootPoolEntryContainer.Builder)LootItem.lootTableItem(ModItems.RUSTED_SHIELD).setWeight(6));
                if (mainPool.getName() != null) {
                    newPoolBuilder.name(mainPool.getName());
                }
                table.removePool("main");
                table.addPool(newPoolBuilder.build());
            }
        } else if (ancient_city.equals((Object)lootTableId) && (mainPool = table.getPool("pool0")) != null && !mainPool.isFrozen()) {
            LootPoolAccessor poolAccessor = (LootPoolAccessor)mainPool;
            LootPool.Builder newPoolBuilder = LootPool.lootPool().setRolls(mainPool.getRolls()).setBonusRolls(mainPool.getBonusRolls());
            poolAccessor.getEntries().forEach(entry -> newPoolBuilder.add(new LootPoolEntryContainer.Builder((LootPoolEntryContainer)entry){
                final /* synthetic */ LootPoolEntryContainer val$entry;
                {
                    this.val$entry = lootPoolEntryContainer;
                }

                protected LootPoolEntryContainer.Builder getThis() {
                    return null;
                }

                public LootPoolEntryContainer build() {
                    return this.val$entry;
                }
            }));
            newPoolBuilder.add((LootPoolEntryContainer.Builder)LootItem.lootTableItem(ModItems.PRISON_BOTTLE).setWeight(3));
            if (mainPool.getName() != null) {
                newPoolBuilder.name(mainPool.getName());
            }
            table.removePool("pool0");
            table.addPool(newPoolBuilder.build());
        }
    }

    @SubscribeEvent
    public static void addCustomTrades(VillagerTradesEvent event) {
        if (event.getType() == VillagerProfession.CARTOGRAPHER) {
            Int2ObjectMap trades = event.getTrades();
            ((List)trades.get(3)).add((entity, randomSource) -> new MerchantOffer(new ItemCost(MegaStones.MEGA_STONE, 1), ModEvents.createExplorerMap(entity.level(), entity.getOnPos(), entity), 1, 6, 0.05f));
        }
    }

    private static ItemStack createExplorerMap(Level level, BlockPos pos, Entity entity) {
        if (!(level instanceof ServerLevel)) {
            return ItemStack.EMPTY;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        TagKey megaroidStructureTag = TagKey.create((ResourceKey)Registries.STRUCTURE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"mega_showdown", (String)"megaroid"));
        LootItemFunction mapFunction = new ExplorationMapFunction.Builder().setDestination(megaroidStructureTag).setZoom((byte)2).setSearchRadius(1000).setMapDecoration(MapDecorationTypes.RED_X).setSkipKnownStructures(true).build();
        ItemStack mapStack = new ItemStack((ItemLike)Items.MAP);
        LootParams lootParams = new LootParams.Builder(serverLevel).withParameter(LootContextParams.ORIGIN, (Object)Vec3.atCenterOf((Vec3i)pos)).withParameter(LootContextParams.THIS_ENTITY, (Object)entity).withParameter(LootContextParams.DAMAGE_SOURCE, (Object)entity.level().damageSources().generic()).create(LootContextParamSets.ENTITY);
        LootContext lootContext = new LootContext.Builder(lootParams).create(Optional.empty());
        mapStack = (ItemStack)mapFunction.apply((Object)mapStack, (Object)lootContext);
        mapStack.set(DataComponents.CUSTOM_NAME, (Object)Component.literal((String)"Lost map"));
        List<MutableComponent> loreLines = List.of(Component.literal((String)"This map leads you to the lost stone"));
        mapStack.set(DataComponents.LORE, (Object)new ItemLore(loreLines));
        return mapStack;
    }

    @SubscribeEvent
    public static void onCurioChange(CurioCanUnequipEvent event) {
        ServerPlayer player;
        PokemonBattle battle;
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof ServerPlayer && (battle = BattleRegistry.INSTANCE.getBattleByParticipatingPlayer(player = (ServerPlayer)livingEntity)) != null && event.getStack().is(TeraMoves.TERA_ORB)) {
            event.setUnequipResult(TriState.FALSE);
        }
    }

    @SubscribeEvent
    private static void onServerJoin(PlayerEvent.PlayerLoggedInEvent playerLoggedInEvent) {
        Player player;
        if (Config.battleModeOnly && (player = playerLoggedInEvent.getEntity()) instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            PlayerPartyStore playerPartyStore = Cobblemon.INSTANCE.getStorage().getParty(player2);
            for (Pokemon pokemon : playerPartyStore) {
                new FlagSpeciesFeature("mega", false).apply(pokemon);
                new FlagSpeciesFeature("mega-x", false).apply(pokemon);
                new FlagSpeciesFeature("mega-y", false).apply(pokemon);
                new StringSpeciesFeature("stance_forme", "shield").apply(pokemon);
                new FlagSpeciesFeature("embody_aspect", false).apply(pokemon);
            }
            player2.setData(DataManage.MEGA_DATA, (Object)false);
        }
    }

    @SubscribeEvent
    private static void onPlayerRespawn(PlayerEvent.PlayerRespawnEvent event) {
        Player player;
        if (Config.battleModeOnly && (player = event.getEntity()) instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            PlayerPartyStore playerPartyStore = Cobblemon.INSTANCE.getStorage().getParty(player2);
            for (Pokemon pokemon : playerPartyStore) {
                new FlagSpeciesFeature("mega", false).apply(pokemon);
                new FlagSpeciesFeature("mega-x", false).apply(pokemon);
                new FlagSpeciesFeature("mega-y", false).apply(pokemon);
                new StringSpeciesFeature("stance_forme", "shield").apply(pokemon);
                new FlagSpeciesFeature("embody_aspect", false).apply(pokemon);
            }
            player2.setData(DataManage.MEGA_DATA, (Object)false);
        }
    }
}

