/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.yajatkaul.mega_showdown.event.cobbleEvents;

import com.cobblemon.mod.common.Cobblemon;
import com.cobblemon.mod.common.api.battles.model.PokemonBattle;
import com.cobblemon.mod.common.api.drop.ItemDropEntry;
import com.cobblemon.mod.common.api.events.battles.BattleFaintedEvent;
import com.cobblemon.mod.common.api.events.battles.BattleFledEvent;
import com.cobblemon.mod.common.api.events.battles.BattleStartedPreEvent;
import com.cobblemon.mod.common.api.events.battles.BattleVictoryEvent;
import com.cobblemon.mod.common.api.events.battles.instruction.FormeChangeEvent;
import com.cobblemon.mod.common.api.events.battles.instruction.MegaEvolutionEvent;
import com.cobblemon.mod.common.api.events.battles.instruction.TerastallizationEvent;
import com.cobblemon.mod.common.api.events.battles.instruction.ZMoveUsedEvent;
import com.cobblemon.mod.common.api.events.drops.LootDroppedEvent;
import com.cobblemon.mod.common.api.events.pokemon.HeldItemEvent;
import com.cobblemon.mod.common.api.events.pokemon.PokemonCapturedEvent;
import com.cobblemon.mod.common.api.events.pokemon.healing.PokemonHealedEvent;
import com.cobblemon.mod.common.api.events.storage.ReleasePokemonEvent;
import com.cobblemon.mod.common.api.moves.Move;
import com.cobblemon.mod.common.api.moves.Moves;
import com.cobblemon.mod.common.api.net.NetworkPacket;
import com.cobblemon.mod.common.api.pokemon.feature.FlagSpeciesFeature;
import com.cobblemon.mod.common.api.pokemon.feature.FlagSpeciesFeatureProvider;
import com.cobblemon.mod.common.api.pokemon.feature.SpeciesFeature;
import com.cobblemon.mod.common.api.pokemon.feature.StringSpeciesFeature;
import com.cobblemon.mod.common.api.storage.party.PlayerPartyStore;
import com.cobblemon.mod.common.api.storage.player.GeneralPlayerData;
import com.cobblemon.mod.common.api.types.tera.TeraType;
import com.cobblemon.mod.common.api.types.tera.TeraTypes;
import com.cobblemon.mod.common.battles.pokemon.BattlePokemon;
import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import com.cobblemon.mod.common.net.messages.client.battle.BattleUpdateTeamPokemonPacket;
import com.cobblemon.mod.common.net.messages.client.pokemon.update.AbilityUpdatePacket;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.cobblemon.mod.common.pokemon.Species;
import com.cobblemon.yajatkaul.mega_showdown.Config;
import com.cobblemon.yajatkaul.mega_showdown.MegaShowdown;
import com.cobblemon.yajatkaul.mega_showdown.advancement.AdvancementHelper;
import com.cobblemon.yajatkaul.mega_showdown.datamanage.DataManage;
import com.cobblemon.yajatkaul.mega_showdown.item.MegaStones;
import com.cobblemon.yajatkaul.mega_showdown.item.ModItems;
import com.cobblemon.yajatkaul.mega_showdown.item.TeraMoves;
import com.cobblemon.yajatkaul.mega_showdown.item.ZMoves;
import com.cobblemon.yajatkaul.mega_showdown.item.custom.TeraItem;
import com.cobblemon.yajatkaul.mega_showdown.item.custom.ZRingItem;
import com.cobblemon.yajatkaul.mega_showdown.megaevo.MegaLogic;
import com.cobblemon.yajatkaul.mega_showdown.utility.TeraTypeHelper;
import com.cobblemon.yajatkaul.mega_showdown.utility.Utils;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import kotlin.Unit;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.ServerScoreboard;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.scores.PlayerTeam;
import net.neoforged.neoforge.registries.DeferredItem;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotResult;
import top.theillusivec4.curios.api.type.capability.ICuriosItemHandler;

public class CobbleEventsHandler {
    public static Unit onHeldItemChange(HeldItemEvent.Post event) {
        if (event.getReturned() == event.getReceived() || event.getPokemon().getOwnerPlayer() == null) {
            return Unit.INSTANCE;
        }
        CobbleEventsHandler.checkUltra(event);
        CobbleEventsHandler.primalEvent(event);
        CobbleEventsHandler.crownedEvent(event);
        CobbleEventsHandler.ogerponChange(event);
        CobbleEventsHandler.eternamaxChange(event);
        CobbleEventsHandler.originChange(event);
        if (Config.battleModeOnly) {
            return Unit.INSTANCE;
        }
        CobbleEventsHandler.megaEvent(event);
        return Unit.INSTANCE;
    }

    public static Unit onReleasePokemon(ReleasePokemonEvent.Post post) {
        if (post.getPlayer().level().isClientSide) {
            return Unit.INSTANCE;
        }
        if (!post.getPlayer().level().isClientSide && post.getPlayer().getData(DataManage.MEGA_POKEMON) == post.getPokemon()) {
            post.getPlayer().setData(DataManage.MEGA_DATA, (Object)false);
            post.getPlayer().removeData(DataManage.MEGA_POKEMON);
        }
        if (!post.getPlayer().level().isClientSide && post.getPlayer().getData(DataManage.PRIMAL_POKEMON) == post.getPokemon()) {
            post.getPlayer().setData(DataManage.PRIMAL_DATA, (Object)false);
            post.getPlayer().removeData(DataManage.PRIMAL_POKEMON);
        }
        return Unit.INSTANCE;
    }

    public static void originChange(HeldItemEvent.Post post) {
        Pokemon pokemon = post.getPokemon();
        if (pokemon.getSpecies().getName().equals("Giratina")) {
            if (post.getReceived().is(ModItems.GRISEOUS_ORB)) {
                CobbleEventsHandler.originAnimation((LivingEntity)pokemon.getEntity());
                new StringSpeciesFeature("orb_forme", "origin").apply(pokemon);
            } else {
                CobbleEventsHandler.originAnimation((LivingEntity)pokemon.getEntity());
                new StringSpeciesFeature("orb_forme", "altered").apply(pokemon);
            }
        }
    }

    public static void eternamaxChange(HeldItemEvent.Post post) {
        if (!Config.etermaxForme) {
            return;
        }
        Pokemon pokemon = post.getPokemon();
        if (pokemon.getSpecies().getName().equals("Eternatus") && post.getReceived().is(ModItems.STAR_CORE)) {
            new FlagSpeciesFeature("eternamax", true).apply(pokemon);
        } else if (pokemon.getSpecies().getName().equals("Eternatus")) {
            new FlagSpeciesFeature("eternamax", false).apply(pokemon);
        }
    }

    public static void ogerponChange(HeldItemEvent.Post post) {
        Pokemon pokemon = post.getPokemon();
        if (!pokemon.getSpecies().getName().equals("Ogerpon")) {
            return;
        }
        if (post.getReceived().is(ModItems.HEARTHFLAME_MASK)) {
            new StringSpeciesFeature("ogre_mask", "hearthflame").apply(pokemon);
            try {
                pokemon.setTeraType(TeraTypes.getFIRE());
            }
            catch (Exception e) {
                MegaShowdown.LOGGER.info("Sike");
            }
        } else if (post.getReceived().is(ModItems.CORNERSTONE_MASK)) {
            new StringSpeciesFeature("ogre_mask", "cornerstone").apply(pokemon);
            try {
                pokemon.setTeraType(TeraTypes.getGROUND());
            }
            catch (Exception e) {
                MegaShowdown.LOGGER.info("Sike");
            }
        } else if (post.getReceived().is(ModItems.WELLSPRING_MASK)) {
            new StringSpeciesFeature("ogre_mask", "wellspring").apply(pokemon);
            try {
                pokemon.setTeraType(TeraTypes.getWATER());
            }
            catch (Exception e) {
                MegaShowdown.LOGGER.info("Sike");
            }
        } else {
            new StringSpeciesFeature("ogre_mask", "teal").apply(pokemon);
            try {
                pokemon.setTeraType(TeraTypes.getGRASS());
            }
            catch (Exception e) {
                MegaShowdown.LOGGER.info("Sike");
            }
        }
    }

    public static void primalEvent(HeldItemEvent.Post post) {
        ServerPlayer player = post.getPokemon().getOwnerPlayer();
        Species species = post.getPokemon().getSpecies();
        if (species.getName().equals(Utils.getSpecies("kyogre").getName()) && post.getReceived().is(MegaStones.BLUE_ORB)) {
            if (((Boolean)player.getData(DataManage.PRIMAL_DATA)).booleanValue() && !Config.multiplePrimals) {
                player.displayClientMessage((Component)Component.literal((String)"You can only have one primal at a time").withColor(0xFF0000), true);
                return;
            }
            new FlagSpeciesFeature("primal", true).apply(post.getPokemon());
            CobbleEventsHandler.primalRevertAnimation((LivingEntity)post.getPokemon().getEntity(), ParticleTypes.BUBBLE);
            AdvancementHelper.grantAdvancement(player, "primal_evo");
            player.setData(DataManage.PRIMAL_DATA, (Object)true);
            Utils.setTradable(post.getPokemon(), false);
        } else if (species.getName().equals(Utils.getSpecies("groudon").getName()) && post.getReceived().is(MegaStones.RED_ORB)) {
            if (((Boolean)player.getData(DataManage.PRIMAL_DATA)).booleanValue() && !Config.multiplePrimals) {
                player.displayClientMessage((Component)Component.literal((String)"You can only have one primal at a time").withColor(0xFF0000), true);
                return;
            }
            new FlagSpeciesFeature("primal", true).apply(post.getPokemon());
            CobbleEventsHandler.primalRevertAnimation((LivingEntity)post.getPokemon().getEntity(), ParticleTypes.CAMPFIRE_COSY_SMOKE);
            AdvancementHelper.grantAdvancement(player, "primal_evo");
            player.setData(DataManage.PRIMAL_DATA, (Object)true);
            Utils.setTradable(post.getPokemon(), false);
        } else {
            SpeciesFeature feature = post.getPokemon().getFeature("primal");
            if (feature == null) {
                return;
            }
            new FlagSpeciesFeature("primal", false).apply(post.getPokemon());
            CobbleEventsHandler.primalRevertAnimation((LivingEntity)post.getPokemon().getEntity(), ParticleTypes.END_ROD);
            player.setData(DataManage.PRIMAL_DATA, (Object)false);
            Utils.setTradable(post.getPokemon(), true);
        }
    }

    public static void megaEvent(HeldItemEvent.Post event) {
        Pokemon pokemon = event.getPokemon();
        if (pokemon.getEntity() == null) {
            return;
        }
        Species species = Utils.MEGA_STONE_IDS.get(pokemon.heldItem().getItem());
        if (pokemon.getEntity().level().isClientSide) {
            return;
        }
        List<String> megaKeys = List.of("mega-x", "mega-y", "mega");
        for (String key : megaKeys) {
            FlagSpeciesFeatureProvider featureProvider = new FlagSpeciesFeatureProvider(List.of(key));
            ServerPlayer player = pokemon.getOwnerPlayer();
            FlagSpeciesFeature feature = featureProvider.get(pokemon);
            if (feature == null) continue;
            boolean enabled = featureProvider.get(pokemon).getEnabled();
            if (enabled && feature.getName().equals("mega") && (species != pokemon.getSpecies() || event.getReceived() != event.getReturned())) {
                MegaLogic.Devolve((LivingEntity)pokemon.getEntity(), (Player)player, true);
                continue;
            }
            if (enabled && feature.getName().equals("mega-x") && (species != pokemon.getSpecies() || event.getReceived() != event.getReturned())) {
                MegaLogic.Devolve((LivingEntity)pokemon.getEntity(), (Player)player, true);
                continue;
            }
            if (!enabled || !feature.getName().equals("mega-y") || species == pokemon.getSpecies() && event.getReceived() == event.getReturned()) continue;
            MegaLogic.Devolve((LivingEntity)pokemon.getEntity(), (Player)player, true);
        }
    }

    public static void crownedEvent(HeldItemEvent.Post event) {
        Pokemon pokemon = event.getPokemon();
        if (pokemon.getSpecies().getName().equals("Zacian") || pokemon.getSpecies().getName().equals("Zamazenta")) {
            if (event.getReceived().is(ModItems.RUSTED_SWORD) && pokemon.getSpecies().getName().equals("Zacian")) {
                CobbleEventsHandler.crownAnimation((ServerLevel)pokemon.getEntity().level(), pokemon.getEntity().getOnPos(), (LivingEntity)pokemon.getEntity());
                new FlagSpeciesFeature("crowned", true).apply(pokemon);
                Utils.setTradable(pokemon, false);
            } else if (event.getReceived().is(ModItems.RUSTED_SHIELD) && pokemon.getSpecies().getName().equals("Zamazenta")) {
                CobbleEventsHandler.crownAnimation((ServerLevel)pokemon.getEntity().level(), pokemon.getEntity().getOnPos(), (LivingEntity)pokemon.getEntity());
                new FlagSpeciesFeature("crowned", true).apply(pokemon);
                Utils.setTradable(pokemon, false);
            } else if (pokemon.getSpecies().getName().equals("Zacian") && event.getReturned().is(ModItems.RUSTED_SWORD)) {
                CobbleEventsHandler.playEvolveAnimation((LivingEntity)pokemon.getEntity());
                new FlagSpeciesFeature("crowned", false).apply(pokemon);
                Utils.setTradable(pokemon, true);
            } else if (pokemon.getSpecies().getName().equals("Zamazenta") && event.getReturned().is(ModItems.RUSTED_SHIELD)) {
                CobbleEventsHandler.playEvolveAnimation((LivingEntity)pokemon.getEntity());
                new FlagSpeciesFeature("crowned", false).apply(pokemon);
                Utils.setTradable(pokemon, true);
            }
        }
    }

    public static void checkUltra(HeldItemEvent.Post event) {
        Pokemon pokemon = event.getPokemon();
        if (pokemon.getSpecies().getName().equals("Necrozma") && event.getReturned().is(ZMoves.ULTRANECROZIUM_Z)) {
            CobbleEventsHandler.ultraAnimation((LivingEntity)pokemon.getEntity());
            new FlagSpeciesFeature("ultra", false).apply(pokemon);
        }
    }

    public static void ultraAnimation(LivingEntity context) {
        Level level = context.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            Vec3 entityPos = context.position();
            double entityWidth = context.getBbWidth();
            double entityHeight = context.getBbHeight();
            double scaleFactor = 1.2;
            double adjustedWidth = entityWidth * scaleFactor;
            double adjustedHeight = entityHeight * scaleFactor;
            double adjustedDepth = entityWidth * scaleFactor;
            serverLevel.playSound(null, entityPos.x, entityPos.y, entityPos.z, SoundEvents.BEACON_ACTIVATE, SoundSource.PLAYERS, 1.5f, 0.5f + (float)Math.random() * 0.5f);
            int particleCount = (int)(175.0 * adjustedWidth * adjustedHeight);
            for (int i = 0; i < particleCount; ++i) {
                double xOffset = (Math.random() - 0.5) * adjustedWidth;
                double yOffset = Math.random() * adjustedHeight;
                double zOffset = (Math.random() - 0.5) * adjustedDepth;
                serverLevel.sendParticles((ParticleOptions)ParticleTypes.GLOW, entityPos.x + xOffset, entityPos.y + yOffset, entityPos.z + zOffset, 1, 0.0, 0.0, 0.0, 0.1);
            }
        }
    }

    private static void primalRevertAnimation(LivingEntity context, SimpleParticleType particleType) {
        Level level = context.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            Vec3 entityPos = context.position();
            double entityWidth = context.getBbWidth();
            double entityHeight = context.getBbHeight();
            double entityDepth = entityWidth;
            double scaleFactor = 1.2;
            double adjustedWidth = entityWidth * scaleFactor;
            double adjustedHeight = entityHeight * scaleFactor;
            double adjustedDepth = entityDepth * scaleFactor;
            serverLevel.playSound(null, entityPos.x, entityPos.y, entityPos.z, SoundEvents.BEACON_ACTIVATE, SoundSource.PLAYERS, 1.5f, 0.5f + (float)Math.random() * 0.5f);
            int particleCount = (int)(175.0 * adjustedWidth * adjustedHeight);
            for (int i = 0; i < particleCount; ++i) {
                double xOffset = (Math.random() - 0.5) * adjustedWidth;
                double yOffset = Math.random() * adjustedHeight;
                double zOffset = (Math.random() - 0.5) * adjustedDepth;
                serverLevel.sendParticles((ParticleOptions)particleType, entityPos.x + xOffset, entityPos.y + yOffset, entityPos.z + zOffset, 1, 0.0, 0.0, 0.0, 0.1);
            }
        }
    }

    private static void originAnimation(LivingEntity context) {
        Level level = context.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            Vec3 entityPos = context.position();
            double entityWidth = context.getBbWidth();
            double entityHeight = context.getBbHeight();
            double entityDepth = entityWidth;
            double scaleFactor = 2.0;
            double adjustedWidth = entityWidth * scaleFactor;
            double adjustedHeight = entityHeight * scaleFactor;
            double adjustedDepth = entityDepth * scaleFactor;
            serverLevel.playSound(null, entityPos.x, entityPos.y, entityPos.z, (Holder)SoundEvents.NOTE_BLOCK_IMITATE_ENDER_DRAGON, SoundSource.PLAYERS, 1.5f, 0.5f + (float)Math.random() * 0.5f);
            int particleCount = (int)(175.0 * adjustedWidth * adjustedHeight);
            for (int i = 0; i < particleCount; ++i) {
                double xOffset = (Math.random() - 0.5) * adjustedWidth;
                double yOffset = Math.random() * adjustedHeight;
                double zOffset = (Math.random() - 0.5) * adjustedDepth;
                serverLevel.sendParticles((ParticleOptions)ParticleTypes.ASH, entityPos.x + xOffset, entityPos.y + yOffset, entityPos.z + zOffset, 1, 0.0, 0.0, 0.0, 0.1);
            }
        }
    }

    private static void crownAnimation(ServerLevel level, BlockPos pos, LivingEntity context) {
        LightningBolt lightning = (LightningBolt)EntityType.LIGHTNING_BOLT.create((Level)level);
        if (lightning != null) {
            lightning.moveTo(Vec3.atBottomCenterOf((Vec3i)pos));
            lightning.setVisualOnly(true);
            level.addFreshEntity((Entity)lightning);
            CobbleEventsHandler.playEvolveAnimation(context);
        }
    }

    public static void playEvolveAnimation(LivingEntity context) {
        Level level = context.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            Vec3 entityPos = context.position();
            double entityWidth = context.getBbWidth();
            double entityHeight = context.getBbHeight();
            serverLevel.playSound(null, entityPos.x, entityPos.y, entityPos.z, SoundEvents.AMETHYST_BLOCK_CHIME, SoundSource.PLAYERS, 1.5f, 0.5f + (float)Math.random() * 0.5f);
            int particleCount = (int)(100.0 * entityWidth * entityHeight);
            double radius = entityWidth * 0.8;
            for (int i = 0; i < particleCount; ++i) {
                double angle = Math.random() * 2.0 * Math.PI;
                double xOffset = Math.cos(angle) * radius;
                double zOffset = Math.sin(angle) * radius;
                double yOffset = Math.random() * entityHeight;
                serverLevel.sendParticles((ParticleOptions)ParticleTypes.END_ROD, entityPos.x + xOffset, entityPos.y + yOffset, entityPos.z + zOffset, 1, 0.0, 0.0, 0.0, 0.1);
            }
        }
    }

    public static void checkKeldeo(PlayerPartyStore pokemons) {
        for (Pokemon pokemon : pokemons) {
            if (!pokemon.getSpecies().getName().equals("Keldeo")) continue;
            FlagSpeciesFeatureProvider featureProvider = new FlagSpeciesFeatureProvider(List.of("resolute"));
            FlagSpeciesFeature feature = featureProvider.get(pokemon);
            boolean hasMove = false;
            for (Move move : pokemon.getMoveSet().getMoves()) {
                if (!move.getName().equals(Moves.INSTANCE.getByName("secretsword").getName())) continue;
                hasMove = true;
            }
            if (feature == null) continue;
            boolean enabled = featureProvider.get(pokemon).getEnabled();
            if (!enabled) {
                if (!hasMove) continue;
                new FlagSpeciesFeature("resolute", true).apply(pokemon);
                CobbleEventsHandler.playEvolveAnimation((LivingEntity)pokemon.getEntity());
                continue;
            }
            if (hasMove) continue;
            new FlagSpeciesFeature("resolute", false).apply(pokemon);
            CobbleEventsHandler.playEvolveAnimation((LivingEntity)pokemon.getEntity());
        }
    }

    public static Unit battleStarted(BattleStartedPreEvent battleEvent) {
        for (ServerPlayer player : battleEvent.getBattle().getPlayers()) {
            PlayerPartyStore playerPartyStore = Cobblemon.INSTANCE.getStorage().getParty(player);
            CobbleEventsHandler.checkKeldeo(playerPartyStore);
            if (Config.battleMode) {
                for (Pokemon pokemon : playerPartyStore) {
                    List<String> megaKeys = List.of("mega-x", "mega-y", "mega");
                    for (String key : megaKeys) {
                        boolean enabled;
                        FlagSpeciesFeatureProvider featureProvider = new FlagSpeciesFeatureProvider(List.of(key));
                        FlagSpeciesFeature feature = featureProvider.get(pokemon);
                        if (feature == null || !(enabled = featureProvider.get(pokemon).getEnabled())) continue;
                        MegaLogic.Devolve((LivingEntity)pokemon.getEntity(), (Player)player, true);
                    }
                }
            }
            GeneralPlayerData data = Cobblemon.INSTANCE.getPlayerDataManager().getGenericData(player);
            boolean hasTeraItemCurios = CuriosApi.getCuriosInventory((LivingEntity)player).map(inventory -> inventory.isEquipped(stack -> stack.getItem() instanceof TeraItem)).orElse(false);
            ItemStack teraOrb = CuriosApi.getCuriosInventory((LivingEntity)player).flatMap(curiosInventory -> curiosInventory.findFirstCurio((Item)TeraMoves.TERA_ORB.get())).map(SlotResult::stack).orElse(null);
            if (teraOrb != null && teraOrb.getDamageValue() >= 100) {
                hasTeraItemCurios = false;
            }
            if (hasTeraItemCurios && Config.teralization) {
                data.getKeyItems().add(ResourceLocation.fromNamespaceAndPath((String)"cobblemon", (String)"tera_orb"));
            } else {
                data.getKeyItems().remove(ResourceLocation.fromNamespaceAndPath((String)"cobblemon", (String)"tera_orb"));
            }
            if ((Config.battleMode || Config.scuffedMode || Config.battleModeOnly) && MegaLogic.Possible(player, true) && !((Boolean)player.getData(DataManage.MEGA_DATA)).booleanValue()) {
                data.getKeyItems().add(ResourceLocation.fromNamespaceAndPath((String)"cobblemon", (String)"key_stone"));
            } else {
                data.getKeyItems().remove(ResourceLocation.fromNamespaceAndPath((String)"cobblemon", (String)"key_stone"));
            }
            boolean hasZItemCurios = CuriosApi.getCuriosInventory((LivingEntity)player).map(inventory -> inventory.isEquipped(stack -> stack.getItem() instanceof ZRingItem)).orElse(false);
            if ((player.getOffhandItem().is(ZMoves.Z_RING) || hasZItemCurios) && Config.zMoves) {
                data.getKeyItems().add(ResourceLocation.fromNamespaceAndPath((String)"cobblemon", (String)"z_ring"));
                continue;
            }
            data.getKeyItems().remove(ResourceLocation.fromNamespaceAndPath((String)"cobblemon", (String)"z_ring"));
        }
        return Unit.INSTANCE;
    }

    public static Unit megaEvolution(MegaEvolutionEvent megaEvolutionEvent) {
        PokemonBattle battle = megaEvolutionEvent.getBattle();
        Pokemon pokemon = megaEvolutionEvent.getPokemon().getEffectedPokemon();
        ServerPlayer player = megaEvolutionEvent.getPokemon().getOriginalPokemon().getOwnerPlayer();
        if (player == null) {
            return Unit.INSTANCE;
        }
        MegaLogic.Evolve((LivingEntity)pokemon.getEntity(), (Player)player, true);
        battle.sendUpdate((NetworkPacket)new AbilityUpdatePacket(() -> ((BattlePokemon)megaEvolutionEvent.getPokemon()).getEffectedPokemon(), pokemon.getAbility().getTemplate()));
        battle.sendUpdate((NetworkPacket)new BattleUpdateTeamPokemonPacket(pokemon));
        return Unit.INSTANCE;
    }

    public static Unit battleEnded(BattleVictoryEvent battleVictoryEvent) {
        battleVictoryEvent.getBattle().getPlayers().forEach(serverPlayer -> {
            PlayerPartyStore playerPartyStore = Cobblemon.INSTANCE.getStorage().getParty(serverPlayer);
            for (Pokemon pokemon : playerPartyStore) {
                if (pokemon.getEntity() == null) continue;
                new StringSpeciesFeature("stance_forme", "shield").apply(pokemon);
                new FlagSpeciesFeature("embody_aspect", false).apply(pokemon);
                pokemon.getEntity().removeEffect(MobEffects.GLOWING);
            }
            block1: for (BattlePokemon battlePokemon : battleVictoryEvent.getBattle().getActor(serverPlayer.getUUID()).getPokemonList()) {
                if (battlePokemon.getOriginalPokemon().getEntity() == null) continue;
                Pokemon pokemon = battlePokemon.getOriginalPokemon();
                List<String> megaKeys = List.of("mega-x", "mega-y", "mega");
                for (String key : megaKeys) {
                    boolean enabled;
                    FlagSpeciesFeatureProvider featureProvider = new FlagSpeciesFeatureProvider(List.of(key));
                    FlagSpeciesFeature feature = featureProvider.get(pokemon);
                    if (feature == null || !(enabled = featureProvider.get(pokemon).getEnabled())) continue;
                    MegaLogic.Devolve((LivingEntity)pokemon.getEntity(), (Player)serverPlayer, true);
                    if (Config.multipleMegas) continue;
                    continue block1;
                }
            }
        });
        return Unit.INSTANCE;
    }

    public static Unit devolveFainted(BattleFaintedEvent battleFaintedEvent) {
        Pokemon pokemon = battleFaintedEvent.getKilled().getOriginalPokemon();
        ServerPlayer serverPlayer = battleFaintedEvent.getKilled().getOriginalPokemon().getOwnerPlayer();
        if (serverPlayer == null) {
            return Unit.INSTANCE;
        }
        List<String> megaKeys = List.of("mega-x", "mega-y", "mega");
        for (String key : megaKeys) {
            boolean enabled;
            FlagSpeciesFeatureProvider featureProvider = new FlagSpeciesFeatureProvider(List.of(key));
            FlagSpeciesFeature feature = featureProvider.get(pokemon);
            if (feature == null || !(enabled = featureProvider.get(pokemon).getEnabled())) continue;
            MegaLogic.Devolve((LivingEntity)pokemon.getEntity(), (Player)serverPlayer, true);
            break;
        }
        return Unit.INSTANCE;
    }

    public static Unit deVolveFlee(BattleFledEvent battleFledEvent) {
        battleFledEvent.getBattle().getPlayers().forEach(serverPlayer -> {
            block0: for (BattlePokemon battlePokemon : battleFledEvent.getBattle().getActor(serverPlayer.getUUID()).getPokemonList()) {
                if (battlePokemon.getOriginalPokemon().getEntity() == null || battlePokemon.getOriginalPokemon().getEntity().level().isClientSide) continue;
                PlayerPartyStore playerPartyStore = Cobblemon.INSTANCE.getStorage().getParty(serverPlayer);
                for (Pokemon pokemon : playerPartyStore) {
                    if (pokemon.getEntity() == null) continue;
                    new StringSpeciesFeature("stance_forme", "shield").apply(pokemon);
                    new FlagSpeciesFeature("embody_aspect", false).apply(pokemon);
                    pokemon.getEntity().removeEffect(MobEffects.GLOWING);
                }
                Pokemon pokemon = battlePokemon.getOriginalPokemon();
                List<String> megaKeys = List.of("mega-x", "mega-y", "mega");
                for (String key : megaKeys) {
                    boolean enabled;
                    FlagSpeciesFeatureProvider featureProvider = new FlagSpeciesFeatureProvider(List.of(key));
                    FlagSpeciesFeature feature = featureProvider.get(pokemon);
                    if (feature == null || !(enabled = featureProvider.get(pokemon).getEnabled())) continue;
                    MegaLogic.Devolve((LivingEntity)pokemon.getEntity(), (Player)serverPlayer, true);
                    if (Config.multipleMegas) continue;
                    continue block0;
                }
            }
        });
        return Unit.INSTANCE;
    }

    public static Unit zMovesUsed(ZMoveUsedEvent zMoveUsedEvent) {
        PokemonEntity pokemon = zMoveUsedEvent.getPokemon().getEffectedPokemon().getEntity();
        Pokemon pk = zMoveUsedEvent.getPokemon().getEffectedPokemon();
        pokemon.addEffect(new MobEffectInstance(MobEffects.GLOWING, 115, 0, false, false));
        Level level = pokemon.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            AdvancementHelper.grantAdvancement(pk.getOwnerPlayer(), "z_moves");
            ServerScoreboard scoreboard = serverLevel.getScoreboard();
            String teamName = "glow_" + UUID.randomUUID().toString().substring(0, 8);
            PlayerTeam team = scoreboard.getPlayerTeam(teamName);
            if (team == null) {
                team = scoreboard.addPlayerTeam(teamName);
                team.setColor(TeraTypeHelper.getGlowColorForType(zMoveUsedEvent.getPokemon().getOriginalPokemon()));
                team.setSeeFriendlyInvisibles(false);
                team.setAllowFriendlyFire(true);
            }
            scoreboard.addPlayerToTeam(pokemon.getScoreboardName(), team);
        }
        return Unit.INSTANCE;
    }

    public static Unit terrastallizationUsed(TerastallizationEvent terastallizationEvent) {
        ItemStack teraOrb;
        PokemonEntity pokemon = terastallizationEvent.getPokemon().getEffectedPokemon().getEntity();
        Pokemon pk = terastallizationEvent.getPokemon().getEffectedPokemon();
        pokemon.addEffect(new MobEffectInstance(MobEffects.GLOWING, Integer.MAX_VALUE, 0, false, false));
        Level level = pokemon.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            AdvancementHelper.grantAdvancement(pk.getOwnerPlayer(), "terastallized");
            ServerScoreboard scoreboard = serverLevel.getScoreboard();
            String teamName = "glow_" + UUID.randomUUID().toString().substring(0, 8);
            PlayerTeam team = scoreboard.getPlayerTeam(teamName);
            TeraType teraType = terastallizationEvent.getPokemon().getEffectedPokemon().getTeraType();
            ChatFormatting color = TeraTypeHelper.getGlowColorForTeraType(teraType);
            if (team == null) {
                team = scoreboard.addPlayerTeam(teamName);
                team.setColor(color);
                team.setSeeFriendlyInvisibles(false);
                team.setAllowFriendlyFire(true);
            }
            scoreboard.addPlayerToTeam(pokemon.getScoreboardName(), team);
            if (pk.getSpecies().getName().equals("Ogerpon")) {
                new FlagSpeciesFeature("embody_aspect", true).apply(pk);
            }
        }
        if ((teraOrb = ((SlotResult)((ICuriosItemHandler)CuriosApi.getCuriosInventory((LivingEntity)terastallizationEvent.getPokemon().getEffectedPokemon().getOwnerPlayer()).get()).findFirstCurio((Item)TeraMoves.TERA_ORB.get()).get()).stack()) != null) {
            teraOrb.setDamageValue(teraOrb.getDamageValue() + 10);
        }
        return Unit.INSTANCE;
    }

    public static Unit healedPokemons(PokemonHealedEvent pokemonHealedEvent) {
        if (pokemonHealedEvent.getPokemon().getOwnerPlayer() == null) {
            return Unit.INSTANCE;
        }
        ItemStack teraOrb = CuriosApi.getCuriosInventory((LivingEntity)pokemonHealedEvent.getPokemon().getOwnerPlayer()).flatMap(curiosInventory -> curiosInventory.findFirstCurio((Item)TeraMoves.TERA_ORB.get())).map(SlotResult::stack).orElse(null);
        if (teraOrb != null) {
            teraOrb.setDamageValue(0);
        }
        return Unit.INSTANCE;
    }

    public static Unit dropShardPokemon(LootDroppedEvent lootDroppedEvent) {
        if (!(lootDroppedEvent.getEntity() instanceof PokemonEntity)) {
            return Unit.INSTANCE;
        }
        Pokemon pokemon = ((PokemonEntity)lootDroppedEvent.getEntity()).getPokemon();
        DeferredItem<Item> correspondingTeraShard = TeraTypeHelper.getTeraShardForType(pokemon.getTypes());
        ItemDropEntry teraShardDropEntry = new ItemDropEntry();
        teraShardDropEntry.setItem(BuiltInRegistries.ITEM.getKey((Object)((Item)correspondingTeraShard.get())));
        int randomValue = new Random().nextInt(101);
        if (randomValue >= 10 && randomValue <= 20) {
            lootDroppedEvent.getDrops().add(teraShardDropEntry);
        } else if (randomValue == 33) {
            teraShardDropEntry.setItem(BuiltInRegistries.ITEM.getKey((Object)((Item)TeraMoves.STELLAR_TERA_SHARD.get())));
            lootDroppedEvent.getDrops().add(teraShardDropEntry);
        }
        return Unit.INSTANCE;
    }

    public static Unit formeChanges(FormeChangeEvent formeChangeEvent) {
        Pokemon pokemon = formeChangeEvent.getPokemon().getEffectedPokemon();
        if (pokemon.getSpecies().getName().equals("Aegislash")) {
            if (formeChangeEvent.getFormeName().equals("blade")) {
                new StringSpeciesFeature("stance_forme", "blade").apply(pokemon);
            } else if (formeChangeEvent.getFormeName().equals("aegislash")) {
                new StringSpeciesFeature("stance_forme", "shield").apply(pokemon);
            }
        }
        return Unit.INSTANCE;
    }

    public static Unit fixOgerTera(PokemonCapturedEvent pokemonCapturedEvent) {
        Pokemon pokemon = pokemonCapturedEvent.getPokemon();
        if (pokemon.getSpecies().getName().equals("Ogerpon")) {
            pokemon.setTeraType(TeraTypes.getGRASS());
        }
        return Unit.INSTANCE;
    }
}

