/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.yajatkaul.mega_showdown.item.custom.fusion;

import com.cobblemon.mod.common.Cobblemon;
import com.cobblemon.mod.common.api.pokemon.feature.FlagSpeciesFeature;
import com.cobblemon.mod.common.api.pokemon.feature.FlagSpeciesFeatureProvider;
import com.cobblemon.mod.common.api.storage.party.PlayerPartyStore;
import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.cobblemon.yajatkaul.mega_showdown.advancement.AdvancementHelper;
import com.cobblemon.yajatkaul.mega_showdown.datamanage.DataManage;
import com.cobblemon.yajatkaul.mega_showdown.datamanage.PokemonRef;
import com.cobblemon.yajatkaul.mega_showdown.utility.Utils;
import java.util.HashMap;
import java.util.List;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class N_Solarizer
extends Item {
    public N_Solarizer(Item.Properties arg) {
        super(arg);
    }

    public InteractionResult interactLivingEntity(ItemStack arg, Player player, @NotNull LivingEntity context, InteractionHand hand) {
        if (player.level().isClientSide) {
            return InteractionResult.PASS;
        }
        if (!(context instanceof PokemonEntity)) {
            return InteractionResult.PASS;
        }
        PokemonEntity pk = (PokemonEntity)context;
        Pokemon pokemon = pk.getPokemon();
        if (pokemon.getOwnerPlayer() != player) {
            return InteractionResult.PASS;
        }
        PlayerPartyStore playerPartyStore = Cobblemon.INSTANCE.getStorage().getParty((ServerPlayer)player);
        PokemonRef refValue = (PokemonRef)arg.getOrDefault(DataManage.N_SOLAR, null);
        Pokemon currentValue = refValue == null ? null : refValue.getPokemon();
        if (currentValue != null && pokemon.getSpecies().getName().equals("Necrozma")) {
            if (this.checkFused(pokemon)) {
                player.displayClientMessage((Component)Component.literal((String)"Already fused!").withColor(0xFF0000), true);
                return InteractionResult.PASS;
            }
            HashMap map = (HashMap)player.getData(DataManage.DATA_MAP);
            map.put(pokemon.getUuid(), currentValue);
            player.setData(DataManage.DATA_MAP, (Object)map);
            pk.setData(DataManage.N_SOLAR_POKEMON, (Object)currentValue);
            arg.set(DataManage.N_SOLAR, null);
            new FlagSpeciesFeature("dusk-fusion", true).apply(pokemon);
            Utils.setTradable(pokemon, false);
            AdvancementHelper.grantAdvancement((ServerPlayer)player, "fusion");
            arg.set(DataComponents.CUSTOM_NAME, (Object)Component.translatable((String)"item.mega_showdown.n_solarizer.inactive"));
        } else if (currentValue == null && pokemon.getSpecies().getName().equals("Solgaleo")) {
            arg.set(DataManage.N_SOLAR, (Object)new PokemonRef(pokemon));
            playerPartyStore.remove(pokemon);
            arg.set(DataComponents.CUSTOM_NAME, (Object)Component.translatable((String)"item.mega_showdown.n_solarizer.charged"));
        } else if (pokemon.getSpecies().getName().equals("Necrozma") && this.checkEnabled(pokemon)) {
            boolean enabled;
            FlagSpeciesFeatureProvider featureProvider = new FlagSpeciesFeatureProvider(List.of("ultra"));
            FlagSpeciesFeature feature = featureProvider.get(pokemon);
            if (feature != null && (enabled = featureProvider.get(pokemon).getEnabled())) {
                return InteractionResult.PASS;
            }
            if (!pokemon.getEntity().hasData(DataManage.N_SOLAR_POKEMON)) {
                HashMap map = (HashMap)player.getData(DataManage.DATA_MAP);
                Pokemon toAdd = (Pokemon)map.get(pokemon.getUuid());
                playerPartyStore.add(toAdd);
                map.remove(pokemon.getUuid());
                player.setData(DataManage.DATA_MAP, (Object)map);
            } else {
                playerPartyStore.add((Pokemon)pokemon.getEntity().getData(DataManage.N_SOLAR_POKEMON));
                pk.removeData(DataManage.N_SOLAR_POKEMON);
            }
            new FlagSpeciesFeature("dusk-fusion", false).apply(pokemon);
            Utils.setTradable(pokemon, true);
            arg.set(DataComponents.CUSTOM_NAME, (Object)Component.translatable((String)"item.mega_showdown.n_solarizer.inactive"));
        } else {
            return InteractionResult.PASS;
        }
        player.setItemInHand(hand, arg);
        player.getInventory().setChanged();
        return InteractionResult.SUCCESS;
    }

    private boolean checkEnabled(Pokemon pokemon) {
        FlagSpeciesFeatureProvider featureProvider = new FlagSpeciesFeatureProvider(List.of("dusk-fusion"));
        FlagSpeciesFeature feature = featureProvider.get(pokemon);
        if (feature != null) {
            return featureProvider.get(pokemon).getEnabled();
        }
        return false;
    }

    private boolean checkFused(Pokemon pokemon) {
        boolean enabled;
        FlagSpeciesFeatureProvider featureProvider = new FlagSpeciesFeatureProvider(List.of("dusk-fusion"));
        FlagSpeciesFeature feature = featureProvider.get(pokemon);
        if (feature != null && (enabled = featureProvider.get(pokemon).getEnabled())) {
            return true;
        }
        featureProvider = new FlagSpeciesFeatureProvider(List.of("dawn-fusion"));
        feature = featureProvider.get(pokemon);
        return feature != null && (enabled = featureProvider.get(pokemon).getEnabled());
    }

    public void onDestroyed(ItemEntity entity, DamageSource damageSource) {
        Entity entity2 = entity.getOwner();
        if (entity2 instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity2;
            PokemonRef refValue = (PokemonRef)entity.getItem().getOrDefault(DataManage.N_SOLAR, null);
            Pokemon currentValue = refValue == null ? null : refValue.getPokemon();
            PlayerPartyStore playerPartyStore = Cobblemon.INSTANCE.getStorage().getParty(player);
            if (currentValue != null) {
                playerPartyStore.add(currentValue);
                entity.getItem().set(DataManage.N_SOLAR, null);
            }
        }
        super.onDestroyed(entity, damageSource);
    }
}

