/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.yajatkaul.mega_showdown.item.custom.fusion;

import com.cobblemon.mod.common.Cobblemon;
import com.cobblemon.mod.common.api.pokemon.feature.FlagSpeciesFeature;
import com.cobblemon.mod.common.api.pokemon.feature.FlagSpeciesFeatureProvider;
import com.cobblemon.mod.common.api.storage.party.PlayerPartyStore;
import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.cobblemon.yajatkaul.mega_showdown.advancement.AdvancementHelper;
import com.cobblemon.yajatkaul.mega_showdown.datamanage.DataManage;
import com.cobblemon.yajatkaul.mega_showdown.datamanage.PokemonRef;
import java.util.HashMap;
import java.util.List;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class Unity
extends Item {
    public Unity(Item.Properties arg) {
        super(arg);
    }

    public InteractionResult interactLivingEntity(ItemStack arg, Player player, @NotNull LivingEntity conComponent, InteractionHand hand) {
        if (player.level().isClientSide) {
            return InteractionResult.PASS;
        }
        if (!(conComponent instanceof PokemonEntity)) {
            return InteractionResult.PASS;
        }
        PokemonEntity pk = (PokemonEntity)conComponent;
        Pokemon pokemon = pk.getPokemon();
        if (pokemon.getOwnerPlayer() != player) {
            return InteractionResult.PASS;
        }
        PlayerPartyStore playerPartyStore = Cobblemon.INSTANCE.getStorage().getParty((ServerPlayer)player);
        PokemonRef refValue = (PokemonRef)arg.getOrDefault(DataManage.CALYREX_DATA, null);
        Pokemon currentValue = refValue == null ? null : refValue.getPokemon();
        if (pokemon.getSpecies().getName().equals("Calyrex") && this.checkEnabled(pokemon)) {
            if (arg.get(DataManage.CALYREX_DATA) != null) {
                player.displayClientMessage((Component)Component.literal((String)"Already fused!").withColor(0xFF0000), true);
                return InteractionResult.PASS;
            }
            Unity.particleEffect((LivingEntity)pk, ParticleTypes.END_ROD);
            new FlagSpeciesFeature("shadow", false).apply(pokemon);
            new FlagSpeciesFeature("ice", false).apply(pokemon);
            pokemon.setTradeable(true);
            if (!pokemon.getEntity().hasData(DataManage.CALYREX_FUSED_WITH)) {
                HashMap map = (HashMap)player.getData(DataManage.DATA_MAP);
                Pokemon toAdd = (Pokemon)map.get(pokemon.getUuid());
                playerPartyStore.add(toAdd);
                map.remove(pokemon.getUuid());
                player.setData(DataManage.DATA_MAP, (Object)map);
            } else {
                playerPartyStore.add((Pokemon)pokemon.getEntity().getData(DataManage.CALYREX_FUSED_WITH));
                pokemon.getEntity().removeData(DataManage.CALYREX_FUSED_WITH);
            }
            arg.set(DataManage.CALYREX_DATA, null);
            arg.set(DataComponents.CUSTOM_NAME, (Object)Component.translatable((String)"item.mega_showdown.reins_of_unity.inactive"));
        } else if (currentValue != null && pokemon.getSpecies().getName().equals("Calyrex")) {
            if (currentValue.getSpecies().getName().equals("Spectrier")) {
                Unity.particleEffect((LivingEntity)pk, ParticleTypes.SMOKE);
                new FlagSpeciesFeature("shadow", true).apply(pokemon);
            } else {
                Unity.particleEffect((LivingEntity)pk, ParticleTypes.END_ROD);
                new FlagSpeciesFeature("ice", true).apply(pokemon);
            }
            pokemon.setTradeable(false);
            pokemon.getEntity().setData(DataManage.CALYREX_FUSED_WITH, (Object)currentValue);
            HashMap map = (HashMap)player.getData(DataManage.DATA_MAP);
            map.put(pokemon.getUuid(), currentValue);
            player.setData(DataManage.DATA_MAP, (Object)map);
            arg.set(DataManage.CALYREX_DATA, null);
            AdvancementHelper.grantAdvancement((ServerPlayer)player, "fusion");
            arg.set(DataComponents.CUSTOM_NAME, (Object)Component.translatable((String)"item.mega_showdown.reins_of_unity.inactive"));
        } else if (currentValue == null && pokemon.getSpecies().getName().equals("Spectrier")) {
            arg.set(DataManage.CALYREX_DATA, (Object)new PokemonRef(pk.getPokemon()));
            playerPartyStore.remove(pk.getPokemon());
            arg.set(DataComponents.CUSTOM_NAME, (Object)Component.translatable((String)"item.mega_showdown.reins_of_unity.charged"));
        } else if (currentValue == null && pokemon.getSpecies().getName().equals("Glastrier")) {
            arg.set(DataManage.CALYREX_DATA, (Object)new PokemonRef(pk.getPokemon()));
            playerPartyStore.remove(pk.getPokemon());
            arg.set(DataComponents.CUSTOM_NAME, (Object)Component.translatable((String)"item.mega_showdown.reins_of_unity.charged"));
        } else {
            return InteractionResult.PASS;
        }
        player.setItemInHand(hand, arg);
        player.getInventory().setChanged();
        return InteractionResult.SUCCESS;
    }

    private boolean checkEnabled(Pokemon pokemon) {
        boolean enabled;
        FlagSpeciesFeatureProvider featureProvider = new FlagSpeciesFeatureProvider(List.of("shadow"));
        FlagSpeciesFeature feature = featureProvider.get(pokemon);
        if (feature != null && (enabled = featureProvider.get(pokemon).getEnabled())) {
            return true;
        }
        featureProvider = new FlagSpeciesFeatureProvider(List.of("ice"));
        feature = featureProvider.get(pokemon);
        return feature != null && (enabled = featureProvider.get(pokemon).getEnabled());
    }

    public static void particleEffect(LivingEntity conComponent, SimpleParticleType particleType) {
        Level level = conComponent.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            Vec3 entityPos = conComponent.position();
            double entityWidth = conComponent.getBbWidth();
            double entityHeight = conComponent.getBbHeight();
            double entityDepth = entityWidth;
            double scaleFactor = 2.0;
            double adjustedWidth = entityWidth * scaleFactor;
            double adjustedHeight = entityHeight * scaleFactor;
            double adjustedDepth = entityDepth * scaleFactor;
            serverLevel.playSound(null, entityPos.x, entityPos.y, entityPos.z, SoundEvents.AMETHYST_BLOCK_CHIME, SoundSource.PLAYERS, 1.5f, 0.5f + (float)Math.random() * 0.5f);
            int particleCount = (int)(175.0 * adjustedWidth * adjustedHeight);
            for (int i = 0; i < particleCount; ++i) {
                double xOffset = (Math.random() - 0.5) * adjustedWidth;
                double yOffset = Math.random() * adjustedHeight;
                double zOffset = (Math.random() - 0.5) * adjustedDepth;
                serverLevel.sendParticles((ParticleOptions)particleType, entityPos.x + xOffset, entityPos.y + yOffset, entityPos.z + zOffset, 1, 0.0, 0.0, 0.0, 0.1);
            }
        }
    }

    public void onDestroyed(ItemEntity entity, DamageSource damageSource) {
        Entity entity2 = entity.getOwner();
        if (entity2 instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity2;
            PokemonRef refValue = (PokemonRef)entity.getItem().getOrDefault(DataManage.CALYREX_DATA, null);
            Pokemon currentValue = refValue == null ? null : refValue.getPokemon();
            PlayerPartyStore playerPartyStore = Cobblemon.INSTANCE.getStorage().getParty(player);
            if (currentValue != null) {
                playerPartyStore.add(currentValue);
                entity.getItem().set(DataManage.CALYREX_DATA, null);
            }
        }
        super.onDestroyed(entity, damageSource);
    }
}

